/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearMonthBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchLocalDateBridge
extends ElasticsearchTemporalAccessorStringBridge<LocalDate> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchYearMonthBridge.FORMATTER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchLocalDateBridge INSTANCE = new ElasticsearchLocalDateBridge();

    private ElasticsearchLocalDateBridge() {
        super(FORMATTER, LocalDate.class);
    }

    @Override
    LocalDate parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return LocalDate.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForLocalDate(e);
    }
}

