/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.capsule;

import com.oracle.graal.python.builtins.modules.cext.PythonCextCapsuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.nodes.arrow.ArrowArray;
import com.oracle.graal.python.nodes.arrow.release_callback.ArrowArrayReleaseCallbackNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

@ExportLibrary(value=InteropLibrary.class)
public class ArrowArrayCapsuleDestructor
implements TruffleObject {
    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(guards={"isPointer(args, interopLib)"})
        static Object doRelease(ArrowArrayCapsuleDestructor self, Object[] args, @CachedLibrary(limit="1") InteropLibrary interopLib, @Bind(value="$node") Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode nativeToPythonNode, @Cached PythonCextCapsuleBuiltins.PyCapsuleGetPointerNode capsuleGetPointerNode, @Cached ArrowArrayReleaseCallbackNode arrayReleaseNode) {
            CArrayWrappers.CByteArrayWrapper capsuleName;
            Object capsule = nativeToPythonNode.execute(args[0]);
            long arrowArrayPointer = (Long)capsuleGetPointerNode.execute(inliningTarget, capsule, capsuleName = new CArrayWrappers.CByteArrayWrapper(ArrowArray.CAPSULE_NAME));
            ArrowArray arrowArray = ArrowArray.wrap(arrowArrayPointer);
            if (!arrowArray.isReleased()) {
                arrayReleaseNode.execute(inliningTarget, arrowArray);
            }
            PythonContext.get(inliningTarget).getUnsafe().freeMemory(arrowArrayPointer);
            return PNone.NO_VALUE;
        }

        @Fallback
        static Object doError(ArrowArrayCapsuleDestructor self, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        static boolean isPointer(Object[] args, InteropLibrary interopLib) {
            return args.length == 1 && interopLib.isPointer(args[0]);
        }
    }
}

