/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument.keywords;

import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ConcatDictToStorageNode
extends PNodeWithContext {
    public abstract HashingStorage execute(VirtualFrame var1, HashingStorage var2, Object var3) throws SameDictKeyException, NonMappingException;

    @Specialization(guards={"hasBuiltinDictIter(inliningTarget, other, getClassNode, lookupIter)"}, limit="1")
    static HashingStorage doBuiltinDictEmptyDest(EmptyStorage dest, PDict other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="lookupIter") @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
        return copyNode.execute(inliningTarget, other.getDictStorage());
    }

    @Specialization(guards={"hasBuiltinDictIter(inliningTarget, other, getClassNode, lookupIter)"}, limit="1")
    static HashingStorage doBuiltinDict(VirtualFrame frame, HashingStorage dest, PDict other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="lookupIter") @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem resultGetItem, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem resultSetItem, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iterKey, @Cached HashingStorageNodes.HashingStorageIteratorValue iterValue, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached.Exclusive @Cached InlinedBranchProfile sameKeyProfile) throws SameDictKeyException {
        HashingStorage result = dest;
        HashingStorage otherStorage = other.getDictStorage();
        HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, otherStorage);
        while (loopProfile.profile(inliningTarget, iterNext.execute(inliningTarget, otherStorage, it))) {
            Object key = iterKey.execute(inliningTarget, otherStorage, it);
            Object value = iterValue.execute(inliningTarget, otherStorage, it);
            if (resultGetItem.hasKey((Frame)frame, inliningTarget, result, key)) {
                sameKeyProfile.enter(inliningTarget);
                TruffleString keyName = castToStringNode.cast(inliningTarget, key, ErrorMessages.KEYWORDS_S_MUST_BE_STRINGS, new Object[0]);
                throw new SameDictKeyException(keyName);
            }
            result = resultSetItem.execute((Frame)frame, inliningTarget, result, key, value);
        }
        return result;
    }

    static boolean isFallback(Node inliningTarget, Object other, GetClassNode.GetPythonObjectClassNode getClassNode, LookupCallableSlotInMRONode lookupIter) {
        PDict otherDict;
        return !(other instanceof PDict && PGuards.hasBuiltinDictIter(inliningTarget, otherDict = (PDict)other, getClassNode, lookupIter));
    }

    @Specialization(guards={"isFallback(inliningTarget, other, getClassNode, lookupIter)"}, limit="1")
    static HashingStorage doMapping(VirtualFrame frame, HashingStorage dest, Object other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="lookupIter") @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached InlinedBranchProfile sameKeyProfile, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached PyObjectCallMethodObjArgs callKeys, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached ListNodes.FastConstructListNode asList, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem resultGetItem, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem resultSetItem, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorage, @Cached SequenceStorageNodes.GetItemScalarNode sequenceGetItem, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached PyObjectGetItem getItem) throws SameDictKeyException, NonMappingException {
        HashingStorage result = dest;
        try {
            PSequence keys = asList.execute((Frame)frame, inliningTarget, callKeys.execute((Frame)frame, inliningTarget, other, SpecialMethodNames.T_KEYS, new Object[0]));
            SequenceStorage keysStorage = getSequenceStorage.execute(inliningTarget, keys);
            int keysLen = keysStorage.length();
            loopProfile.profileCounted(inliningTarget, (long)keysLen);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < keysLen)) {
                Object key = sequenceGetItem.execute(inliningTarget, keysStorage, i);
                if (resultGetItem.hasKey((Frame)frame, inliningTarget, result, key)) {
                    sameKeyProfile.enter(inliningTarget);
                    TruffleString keyName = castToStringNode.cast(inliningTarget, key, ErrorMessages.KEYWORDS_S_MUST_BE_STRINGS, new Object[0]);
                    throw new SameDictKeyException(keyName);
                }
                Object value = getItem.execute((Frame)frame, inliningTarget, other, key);
                result = resultSetItem.execute((Frame)frame, inliningTarget, result, key, value);
                ++i;
            }
            return result;
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, errorProfile);
            throw new NonMappingException(other);
        }
    }
}

