/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.sst;

import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;

public abstract class StmtTy
extends SSTNode {
    StmtTy(SourceRange sourceRange) {
        super(sourceRange);
    }

    public static final class Continue
    extends StmtTy {
        public Continue(SourceRange sourceRange) {
            super(sourceRange);
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Break
    extends StmtTy {
        public Break(SourceRange sourceRange) {
            super(sourceRange);
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Pass
    extends StmtTy {
        public Pass(SourceRange sourceRange) {
            super(sourceRange);
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Expr
    extends StmtTy {
        public final ExprTy value;

        public Expr(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Nonlocal
    extends StmtTy {
        public final String[] names;

        public Nonlocal(String[] names, SourceRange sourceRange) {
            super(sourceRange);
            this.names = names;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Global
    extends StmtTy {
        public final String[] names;

        public Global(String[] names, SourceRange sourceRange) {
            super(sourceRange);
            this.names = names;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class ImportFrom
    extends StmtTy {
        public final String module;
        public final AliasTy[] names;
        public final int level;

        public ImportFrom(String module, AliasTy[] names, int level, SourceRange sourceRange) {
            super(sourceRange);
            this.module = module;
            this.names = names;
            this.level = level;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Import
    extends StmtTy {
        public final AliasTy[] names;

        public Import(AliasTy[] names, SourceRange sourceRange) {
            super(sourceRange);
            this.names = names;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Assert
    extends StmtTy {
        public final ExprTy test;
        public final ExprTy msg;

        public Assert(ExprTy test, ExprTy msg, SourceRange sourceRange) {
            super(sourceRange);
            assert (test != null);
            this.test = test;
            this.msg = msg;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Try
    extends StmtTy {
        public final StmtTy[] body;
        public final ExceptHandlerTy[] handlers;
        public final StmtTy[] orElse;
        public final StmtTy[] finalBody;

        public Try(StmtTy[] body, ExceptHandlerTy[] handlers, StmtTy[] orElse, StmtTy[] finalBody, SourceRange sourceRange) {
            super(sourceRange);
            this.body = body;
            this.handlers = handlers;
            this.orElse = orElse;
            this.finalBody = finalBody;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Raise
    extends StmtTy {
        public final ExprTy exc;
        public final ExprTy cause;

        public Raise(ExprTy exc, ExprTy cause, SourceRange sourceRange) {
            super(sourceRange);
            this.exc = exc;
            this.cause = cause;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Match
    extends StmtTy {
        public final ExprTy subject;
        public final MatchCaseTy[] cases;

        public Match(ExprTy subject, MatchCaseTy[] cases, SourceRange sourceRange) {
            super(sourceRange);
            assert (subject != null);
            this.subject = subject;
            this.cases = cases;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class AsyncWith
    extends StmtTy {
        public final WithItemTy[] items;
        public final StmtTy[] body;
        public final Object typeComment;

        public AsyncWith(WithItemTy[] items, StmtTy[] body, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            this.items = items;
            this.body = body;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class With
    extends StmtTy {
        public final WithItemTy[] items;
        public final StmtTy[] body;
        public final Object typeComment;

        public With(WithItemTy[] items, StmtTy[] body, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            this.items = items;
            this.body = body;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class If
    extends StmtTy {
        public final ExprTy test;
        public final StmtTy[] body;
        public final StmtTy[] orElse;

        public If(ExprTy test, StmtTy[] body, StmtTy[] orElse, SourceRange sourceRange) {
            super(sourceRange);
            assert (test != null);
            this.test = test;
            this.body = body;
            this.orElse = orElse;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class While
    extends StmtTy {
        public final ExprTy test;
        public final StmtTy[] body;
        public final StmtTy[] orElse;

        public While(ExprTy test, StmtTy[] body, StmtTy[] orElse, SourceRange sourceRange) {
            super(sourceRange);
            assert (test != null);
            this.test = test;
            this.body = body;
            this.orElse = orElse;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class AsyncFor
    extends StmtTy {
        public final ExprTy target;
        public final ExprTy iter;
        public final StmtTy[] body;
        public final StmtTy[] orElse;
        public final Object typeComment;

        public AsyncFor(ExprTy target, ExprTy iter, StmtTy[] body, StmtTy[] orElse, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            assert (target != null);
            this.target = target;
            assert (iter != null);
            this.iter = iter;
            this.body = body;
            this.orElse = orElse;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class For
    extends StmtTy {
        public final ExprTy target;
        public final ExprTy iter;
        public final StmtTy[] body;
        public final StmtTy[] orElse;
        public final Object typeComment;

        public For(ExprTy target, ExprTy iter, StmtTy[] body, StmtTy[] orElse, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            assert (target != null);
            this.target = target;
            assert (iter != null);
            this.iter = iter;
            this.body = body;
            this.orElse = orElse;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class AnnAssign
    extends StmtTy {
        public final ExprTy target;
        public final ExprTy annotation;
        public final ExprTy value;
        public final boolean isSimple;

        public AnnAssign(ExprTy target, ExprTy annotation, ExprTy value, boolean isSimple, SourceRange sourceRange) {
            super(sourceRange);
            assert (target != null);
            this.target = target;
            assert (annotation != null);
            this.annotation = annotation;
            this.value = value;
            this.isSimple = isSimple;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class AugAssign
    extends StmtTy {
        public final ExprTy target;
        public final OperatorTy op;
        public final ExprTy value;

        public AugAssign(ExprTy target, OperatorTy op, ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (target != null);
            this.target = target;
            assert (op != null);
            this.op = op;
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Assign
    extends StmtTy {
        public final ExprTy[] targets;
        public final ExprTy value;
        public final Object typeComment;

        public Assign(ExprTy[] targets, ExprTy value, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            this.targets = targets;
            assert (value != null);
            this.value = value;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Delete
    extends StmtTy {
        public final ExprTy[] targets;

        public Delete(ExprTy[] targets, SourceRange sourceRange) {
            super(sourceRange);
            this.targets = targets;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Return
    extends StmtTy {
        public final ExprTy value;

        public Return(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class ClassDef
    extends StmtTy {
        public final String name;
        public final ExprTy[] bases;
        public final KeywordTy[] keywords;
        public final StmtTy[] body;
        public final ExprTy[] decoratorList;

        public ClassDef(String name, ExprTy[] bases, KeywordTy[] keywords, StmtTy[] body, ExprTy[] decoratorList, SourceRange sourceRange) {
            super(sourceRange);
            assert (name != null);
            this.name = name;
            this.bases = bases;
            this.keywords = keywords;
            this.body = body;
            this.decoratorList = decoratorList;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class AsyncFunctionDef
    extends StmtTy {
        public final String name;
        public final ArgumentsTy args;
        public final StmtTy[] body;
        public final ExprTy[] decoratorList;
        public final ExprTy returns;
        public final Object typeComment;

        public AsyncFunctionDef(String name, ArgumentsTy args, StmtTy[] body, ExprTy[] decoratorList, ExprTy returns, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            assert (name != null);
            this.name = name;
            assert (args != null);
            this.args = args;
            this.body = body;
            this.decoratorList = decoratorList;
            this.returns = returns;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class FunctionDef
    extends StmtTy {
        public final String name;
        public final ArgumentsTy args;
        public final StmtTy[] body;
        public final ExprTy[] decoratorList;
        public final ExprTy returns;
        public final Object typeComment;

        public FunctionDef(String name, ArgumentsTy args, StmtTy[] body, ExprTy[] decoratorList, ExprTy returns, Object typeComment, SourceRange sourceRange) {
            super(sourceRange);
            assert (name != null);
            this.name = name;
            assert (args != null);
            this.args = args;
            this.body = body;
            this.decoratorList = decoratorList;
            this.returns = returns;
            this.typeComment = typeComment;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }
}

