/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class, PythonOptions.class, SpecialMethodNames.class, SpecialAttributeNames.class, BuiltinNames.class})
public abstract class ArgumentCastNode
extends Node {
    public abstract Object execute(VirtualFrame var1, Object var2);

    protected static boolean isHandledPNone(boolean useDefaultForNone, Object value) {
        if (useDefaultForNone) {
            return PGuards.isPNone(value);
        }
        return PGuards.isNoValue(value);
    }

    public final PythonLanguage getLanguage() {
        return PythonLanguage.get(this);
    }

    public final PythonContext getContext() {
        return PythonContext.get(this);
    }

    public static abstract class ArgumentCastNodeWithRaiseAndIndirectCall
    extends ArgumentCastNodeWithRaise
    implements IndirectCallNode {
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedExceptionState;
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedMyFrame;

        @Override
        public final Assumption needNotPassFrameAssumption() {
            if (this.nativeCodeDoesntNeedMyFrame == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
            }
            return this.nativeCodeDoesntNeedMyFrame;
        }

        @Override
        public final Assumption needNotPassExceptionAssumption() {
            if (this.nativeCodeDoesntNeedExceptionState == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
            }
            return this.nativeCodeDoesntNeedExceptionState;
        }
    }

    public static abstract class ArgumentCastNodeWithRaise
    extends ArgumentCastNode {
        @Node.Child
        private PRaiseNode raiseNode;

        public PException raise(PythonBuiltinClassType type, TruffleString string) {
            return this.getRaiseNode().raise(type, string);
        }

        public final PException raise(PythonBuiltinClassType type, PBaseException cause, TruffleString format, Object ... arguments) {
            return this.getRaiseNode().raiseWithCause(type, cause, format, arguments);
        }

        public final PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
            return this.getRaiseNode().raise(type, format, arguments);
        }

        public final PRaiseNode getRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }
    }
}

