/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONodeFactory;
import com.oracle.graal.python.nodes.attributes.LookupInMROBaseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PythonOptions.class, PythonLanguage.class})
public abstract class LookupCallableSlotInMRONode
extends LookupInMROBaseNode {
    @NeverDefault
    public static LookupCallableSlotInMRONode create(SpecialMethodSlot slot) {
        return LookupCallableSlotInMRONodeFactory.CachedLookupNodeGen.create(slot);
    }

    public static LookupCallableSlotInMRONode getUncached(SpecialMethodSlot slot) {
        return UncachedLookup.UNCACHEDS[slot.ordinal()];
    }

    protected static abstract class CachedLookup
    extends LookupCallableSlotInMRONode {
        protected final SpecialMethodSlot slot;

        protected CachedLookup(SpecialMethodSlot slot) {
            this.slot = slot;
        }

        @Specialization(guards={"klass == cachedKlass", "result != null"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doBuiltinTypeCached(PythonBuiltinClassType klass, @Cached(value="klass") PythonBuiltinClassType cachedKlass, @Cached(value="slot.getValue(klass)") Object result) {
            assert (CachedLookup.isCacheable(result)) : result;
            return result;
        }

        @Specialization(guards={"isSingleContext()", "klass == cachedKlass"}, assumptions={"cachedKlass.getSlotsFinalAssumption()"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doSlotCachedSingleCtx(PythonClass klass, @Cached(value="klass", weak=true) PythonClass cachedKlass, @Cached(value="slot.getValue(klass)", weak=true) Object result) {
            return result;
        }

        @Specialization(guards={"isSingleContext()", "klass == cachedKlass"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doBuiltinCachedSingleCtx(PythonBuiltinClass klass, @Cached(value="klass") PythonBuiltinClass cachedKlass, @Cached(value="slot.getValue(klass)") Object result) {
            return result;
        }

        @Specialization(guards={"isSingleContext()", "klassType == cachedKlassType", "slot.getValue(cachedKlassType) == null"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doBuiltinTypeCachedSingleCtx(PythonBuiltinClassType klassType, @Cached(value="klassType") PythonBuiltinClassType cachedKlassType, @Cached(value="slot.getValue(getContext().lookupType(cachedKlassType))") Object value) {
            return value;
        }

        @Specialization(replaces={"doSlotCachedSingleCtx"}, guards={"slot.getValue(klass) == result", "isCacheable(result)"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doSlotCachedMultiCtx(PythonClass klass, @Cached(value="slot.getValue(klass)") Object result) {
            return result;
        }

        @Specialization(replaces={"doSlotCachedMultiCtx"})
        Object doSlotUncachedMultiCtx(PythonClass klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="slotValueProfile") @Cached SlotValueProfile slotValueProfile) {
            return slotValueProfile.profile(inliningTarget, this.slot.getValue(klass));
        }

        @Idempotent
        protected static boolean isCacheable(Object value) {
            return PythonLanguage.canCache(value) || BuiltinMethodDescriptor.isInstance(value);
        }

        @Specialization(guards={"klass.getType() == cachedType", "isCacheable(result)"}, replaces={"doBuiltinCachedSingleCtx"}, limit="getAttributeAccessInlineCacheMaxDepth()")
        static Object doBuiltinCachedMultiCtx(PythonBuiltinClass klass, @Cached(value="klass.getType()") PythonBuiltinClassType cachedType, @Cached(value="slot.getValue(klass)") Object result) {
            return result;
        }

        @Specialization(replaces={"doBuiltinCachedSingleCtx", "doBuiltinCachedMultiCtx"})
        Object doBuiltinUncachableMultiCtx(PythonBuiltinClass klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="slotValueProfile") @Cached SlotValueProfile slotValueProfile) {
            return slotValueProfile.profile(inliningTarget, this.slot.getValue(klass));
        }

        @Specialization(guards={"klassType == cachedKlassType", "slot.getValue(cachedKlassType) == null"}, limit="1")
        static Object doBuiltinTypeMultiContext(PythonBuiltinClassType klassType, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SlotValueProfile slotValueProfile, @Cached(value="klassType") PythonBuiltinClassType cachedKlassType, @Bind(value="slot.getValue(getContext().lookupType(cachedKlassType))") Object value) {
            return slotValueProfile.profile(inliningTarget, value);
        }

        @Specialization(replaces={"doBuiltinTypeCached", "doBuiltinTypeCachedSingleCtx", "doBuiltinTypeMultiContext"})
        Object doBuiltinTypeGeneric(PythonBuiltinClassType klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="slotValueProfile") @Cached SlotValueProfile slotValueProfile) {
            Object result = this.slot.getValue(klass);
            if (result == null) {
                result = this.slot.getValue(PythonContext.get(this).lookupType(klass));
            }
            return slotValueProfile.profile(inliningTarget, result);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object doNativeClass(PythonAbstractNativeObject klass, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="slotValueProfile") @Cached SlotValueProfile slotValueProfile, @Cached(value="create(slot.getName())") LookupAttributeInMRONode lookup) {
            return slotValueProfile.profile(inliningTarget, lookup.execute(klass));
        }
    }

    protected static final class UncachedLookup
    extends LookupCallableSlotInMRONode {
        private final SpecialMethodSlot slot;
        private static final UncachedLookup[] UNCACHEDS = new UncachedLookup[SpecialMethodSlot.values().length];

        private UncachedLookup(SpecialMethodSlot slot) {
            this.slot = slot;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final Object execute(Object klass) {
            if (klass instanceof PythonBuiltinClassType) {
                Object result = this.slot.getValue((PythonBuiltinClassType)((Object)klass));
                if (result == null) {
                    result = this.slot.getValue(PythonContext.get(null).lookupType((PythonBuiltinClassType)((Object)klass)));
                }
                return result;
            }
            if (klass instanceof PythonManagedClass) {
                return this.slot.getValue((PythonManagedClass)klass);
            }
            assert (klass instanceof PythonAbstractNativeObject);
            return LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, this.slot.getName());
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            SpecialMethodSlot[] values = SpecialMethodSlot.values();
            for (int i = 0; i < values.length; ++i) {
                SpecialMethodSlot slot = values[i];
                UncachedLookup.UNCACHEDS[i] = new UncachedLookup(slot);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    protected static abstract class SlotValueProfile
    extends Node {
        protected SlotValueProfile() {
        }

        final Object profile(Node inliningTarget, Object value) {
            return this.execute(inliningTarget, value);
        }

        abstract Object execute(Node var1, Object var2);

        @Specialization
        static BuiltinMethodDescriptor.UnaryBuiltinDescriptor unaryDescr(BuiltinMethodDescriptor.UnaryBuiltinDescriptor value) {
            return value;
        }

        @Specialization
        static BuiltinMethodDescriptor.BinaryBuiltinDescriptor binaryDescr(BuiltinMethodDescriptor.BinaryBuiltinDescriptor value) {
            return value;
        }

        @Specialization
        static BuiltinMethodDescriptor.TernaryBuiltinDescriptor ternaryDescr(BuiltinMethodDescriptor.TernaryBuiltinDescriptor value) {
            return value;
        }

        @Specialization
        static PBuiltinFunction builtin(PBuiltinFunction builtin) {
            return builtin;
        }

        @Specialization
        static PFunction fun(PFunction fun) {
            return fun;
        }

        @Specialization(guards={"isNoValue(none)"})
        static PNone noValue(PNone none) {
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"isNone(none)"})
        static PNone none(PNone none) {
            return PNone.NONE;
        }

        @Specialization(replaces={"unaryDescr", "binaryDescr", "ternaryDescr", "builtin", "fun", "noValue", "none"})
        static Object other(Object value) {
            return value;
        }
    }
}

