/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyLongAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyLongAsDoubleNode
extends PNodeWithContext {
    public static Object executeUncached(Object object) {
        return PyLongAsDoubleNodeGen.getUncached().execute(null, object);
    }

    public abstract Object execute(Node var1, Object var2);

    @Specialization
    static double doBoolean(boolean self) {
        return self ? 1.0 : 0.0;
    }

    @Specialization
    static double doInt(int self) {
        return self;
    }

    @Specialization
    static double doLong(long self) {
        return self;
    }

    @Specialization
    double doPInt(PInt self) {
        return self.doubleValueWithOverflow(PRaiseNode.getUncached());
    }

    @Fallback
    Object fallback(Object object) {
        if (!PyLongCheckNode.executeUncached(object)) {
            throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
        }
        return PNotImplemented.NOT_IMPLEMENTED;
    }
}

