/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructorsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.AbstractFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInheritedSlotNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectGetBasesNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectIsSubclassNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.SplitArgsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PythonClass})
public final class TypeBuiltins
extends PythonBuiltins {
    public static final HiddenKey TYPE_DICTOFFSET = new HiddenKey("__dictoffset__");
    public static final HiddenKey TYPE_WEAKLISTOFFSET = new HiddenKey("__weaklistoffset__");
    public static final HiddenKey TYPE_ITEMSIZE = new HiddenKey("__itemsize__");
    public static final HiddenKey TYPE_BASICSIZE = new HiddenKey("__basicsize__");
    public static final HiddenKey TYPE_ALLOC = new HiddenKey("__alloc__");
    public static final HiddenKey TYPE_DEALLOC = new HiddenKey("__dealloc__");
    public static final HiddenKey TYPE_DEL = new HiddenKey("__del__");
    public static final HiddenKey TYPE_FREE = new HiddenKey("__free__");
    public static final HiddenKey TYPE_AS_BUFFER = new HiddenKey("__tp_as_buffer__");
    public static final HiddenKey TYPE_FLAGS = new HiddenKey("__flags__");
    public static final HiddenKey TYPE_VECTORCALL_OFFSET = new HiddenKey("__vectorcalloffset__");
    public static final HiddenKey TYPE_GETBUFFER = new HiddenKey("__getbuffer__");
    public static final HiddenKey TYPE_RELEASEBUFFER = new HiddenKey("__releasebuffer__");
    private static final HiddenKey TYPE_DOC = new HiddenKey("__doc__");
    public static final HashMap<String, HiddenKey> INITIAL_HIDDEN_TYPE_KEYS = new HashMap();

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypeBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(TYPE_DOC, (Object)"type(object_or_name, bases, dict)\ntype(object) -> the object's type\ntype(name, bases, dict) -> a new type");
    }

    static {
        for (HiddenKey key : new HiddenKey[]{TYPE_DICTOFFSET, TYPE_ITEMSIZE, TYPE_BASICSIZE, TYPE_ALLOC, TYPE_DEALLOC, TYPE_DEL, TYPE_FREE, TYPE_FLAGS, TYPE_VECTORCALL_OFFSET, TYPE_DOC}) {
            INITIAL_HIDDEN_TYPE_KEYS.put(key.getName(), key);
        }
    }

    @Builtin(name="__text_signature__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class TextSignatureNode
    extends PythonUnaryBuiltinNode {
        TextSignatureNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object signature(Object type) {
            if (!(type instanceof PythonBuiltinClassType) && !(type instanceof PythonBuiltinClass)) {
                return PNone.NONE;
            }
            ValueProfile profile = ValueProfile.getUncached();
            if (ObjectBuiltins.InitNode.overridesBuiltinMethod(type, profile, LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.New), profile, BuiltinConstructorsFactory.ObjectNodeFactory.class)) {
                return TextSignatureNode.fromMethod(LookupAttributeInMRONode.Dynamic.getUncached().execute(type, SpecialMethodNames.T___NEW__));
            }
            if (ObjectBuiltins.InitNode.overridesBuiltinMethod(type, profile, LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.Init), profile, ObjectBuiltinsFactory.InitNodeFactory.class)) {
                return TextSignatureNode.fromMethod(LookupAttributeInMRONode.Dynamic.getUncached().execute(type, SpecialMethodNames.T___INIT__));
            }
            return StringLiterals.T_EMPTY_PARENS;
        }

        private static Object fromMethod(Object method) {
            if (method instanceof PBuiltinFunction || method instanceof PBuiltinMethod || method instanceof PFunction || method instanceof PMethod) {
                Signature signature = FunctionNodes.GetSignatureNode.executeUncached(method);
                return AbstractFunctionBuiltins.TextSignatureNode.signatureToText(signature, true);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__annotations__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class AnnotationsNode
    extends PythonBinaryBuiltinNode {
        AnnotationsNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        Object get(Object self, Object value, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                annotations = this.factory().createDict();
                try {
                    write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, annotations);
                }
                catch (PException e) {
                    throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, self, SpecialAttributeNames.T___ANNOTATIONS__);
                }
            }
            return annotations;
        }

        @Specialization(guards={"isDeleteMarker(value)"})
        Object delete(Object self, Object value, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            try {
                write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, (Object)PNone.NO_VALUE);
            }
            catch (PException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___ANNOTATIONS__, self);
            }
            if (annotations == PNone.NO_VALUE) {
                throw this.raise(PythonErrorType.AttributeError, new Object[]{SpecialAttributeNames.T___ANNOTATIONS__});
            }
            return PNone.NONE;
        }

        @Fallback
        Object set(Object self, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
            try {
                write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, value);
            }
            catch (PException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___ANNOTATIONS__, self);
            }
            return PNone.NONE;
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        OrNode() {
        }

        @Specialization
        Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1, doc="__dir__ for type objects\n\n\tThis includes all attributes of klass and all of the base\n\tclasses recursively.")
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object dir(VirtualFrame frame, Object klass, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode, @Cached com.oracle.graal.python.nodes.call.CallNode callNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached(value="createGetAttrNode()") GetAttributeNode.GetFixedAttributeNode getBasesNode) {
            PSet names = this.dir(frame, inliningTarget, klass, lookupAttrNode, callNode, getBasesNode, toArrayNode);
            return names;
        }

        private PSet dir(VirtualFrame frame, Node inliningTarget, Object klass, PyObjectLookupAttr lookupAttrNode, com.oracle.graal.python.nodes.call.CallNode callNode, GetAttributeNode.GetFixedAttributeNode getBasesNode, SequenceStorageNodes.ToArrayNode toArrayNode) {
            Object basesAttr;
            PSet names = this.factory().createSet();
            Object updateCallable = lookupAttrNode.execute((Frame)frame, inliningTarget, names, SpecialMethodNames.T_UPDATE);
            Object ns = lookupAttrNode.execute((Frame)frame, inliningTarget, klass, SpecialAttributeNames.T___DICT__);
            if (ns != PNone.NO_VALUE) {
                callNode.execute((Frame)frame, updateCallable, ns);
            }
            if ((basesAttr = getBasesNode.execute(frame, klass)) instanceof PTuple) {
                Object[] bases;
                for (Object cls : bases = toArrayNode.execute(inliningTarget, ((PTuple)basesAttr).getSequenceStorage())) {
                    PSet baseNames = this.dir(frame, inliningTarget, cls, lookupAttrNode, callNode, getBasesNode, toArrayNode);
                    callNode.execute((Frame)frame, updateCallable, new Object[]{baseNames});
                }
            }
            return names;
        }

        @NeverDefault
        protected GetAttributeNode.GetFixedAttributeNode createGetAttrNode() {
            return GetAttributeNode.GetFixedAttributeNode.create(SpecialAttributeNames.T___BASES__);
        }
    }

    @Builtin(name="__abstractmethods__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class AbstractMethodsNode
    extends PythonBinaryBuiltinNode {
        AbstractMethodsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        Object get(Object self, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode) {
            Object result;
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass) && (result = readAttributeFromObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__)) != PNone.NO_VALUE) {
                return result;
            }
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_N_HAS_NO_ATTR_S, self, SpecialAttributeNames.T___ABSTRACTMETHODS__);
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        Object set(VirtualFrame frame, PythonClass self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached WriteAttributeToObjectNode writeAttributeToObjectNode) {
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass)) {
                writeAttributeToObjectNode.execute((Object)self, SpecialAttributeNames.T___ABSTRACTMETHODS__, value);
                self.setAbstractClass(isTrueNode.execute((Frame)frame, inliningTarget, value));
                return PNone.NONE;
            }
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object delete(PythonClass self, DescriptorDeleteMarker value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached.Exclusive @Cached WriteAttributeToObjectNode writeAttributeToObjectNode) {
            if (!isSameTypeNode.execute(inliningTarget, self, (Object)PythonBuiltinClassType.PythonClass) && readAttributeFromObjectNode.execute(self, SpecialAttributeNames.T___ABSTRACTMETHODS__) != PNone.NO_VALUE) {
                writeAttributeToObjectNode.execute((Object)self, SpecialAttributeNames.T___ABSTRACTMETHODS__, (Object)PNone.NO_VALUE);
                self.setAbstractClass(false);
                return PNone.NONE;
            }
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }

        @Fallback
        Object set(Object self, Object value) {
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__abstractmethods__", self);
        }
    }

    @Builtin(name="__flags__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FlagsNode
    extends PythonUnaryBuiltinNode {
        FlagsNode() {
        }

        @Specialization
        Object doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode) {
            if (PGuards.isClass(inliningTarget, self, isTypeNode)) {
                return getTypeFlagsNode.execute(self);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESC_FLAG_FOR_TYPE_DOESNT_APPLY_TO_OBJ, self);
        }
    }

    @Builtin(name="__basicsize__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BasicsizeNode
    extends PythonUnaryBuiltinNode {
        BasicsizeNode() {
        }

        @Specialization
        Object getBasicsizeType(Object cls, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetBasicSizeNode getBasicSizeNode) {
            return getBasicSizeNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__itemsize__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ItemsizeNode
    extends PythonUnaryBuiltinNode {
        ItemsizeNode() {
        }

        @Specialization
        static long getItemsizeType(Object cls, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetItemSizeNode getItemsizeNode) {
            return getItemsizeNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__dictoffset__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictoffsetNode
    extends PythonUnaryBuiltinNode {
        DictoffsetNode() {
        }

        @Specialization
        Object getDictoffsetType(Object cls, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetDictOffsetNode getDictOffsetNode) {
            return getDictOffsetNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    static abstract class QualNameNode
    extends AbstractSlotNode {
        QualNameNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getName(PythonBuiltinClassType cls, PNone value) {
            return cls.getName();
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getName(PythonManagedClass cls, PNone value) {
            return cls.getQualName();
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setName(PythonBuiltinClass cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }

        @Specialization(guards={"!isNoValue(value)", "!isPythonBuiltinClass(cls)"})
        Object setName(PythonClass cls, Object value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode) {
            try {
                cls.setQualName(castToStringNode.execute(inliningTarget, value));
                return PNone.NONE;
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_STR_TO_QUALNAME, cls, value);
            }
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getNative(PythonNativeClass cls, PNone value, @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode) {
            int nameLen;
            TruffleString tpName = getTpNameNode.readFromObj(cls, CFields.PyTypeObject__tp_name);
            int firstDot = indexOfCodePointNode.execute((AbstractTruffleString)tpName, 46, 0, nameLen = codePointLengthNode.execute((AbstractTruffleString)tpName, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (firstDot < 0) {
                return tpName;
            }
            return substringNode.execute((AbstractTruffleString)tpName, firstDot + 1, nameLen - firstDot - 1, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setNative(PythonNativeClass cls, Object value) {
            throw this.raise(PythonErrorType.RuntimeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "native type");
        }
    }

    @Builtin(name="__module__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    static abstract class ModuleNode
    extends AbstractSlotNode {
        ModuleNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getModuleType(PythonBuiltinClassType cls, PNone value) {
            TruffleString module = cls.getModuleName();
            return module == null ? BuiltinNames.T_BUILTINS : module;
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getModuleBuiltin(PythonBuiltinClass cls, PNone value) {
            return ModuleNode.getModuleType(cls.getType(), value);
        }

        @Specialization(guards={"isNoValue(value)"})
        Object getModule(PythonClass cls, PNone value, @Cached ReadAttributeFromObjectNode readAttrNode) {
            Object module = readAttrNode.execute(cls, SpecialAttributeNames.T___MODULE__);
            if (module == PNone.NO_VALUE) {
                throw this.raise(PythonErrorType.AttributeError);
            }
            return module;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setModule(PythonClass cls, Object value, @Cached WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute((Object)cls, SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        Object getModule(PythonNativeClass cls, PNone value, @Bind(value="this") Node inliningTarget, @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttr, @Cached.Shared @Cached TypeNodes.GetTypeFlagsNode getFlags, @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode) {
            int len;
            if ((getFlags.execute(cls) & 0x200L) != 0L) {
                Object module = readAttr.execute(cls, SpecialAttributeNames.T___MODULE__);
                if (module == PNone.NO_VALUE) {
                    throw this.raise(PythonErrorType.AttributeError);
                }
                return module;
            }
            TruffleString tpName = getTpNameNode.readFromObj(cls, CFields.PyTypeObject__tp_name);
            int firstDot = indexOfCodePointNode.execute((AbstractTruffleString)tpName, 46, 0, len = codePointLengthNode.execute((AbstractTruffleString)tpName, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (firstDot < 0) {
                return BuiltinNames.T_BUILTINS;
            }
            return substringNode.execute((AbstractTruffleString)tpName, 0, firstDot, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setNative(PythonNativeClass cls, Object value, @Cached.Shared @Cached TypeNodes.GetTypeFlagsNode getFlags, @Cached(value="createForceType()") WriteAttributeToObjectNode writeAttr) {
            long flags = getFlags.execute(cls);
            if ((flags & 0x200L) == 0L) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_N_S, cls, SpecialAttributeNames.T___MODULE__);
            }
            writeAttr.execute((Object)cls, SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setModuleType(PythonBuiltinClassType cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setModuleBuiltin(PythonBuiltinClass cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    static abstract class NameNode
    extends AbstractSlotNode {
        NameNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getNameType(PythonBuiltinClassType cls, PNone value) {
            return cls.getName();
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString getNameBuiltin(PythonManagedClass cls, PNone value) {
            return cls.getName();
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setName(PythonBuiltinClassType cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object setName(PythonBuiltinClass cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "built-in/extension 'type'");
        }

        @Specialization(guards={"!isNoValue(value)", "!isPythonBuiltinClass(cls)"})
        Object setName(VirtualFrame frame, PythonClass cls, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.IsValidNode isValidNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode) {
            try {
                TruffleString string = castToTruffleStringNode.execute(inliningTarget, value);
                if (indexOfCodePointNode.execute((AbstractTruffleString)string, 0, 0, codePointLengthNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TYPE_NAME_NO_NULL_CHARS);
                }
                if (!isValidNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING)) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseUnicodeEncodeError((Frame)frame, "utf-8", string, 0, string.codePointLengthUncached(PythonUtils.TS_ENCODING), "can't encode classname");
                }
                cls.setName(string);
                return PNone.NONE;
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_S_TO_P_S_NOT_P, "string", cls, SpecialAttributeNames.T___NAME__, value);
            }
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getModule(PythonAbstractNativeObject cls, PNone value, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode) {
            int nameLen;
            TruffleString tpName = getTpNameNode.readFromObj(cls, CFields.PyTypeObject__tp_name);
            int firstDot = indexOfCodePointNode.execute((AbstractTruffleString)tpName, 46, 0, nameLen = codePointLengthNode.execute((AbstractTruffleString)tpName, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (firstDot < 0) {
                return tpName;
            }
            return substringNode.execute((AbstractTruffleString)tpName, firstDot + 1, nameLen - firstDot - 1, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object getModule(PythonAbstractNativeObject cls, Object value) {
            throw this.raise(PythonErrorType.RuntimeError, ErrorMessages.CANT_SET_ATTRIBUTES_OF_TYPE, "native type");
        }
    }

    @GenerateNodeFactory
    @TypeSystemReference(value=PythonTypes.class)
    static abstract class AbstractSlotNode
    extends PythonBinaryBuiltinNode {
        AbstractSlotNode() {
        }
    }

    @Builtin(name="__subclasses__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SubclassesNode
    extends PythonUnaryBuiltinNode {
        SubclassesNode() {
        }

        @Specialization
        PList getSubclasses(Object cls, @Bind(value="this") Node inliningTarget, @Cached(inline=true) TypeNodes.GetSubclassesAsArrayNode getSubclassesNode) {
            PythonAbstractClass[] array = getSubclassesNode.execute(inliningTarget, cls);
            Object[] classes = new Object[array.length];
            PythonUtils.arraycopy(array, 0, classes, 0, array.length);
            return this.factory().createList(classes);
        }
    }

    @Builtin(name="__subclasshook__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    static abstract class SubclassHookNode
    extends PythonBinaryBuiltinNode {
        SubclassHookNode() {
        }

        @Specialization
        Object hook(VirtualFrame frame, Object cls, Object subclass) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private IsSubtypeNode isSubtypeNode = IsSubtypeNode.create();
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getBasesAttrNode;
        @Node.Child
        private ObjectNodes.FastIsTupleSubClassNode isTupleSubClassNode;

        SubclassCheckNode() {
        }

        @Specialization(guards={"!isNativeClass(cls)", "!isNativeClass(derived)"})
        boolean doManagedManaged(VirtualFrame frame, Object cls, Object derived, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode) {
            return SubclassCheckNode.isSameType(inliningTarget, cls, derived, isSameTypeNode) || this.isSubtypeNode.execute(frame, derived, cls);
        }

        @Specialization
        boolean doObjectObject(VirtualFrame frame, Object cls, Object derived, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrErrorProfile, @Cached TypeNodes.IsTypeNode isClsTypeNode, @Cached TypeNodes.IsTypeNode isDerivedTypeNode) {
            if (SubclassCheckNode.isSameType(inliningTarget, cls, derived, isSameTypeNode)) {
                return true;
            }
            if (isClsTypeNode.execute(inliningTarget, cls) && isDerivedTypeNode.execute(inliningTarget, derived)) {
                return this.isSubtypeNode.execute(frame, derived, cls);
            }
            if (!this.checkClass(frame, inliningTarget, derived, isAttrErrorProfile)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "issubclass()", 1, "class");
            }
            if (!this.checkClass(frame, inliningTarget, cls, isAttrErrorProfile)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_MUST_BE_CLASS_OR_TUPLE);
            }
            return false;
        }

        private boolean checkClass(VirtualFrame frame, Node inliningTarget, Object obj, BuiltinClassProfiles.IsBuiltinObjectProfile isAttrErrorProfile) {
            Object basesObj;
            if (this.getBasesAttrNode == null || this.isTupleSubClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getBasesAttrNode = (GetAttributeNode.GetFixedAttributeNode)this.insert(GetAttributeNode.GetFixedAttributeNode.create(SpecialAttributeNames.T___BASES__));
                this.isTupleSubClassNode = (ObjectNodes.FastIsTupleSubClassNode)this.insert(ObjectNodes.FastIsTupleSubClassNode.create());
            }
            try {
                basesObj = this.getBasesAttrNode.executeObject(frame, obj);
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, isAttrErrorProfile);
                return false;
            }
            return this.isTupleSubClassNode.executeCached(frame, basesObj);
        }

        protected static boolean isSameType(Node inliningTarget, Object a, Object b, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, a, b);
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private LookupAndCallBinaryNode getAttributeNode;

        public abstract boolean executeWith(VirtualFrame var1, Object var2, Object var3);

        public LookupAndCallBinaryNode getGetAttributeNode() {
            if (this.getAttributeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAttributeNode = (LookupAndCallBinaryNode)this.insert(LookupAndCallBinaryNode.create(SpecialMethodSlot.GetAttribute));
            }
            return this.getAttributeNode;
        }

        private PythonObject getInstanceClassAttr(VirtualFrame frame, Object instance) {
            Object classAttr = this.getGetAttributeNode().executeObject(frame, instance, SpecialAttributeNames.T___CLASS__);
            if (classAttr instanceof PythonObject) {
                return (PythonObject)classAttr;
            }
            return null;
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)"}, limit="1")
        boolean isInstance(VirtualFrame frame, Object cls, Object instance, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            if (instance instanceof PythonObject && isSubtypeNode.execute(frame, getClassNode.execute(inliningTarget, instance), cls)) {
                return true;
            }
            Object instanceClass = this.getGetAttributeNode().executeObject(frame, instance, SpecialAttributeNames.T___CLASS__);
            return PGuards.isManagedClass(instanceClass) && isSubtypeNode.execute(frame, instanceClass, cls);
        }

        @Fallback
        boolean isInstance(VirtualFrame frame, Object cls, Object instance, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile typeErrorProfile, @Cached AbstractObjectIsSubclassNode abstractIsSubclassNode, @Cached AbstractObjectGetBasesNode getBasesNode) {
            if (typeErrorProfile.profile(inliningTarget, getBasesNode.execute(frame, cls) == null)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.ISINSTANCE_ARG_2_MUST_BE_TYPE_OR_TUPLE_OF_TYPE, instance);
            }
            PythonObject instanceClass = this.getInstanceClassAttr(frame, instance);
            return instanceClass != null && abstractIsSubclassNode.execute(frame, instanceClass, cls);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonUnaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        Object doType(PythonBuiltinClassType self, @Cached.Shared @Cached GetDictIfExistsNode getDict) {
            return this.doManaged(this.getContext().lookupType(self), getDict);
        }

        @Specialization
        Object doManaged(PythonManagedClass self, @Cached.Shared @Cached GetDictIfExistsNode getDict) {
            PDict dict = getDict.execute(self);
            if (dict == null) {
                dict = this.factory().createDictFixedStorage(self, self.getMethodResolutionOrder());
            }
            return this.factory().createMappingproxy(dict);
        }

        @Specialization
        static Object doNative(PythonNativeClass self, @Cached CStructAccess.ReadObjectNode getTpDictNode) {
            return getTpDictNode.readFromObj(self, CFields.PyTypeObject__tp_dict);
        }
    }

    @Builtin(name="__base__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BaseNode
    extends PythonBuiltinNode {
        BaseNode() {
        }

        @Specialization
        static Object base(Object self, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetBaseClassNode getBaseClassNode) {
            Object baseClass = getBaseClassNode.execute(inliningTarget, self);
            return baseClass != null ? baseClass : PNone.NONE;
        }
    }

    @Builtin(name="__bases__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class BasesNode
    extends PythonBinaryBuiltinNode {
        BasesNode() {
        }

        @Specialization
        Object getBases(Object self, PNone value, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetBaseClassesNode getBaseClassesNode) {
            return this.factory().createTuple(getBaseClassesNode.execute(inliningTarget, self));
        }

        @Specialization
        Object setBases(VirtualFrame frame, PythonClass cls, PTuple value, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getName, @Cached SequenceNodes.GetObjectArrayNode getArray, @Cached TypeNodes.GetBaseClassNode getBase, @Cached TypeNodes.GetBestBaseClassNode getBestBase, @Cached TypeNodes.CheckCompatibleForAssigmentNode checkCompatibleForAssigment, @Cached IsSubtypeNode isSubtypeNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TypeNodes.GetMroNode getMroNode) {
            Object[] a = getArray.execute(inliningTarget, value);
            if (a.length == 0) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_NON_EMPTY_TUPLE_TO_P, cls);
            }
            PythonAbstractClass[] baseClasses = new PythonAbstractClass[a.length];
            for (int i = 0; i < a.length; ++i) {
                if (PGuards.isPythonClass(a[i])) {
                    if (isSubtypeNode.execute(frame, a[i], cls) || BasesNode.hasMRO(inliningTarget, getMroNode, a[i]) && BasesNode.typeIsSubtypeBaseChain(inliningTarget, a[i], cls, getBase, isSameTypeNode)) {
                        throw this.raise(PythonErrorType.TypeError, ErrorMessages.BASES_ITEM_CAUSES_INHERITANCE_CYCLE);
                    }
                    if (a[i] instanceof PythonBuiltinClassType) {
                        baseClasses[i] = this.getContext().lookupType((PythonBuiltinClassType)((Object)a[i]));
                        continue;
                    }
                    baseClasses[i] = (PythonAbstractClass)a[i];
                    continue;
                }
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_TUPLE_OF_CLASSES_NOT_P, getName.execute(inliningTarget, cls), "__bases__", a[i]);
            }
            Object newBestBase = getBestBase.execute(inliningTarget, baseClasses);
            if (newBestBase == null) {
                return null;
            }
            Object oldBase = getBase.execute(inliningTarget, cls);
            checkCompatibleForAssigment.execute(frame, oldBase, newBestBase);
            cls.setBases(newBestBase, baseClasses);
            SpecialMethodSlot.reinitializeSpecialMethodSlots(cls, this.getLanguage());
            return PNone.NONE;
        }

        private static boolean hasMRO(Node inliningTarget, TypeNodes.GetMroNode getMroNode, Object i) {
            PythonAbstractClass[] mro = getMroNode.execute(inliningTarget, i);
            return mro != null && mro.length > 0;
        }

        private static boolean typeIsSubtypeBaseChain(Node inliningTarget, Object a, Object b, TypeNodes.GetBaseClassNode getBaseNode, TypeNodes.IsSameTypeNode isSameTypeNode) {
            Object base = a;
            do {
                if (!isSameTypeNode.execute(inliningTarget, base, b)) continue;
                return true;
            } while ((base = getBaseNode.execute(inliningTarget, base)) != null);
            return isSameTypeNode.execute(inliningTarget, b, (Object)PythonBuiltinClassType.PythonObject);
        }

        @Specialization(guards={"!isPTuple(value)"})
        Object setObject(PythonClass cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_S_TO_S_S_NOT_P, "tuple", TypeNodes.GetNameNode.executeUncached(cls), "__bases__", value);
        }

        @Specialization
        Object setBuiltin(PythonBuiltinClass cls, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, "__bases__", cls);
        }
    }

    @Builtin(name="__prepare__", takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class PrepareNode
    extends PythonBuiltinNode {
        @Specialization
        Object doIt(Object args, Object kwargs) {
            return this.factory().createDict(new DynamicObjectStorage(PythonLanguage.get(this)));
        }
    }

    @Builtin(name="__setattr__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetattrNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"!isImmutable(object)"})
        static Object set(VirtualFrame frame, Object object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached ObjectNodes.GenericSetAttrNode genericSetAttrNode, @Cached(value="createForceType()") WriteAttributeToObjectNode write) {
            genericSetAttrNode.execute(inliningTarget, frame, object, key, value, write);
            return PNone.NONE;
        }

        @Specialization(guards={"isImmutable(object)"})
        @CompilerDirectives.TruffleBoundary
        Object setBuiltin(Object object, Object key, Object value) {
            if (PythonContext.get(this).isInitialized()) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(key), object);
            }
            SetattrNode.set(null, object, key, value, null, ObjectNodes.GenericSetAttrNode.getUncached(), WriteAttributeToObjectNode.getUncached(true));
            return PNone.NONE;
        }

        protected static boolean isImmutable(Object type) {
            return type instanceof PythonBuiltinClass || type instanceof PythonBuiltinClassType;
        }
    }

    @Builtin(name="__getattribute__", minNumOfPositionalArgs=2)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private LookupInheritedSlotNode valueGetLookup;
        @Node.Child
        private LookupCallableSlotInMRONode lookupGetNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupSetNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupDeleteNode;
        @Node.Child
        private CallTernaryMethodNode invokeGet;
        @Node.Child
        private CallTernaryMethodNode invokeValueGet;
        @Node.Child
        private LookupAttributeInMRONode.Dynamic lookupAsClass;

        @Specialization
        protected Object doIt(VirtualFrame frame, Object object, Object keyObj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached GetClassNode getDescClassNode, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached CastToTruffleStringNode castToString, @Cached InlinedBranchProfile hasDescProfile, @Cached InlinedBranchProfile isDescProfile, @Cached InlinedBranchProfile hasValueProfile, @Cached InlinedBranchProfile errorProfile) {
            Object value;
            Object dataDescClass;
            TruffleString key;
            try {
                key = castToString.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(type, key);
            Object get = null;
            if (descr != PNone.NO_VALUE && PGuards.isCallableOrDescriptor(get = this.lookupGet(dataDescClass = getDescClassNode.execute(inliningTarget, descr)))) {
                Object delete = PNone.NO_VALUE;
                Object set = this.lookupSet(dataDescClass);
                if (set == PNone.NO_VALUE) {
                    delete = this.lookupDelete(dataDescClass);
                }
                if (set != PNone.NO_VALUE || delete != PNone.NO_VALUE) {
                    isDescProfile.enter(inliningTarget);
                    if (this.invokeGet == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.invokeGet = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
                    }
                    return this.invokeGet.execute((Frame)frame, get, descr, object, type);
                }
            }
            if ((value = this.readAttribute(object, key)) != PNone.NO_VALUE) {
                hasValueProfile.enter(inliningTarget);
                Object valueGet = this.lookupValueGet(value);
                if (valueGet == PNone.NO_VALUE) {
                    return value;
                }
                if (PGuards.isCallableOrDescriptor(valueGet)) {
                    if (this.invokeValueGet == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.invokeValueGet = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
                    }
                    return this.invokeValueGet.execute((Frame)frame, valueGet, value, PNone.NONE, object);
                }
            }
            if (descr != PNone.NO_VALUE) {
                hasDescProfile.enter(inliningTarget);
                if (get == PNone.NO_VALUE) {
                    return descr;
                }
                if (PGuards.isCallableOrDescriptor(get)) {
                    if (this.invokeGet == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.invokeGet = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
                    }
                    return this.invokeGet.execute((Frame)frame, get, descr, object, type);
                }
            }
            errorProfile.enter(inliningTarget);
            throw this.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_N_HAS_NO_ATTR_S, object, key);
        }

        private Object readAttribute(Object object, Object key) {
            if (this.lookupAsClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupAsClass = (LookupAttributeInMRONode.Dynamic)this.insert(LookupAttributeInMRONode.Dynamic.create());
            }
            return this.lookupAsClass.execute(object, key);
        }

        private Object lookupDelete(Object dataDescClass) {
            if (this.lookupDeleteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupDeleteNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Delete));
            }
            return this.lookupDeleteNode.execute(dataDescClass);
        }

        private Object lookupSet(Object dataDescClass) {
            if (this.lookupSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupSetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Set));
            }
            return this.lookupSetNode.execute(dataDescClass);
        }

        private Object lookupGet(Object dataDescClass) {
            if (this.lookupGetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupGetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Get));
            }
            return this.lookupGetNode.execute(dataDescClass);
        }

        private Object lookupValueGet(Object value) {
            if (this.valueGetLookup == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.valueGetLookup = (LookupInheritedSlotNode)this.insert(LookupInheritedSlotNode.create(SpecialMethodSlot.Get));
            }
            return this.valueGetLookup.execute(value);
        }
    }

    @ReportPolymorphism
    protected static abstract class CallNodeHelper
    extends PNodeWithRaise {
        @Node.Child
        private CallVarargsMethodNode dispatchNew = CallVarargsMethodNode.create();
        @Node.Child
        private LookupCallableSlotInMRONode lookupNew = LookupCallableSlotInMRONode.create(SpecialMethodSlot.New);
        @Node.Child
        private CallVarargsMethodNode dispatchInit;
        @Node.Child
        private LookupSpecialMethodSlotNode lookupInit;
        @Node.Child
        private IsSubtypeNode isSubTypeNode;
        @Node.Child
        private TypeNodes.GetNameNode getNameNode;

        protected CallNodeHelper() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object[] var3, PKeyword[] var4);

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()", guards={"isSingleContext()", "self == cachedSelf"})
        protected Object doIt0BuiltinSingle(VirtualFrame frame, PythonBuiltinClass self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="self") PythonBuiltinClass cachedSelf, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            PythonBuiltinClassType type = cachedSelf.getType();
            return this.op(frame, inliningTarget, (Object)type, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()", guards={"isSingleContext()", "self == cachedSelf", "isPythonClass(cachedSelf)", "!isPythonBuiltinClass(cachedSelf)"})
        protected Object doIt0User(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="self", weak=true) Object cachedSelf, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, cachedSelf, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()", guards={"self.getType() == cachedType"})
        protected Object doIt0BuiltinMulti(VirtualFrame frame, PythonBuiltinClass self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="self.getType()") PythonBuiltinClassType cachedType, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, (Object)cachedType, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()", guards={"self == cachedType"})
        protected Object doIt0BuiltinType(VirtualFrame frame, PythonBuiltinClassType self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="self") PythonBuiltinClassType cachedType, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, (Object)cachedType, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(replaces={"doIt0BuiltinSingle", "doIt0BuiltinMulti"})
        protected Object doItIndirect0Builtin(VirtualFrame frame, PythonBuiltinClass self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            PythonBuiltinClassType type = self.getType();
            return this.op(frame, inliningTarget, (Object)type, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(replaces={"doIt0BuiltinType"})
        protected Object doItIndirect0BuiltinType(VirtualFrame frame, PythonBuiltinClassType self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, (Object)self, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(replaces={"doIt0User"}, guards={"!isPythonBuiltinClass(self)"})
        protected Object doItIndirect0User(VirtualFrame frame, PythonAbstractClass self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, self, arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()", guards={"isSingleContext()", "self == cachedSelf"})
        protected Object doIt1(VirtualFrame frame, PythonNativeObject self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="self") PythonNativeObject cachedSelf, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, PythonNativeClass.cast(cachedSelf), arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        @Specialization(replaces={"doIt1"})
        protected Object doItIndirect1(VirtualFrame frame, PythonNativeObject self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getInstanceClassNode, @Cached.Shared @Cached InlinedConditionProfile hasNew, @Cached.Shared @Cached InlinedConditionProfile hasInit, @Cached.Shared @Cached InlinedConditionProfile gotInitResult, @Cached.Shared @Cached BindNew bindNew) {
            return this.op(frame, inliningTarget, PythonNativeClass.cast(self), arguments, keywords, getInstanceClassNode, hasNew, hasInit, gotInitResult, bindNew);
        }

        private Object op(VirtualFrame frame, Node inliningTarget, Object self, Object[] arguments, PKeyword[] keywords, GetClassNode getInstanceClassNode, InlinedConditionProfile hasNew, InlinedConditionProfile hasInit, InlinedConditionProfile gotInitResult, BindNew bindNew) {
            Object newMethod = this.lookupNew.execute(self);
            if (hasNew.profile(inliningTarget, newMethod != PNone.NO_VALUE)) {
                Object[] newArgs = PythonUtils.prependArgument(self, arguments);
                Object newInstance = this.dispatchNew.execute((Frame)frame, bindNew.execute(frame, inliningTarget, newMethod, self), newArgs, keywords);
                this.callInit(inliningTarget, newInstance, self, frame, arguments, keywords, getInstanceClassNode, hasInit, gotInitResult);
                return newInstance;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, this.getTypeName(self));
        }

        private void callInit(Node inliningTarget, Object newInstance, Object self, VirtualFrame frame, Object[] arguments, PKeyword[] keywords, GetClassNode getInstanceClassNode, InlinedConditionProfile hasInit, InlinedConditionProfile gotInitResult) {
            Object initMethod;
            Object newInstanceKlass = getInstanceClassNode.execute(inliningTarget, newInstance);
            if (this.isSubType(newInstanceKlass, self) && hasInit.profile(inliningTarget, (initMethod = this.getInitNode().execute((Frame)frame, newInstanceKlass, newInstance)) != PNone.NO_VALUE)) {
                Object[] initArgs = PythonUtils.prependArgument(newInstance, arguments);
                Object initResult = this.getDispatchNode().execute((Frame)frame, initMethod, initArgs, keywords);
                if (gotInitResult.profile(inliningTarget, initResult != PNone.NONE && initResult != PNone.NO_VALUE)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN_NONE, "__init__()");
                }
            }
        }

        private LookupSpecialMethodSlotNode getInitNode() {
            if (this.lookupInit == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupInit = (LookupSpecialMethodSlotNode)this.insert(LookupSpecialMethodSlotNode.create(SpecialMethodSlot.Init));
            }
            return this.lookupInit;
        }

        private CallVarargsMethodNode getDispatchNode() {
            if (this.dispatchInit == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.dispatchInit = (CallVarargsMethodNode)this.insert(CallVarargsMethodNode.create());
            }
            return this.dispatchInit;
        }

        private boolean isSubType(Object left, Object right) {
            if (this.isSubTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSubTypeNode = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            return this.isSubTypeNode.execute(left, right);
        }

        private TruffleString getTypeName(Object clazz) {
            if (this.getNameNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNameNode = (TypeNodes.GetNameNode)this.insert(TypeNodes.GetNameNode.create());
            }
            return this.getNameNode.executeCached(clazz);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class BindNew
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

        @Specialization
        static Object doBuiltinMethod(PBuiltinMethod descriptor, Object type) {
            return descriptor;
        }

        @Specialization
        static Object doBuiltinDescriptor(BuiltinMethodDescriptor descriptor, Object type) {
            return descriptor;
        }

        @Specialization
        static Object doFunction(PFunction descriptor, Object type) {
            return descriptor;
        }

        @Fallback
        static Object doBind(VirtualFrame frame, Node inliningTarget, Object descriptor, Object type, @Cached GetClassNode getClassNode, @Cached(parameters={"Get"}, inline=false) LookupCallableSlotInMRONode lookupGet, @Cached(inline=false) CallTernaryMethodNode callGet) {
            Object getMethod = lookupGet.execute(getClassNode.execute(inliningTarget, descriptor));
            if (getMethod != PNone.NO_VALUE) {
                return callGet.execute((Frame)frame, getMethod, descriptor, PNone.NONE, type);
            }
            return descriptor;
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        CallNodeHelper callNodeHelper;

        @NeverDefault
        public static CallNode create() {
            return TypeBuiltinsFactory.CallNodeFactory.create();
        }

        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            return this.execute(frame, self, arguments, keywords);
        }

        public CallNodeHelper getCallNodeHelper() {
            if (this.callNodeHelper == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNodeHelper = (CallNodeHelper)this.insert(TypeBuiltinsFactory.CallNodeHelperNodeGen.create());
            }
            return this.callNodeHelper;
        }

        @Specialization(guards={"isNoValue(self)"})
        Object selfInArgs(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached CallNodeHelper callNodeHelper, @Cached SplitArgsNode splitArgsNode, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached GetClassNode getClassNode) {
            if (isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PythonClass, arguments[0])) {
                if (arguments.length == 2 && keywords.length == 0) {
                    return getClassNode.execute(inliningTarget, arguments[1]);
                }
                if (arguments.length != 4) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_D_OR_D_ARGS, "type()", 1, 3);
                }
            }
            return callNodeHelper.execute(frame, arguments[0], splitArgsNode.execute(inliningTarget, arguments), keywords);
        }

        @Fallback
        Object selfSeparate(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached GetClassNode getClassNode) {
            if (isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PythonClass, self)) {
                if (arguments.length == 1 && keywords.length == 0) {
                    return getClassNode.execute(inliningTarget, arguments[0]);
                }
                if (arguments.length != 3) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_D_OR_D_ARGS, "type()", 1, 3);
                }
            }
            return this.getCallNodeHelper().execute(frame, self, arguments, keywords);
        }
    }

    @Builtin(name="__init__", takesVarArgs=true, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private SplitArgsNode splitArgsNode;

        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (this.splitArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.splitArgsNode = (SplitArgsNode)this.insert(SplitArgsNode.create());
            }
            return this.execute(frame, arguments[0], this.splitArgsNode.executeCached(arguments), keywords);
        }

        @Specialization
        Object init(Object self, Object[] arguments, PKeyword[] kwds) {
            if (arguments.length != 1 && arguments.length != 3) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_D_OR_D_ARGS, "type.__init__()", 1, 3);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="mro", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class MroNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isTypeNode.execute(inliningTarget, klass)"}, limit="1")
        Object doit(Object klass, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.GetMroNode getMroNode) {
            PythonAbstractClass[] mro = getMroNode.execute(inliningTarget, klass);
            return this.factory().createList(Arrays.copyOf(mro, mro.length, Object[].class));
        }

        @Fallback
        Object doit(Object object) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T_MRO, "type", object);
        }
    }

    @Builtin(name="__mro__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MroAttrNode
    extends PythonBuiltinNode {
        MroAttrNode() {
        }

        @Specialization
        Object doit(Object klass, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetMroNode getMroNode, @Cached InlinedConditionProfile notInitialized) {
            if (notInitialized.profile(inliningTarget, klass instanceof PythonManagedClass && !((PythonManagedClass)klass).isMROInitialized())) {
                return PNone.NONE;
            }
            Object[] mro = getMroNode.execute(inliningTarget, klass);
            return this.factory().createTuple(mro);
        }
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialAttributeNames.class})
    public static abstract class DocNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        Object getDoc(PythonBuiltinClassType self, PNone value) {
            return DocNode.getDoc(this.getContext().lookupType(self), value);
        }

        @Specialization(guards={"isNoValue(value)"})
        @CompilerDirectives.TruffleBoundary
        static Object getDoc(PythonBuiltinClass self, PNone value) {
            if (BuiltinClassProfiles.InlineIsBuiltinClassProfile.profileClassSlowPath(self, PythonBuiltinClassType.PythonClass)) {
                return self.getAttribute(TYPE_DOC);
            }
            return self.getAttribute(SpecialAttributeNames.T___DOC__);
        }

        @Specialization(guards={"isNoValue(value)", "!isPythonBuiltinClass(self)"})
        static Object getDoc(VirtualFrame frame, PythonClass self, PNone value) {
            Object res = self.getAttribute(SpecialAttributeNames.T___DOC__);
            Object resClass = GetClassNode.executeUncached(res);
            Object get = LookupAttributeInMRONode.Dynamic.getUncached().execute(resClass, SpecialMethodNames.T___GET__);
            if (PGuards.isCallable(get)) {
                return CallTernaryMethodNode.getUncached().execute((Frame)frame, get, res, PNone.NONE, self);
            }
            return res;
        }

        @Specialization
        static Object getDoc(PythonNativeClass self, PNone value) {
            return ReadAttributeFromObjectNode.getUncachedForceType().execute(self, SpecialAttributeNames.T___DOC__);
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "!isPythonBuiltinClass(self)"})
        static Object setDoc(PythonClass self, Object value) {
            self.setAttribute(SpecialAttributeNames.T___DOC__, value);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)", "isKindOfBuiltinClass(self)"})
        Object doc(Object self, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___DOC__, self);
        }

        @Specialization
        Object doc(Object self, DescriptorDeleteMarker marker) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_DELETE_ATTRIBUTE_S_OF_IMMUTABLE_TYPE_N, SpecialAttributeNames.T___DOC__, self);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialAttributeNames.class})
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___MODULE__)") GetAttributeNode.GetFixedAttributeNode readModuleNode, @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.EqualNode equalNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object moduleNameObj = readModuleNode.executeObject(frame, self);
            Object qualNameObj = readQualNameNode.executeObject(frame, self);
            TruffleString moduleName = null;
            if (moduleNameObj != PNone.NO_VALUE) {
                try {
                    moduleName = castToStringNode.execute(inliningTarget, moduleNameObj);
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            if (moduleName == null || equalNode.execute((AbstractTruffleString)moduleName, (AbstractTruffleString)BuiltinNames.T_BUILTINS, PythonUtils.TS_ENCODING)) {
                return simpleTruffleStringFormatNode.format("<class '%s'>", castToStringNode.execute(inliningTarget, qualNameObj));
            }
            return simpleTruffleStringFormatNode.format("<class '%s.%s'>", moduleName, castToStringNode.execute(inliningTarget, qualNameObj));
        }
    }
}

