/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=InteropLibrary.class)
public final class PTuple
extends PSequence {
    private SequenceStorage store;
    private long hash = -1L;

    public PTuple(Object cls, Shape instanceShape, Object[] elements) {
        super(cls, instanceShape);
        this.store = new ObjectSequenceStorage(elements);
    }

    public PTuple(Object cls, Shape instanceShape, SequenceStorage store) {
        super(cls, instanceShape);
        this.store = store;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.store instanceof ObjectSequenceStorage) {
            StringBuilder buf = new StringBuilder("(");
            Object[] array = this.store.getInternalArray();
            for (int i = 0; i < array.length - 1; ++i) {
                buf.append(array[i]);
                buf.append(", ");
            }
            if (array.length > 0) {
                buf.append(array[array.length - 1]);
            }
            if (array.length == 1) {
                buf.append(",");
            }
            buf.append(")");
            return buf.toString();
        }
        return String.format("tuple(%s)", this.store);
    }

    @Override
    public SequenceStorage getSequenceStorage() {
        return this.store;
    }

    @Override
    public void setSequenceStorage(SequenceStorage store) {
        this.store = store;
    }

    @ExportMessage.Ignore
    public boolean equals(Object other) {
        CompilerAsserts.neverPartOfCompilation();
        if (!(other instanceof PTuple)) {
            return false;
        }
        PTuple otherTuple = (PTuple)other;
        return this.store.equals(otherTuple.store);
    }

    public int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return super.hashCode();
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }

    public static void setItem(int idx, Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.PTuple, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT);
    }

    @ExportMessage
    public static boolean isArrayElementModifiable(PTuple self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementInsertable(PTuple self, long index) {
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementRemovable(PTuple self, long index) {
        return false;
    }
}

