/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public abstract class AbstractPythonLock
extends PythonBuiltinObject {
    public static final double TIMEOUT_MAX = Math.pow(2.0, 31.0);
    public static final boolean DEFAULT_BLOCKING = true;
    public static final double UNSET_TIMEOUT = -1.0;

    AbstractPythonLock(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    private static long getTimeoutInMillis(double timeout) {
        long seconds = (long)timeout;
        long milli = (long)((timeout - (double)seconds) * 1000.0);
        return seconds * 1000L + milli;
    }

    protected abstract boolean acquireNonBlocking();

    protected abstract boolean acquireBlocking(Node var1);

    protected abstract boolean acquireTimeout(Node var1, long var2);

    protected boolean acquireTimeout(Node node, double timeout) {
        return this.acquireTimeout(node, AbstractPythonLock.getTimeoutInMillis(timeout));
    }

    public abstract void release();

    public abstract boolean locked();
}

