/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.method.StaticmethodBuiltinsFactory;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStaticmethod})
public final class StaticmethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StaticmethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString PREFIX = PythonUtils.tsLiteral("<staticmethod(");
        private static final int PREFIX_LEN = PREFIX.byteLength(PythonUtils.TS_ENCODING);
        private static final TruffleString SUFFIX = PythonUtils.tsLiteral(")>");
        private static final int SUFFIX_LEN = SUFFIX.byteLength(PythonUtils.TS_ENCODING);

        ReprNode() {
        }

        @Specialization
        Object repr(VirtualFrame frame, PDecoratedMethod self, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached TruffleStringBuilder.AppendStringNode append, @Cached TruffleStringBuilder.ToStringNode toString) {
            TruffleString callableRepr = repr.execute((Frame)frame, inliningTarget, self.getCallable());
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(PREFIX_LEN + callableRepr.byteLength(PythonUtils.TS_ENCODING) + SUFFIX_LEN));
            append.execute(sb, (AbstractTruffleString)PREFIX);
            append.execute(sb, (AbstractTruffleString)callableRepr);
            append.execute(sb, (AbstractTruffleString)SUFFIX);
            return toString.execute(sb);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallMethodNode
    extends PythonVarargsBuiltinNode {
        CallMethodNode() {
        }

        @Specialization
        static Object call(VirtualFrame frame, PDecoratedMethod self, Object[] args, PKeyword[] kwargs, @Cached CallNode callNode) {
            return callNode.execute((Frame)frame, self.getCallable(), args, kwargs);
        }
    }

    @Builtin(name="__get__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ReportPolymorphism
    static abstract class GetNode
    extends PythonTernaryBuiltinNode {
        GetNode() {
        }

        @Specialization(guards={"isSingleContext()", "cachedSelf == self"}, limit="3")
        protected static Object getCached(PDecoratedMethod self, Object obj, Object type, @Cached(value="self", weak=true) PDecoratedMethod cachedSelf, @Cached(value="self.getCallable()", weak=true) Object cachedCallable) {
            return cachedCallable;
        }

        @Specialization(replaces={"getCached"})
        protected Object get(PDecoratedMethod self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile uninitialized) {
            Object callable = self.getCallable();
            if (callable == null) {
                uninitialized.enter(inliningTarget);
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNINITIALIZED_S_OBJECT);
            }
            return callable;
        }
    }
}

