/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.TruffleObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@ImportStatic(value={PGuards.class, CApiGuards.class})
public abstract class GetNativeWrapperNode
extends PNodeWithContext {
    public abstract PythonNativeWrapper execute(Object var1);

    @Specialization
    static PythonNativeWrapper doString(TruffleString str, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached ConditionProfile noWrapperProfile) {
        return PythonObjectNativeWrapper.wrap(factory.createString(str), noWrapperProfile);
    }

    @Specialization
    PythonNativeWrapper doBoolean(boolean b, @Cached.Exclusive @Cached ConditionProfile profile) {
        PythonContext core = PythonContext.get(this);
        PInt boxed = b ? core.getTrue() : core.getFalse();
        PythonNativeWrapper nativeWrapper = boxed.getNativeWrapper();
        if (profile.profile(nativeWrapper == null)) {
            CompilerDirectives.transferToInterpreter();
            nativeWrapper = PrimitiveNativeWrapper.createBool(b);
            boxed.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    @Specialization(guards={"isSmallInteger(i)"})
    PrimitiveNativeWrapper doIntegerSmall(int i) {
        PythonContext context = this.getContext();
        if (context.getCApiContext() != null) {
            return context.getCApiContext().getCachedPrimitiveNativeWrapper(i);
        }
        return PrimitiveNativeWrapper.createInt(i);
    }

    @Specialization(guards={"!isSmallInteger(i)"})
    static PrimitiveNativeWrapper doInteger(int i) {
        return PrimitiveNativeWrapper.createInt(i);
    }

    public static PrimitiveNativeWrapper doLongSmall(long l, PythonContext context) {
        if (context.getCApiContext() != null) {
            return context.getCApiContext().getCachedPrimitiveNativeWrapper(l);
        }
        return PrimitiveNativeWrapper.createLong(l);
    }

    @Specialization(guards={"isSmallLong(l)"})
    PrimitiveNativeWrapper doLongSmall(long l) {
        return GetNativeWrapperNode.doLongSmall(l, this.getContext());
    }

    @Specialization(guards={"!isSmallLong(l)"})
    static PrimitiveNativeWrapper doLong(long l) {
        return PrimitiveNativeWrapper.createLong(l);
    }

    @Specialization(guards={"!isNaN(d)"})
    static PythonNativeWrapper doDouble(double d) {
        return PrimitiveNativeWrapper.createDouble(d);
    }

    @Specialization(guards={"isNaN(d)"})
    PythonNativeWrapper doDoubleNaN(double d) {
        PFloat boxed = this.getContext().getNaN();
        PythonNativeWrapper nativeWrapper = boxed.getNativeWrapper();
        if (nativeWrapper == null) {
            CompilerDirectives.transferToInterpreter();
            nativeWrapper = PrimitiveNativeWrapper.createDouble(Double.NaN);
            boxed.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    static PythonNativeWrapper doSingleton(PythonAbstractObject object, PythonContext context) {
        PythonNativeWrapper nativeWrapper = context.getSingletonNativeWrapper(object);
        if (nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            nativeWrapper = new PythonObjectNativeWrapper(object);
            CApiTransitions.incRef(nativeWrapper, 65536L);
            context.setSingletonNativeWrapper(object, nativeWrapper);
        }
        return nativeWrapper;
    }

    @Specialization(guards={"isSpecialSingleton(object)"})
    PythonNativeWrapper doSingleton(PythonAbstractObject object) {
        return GetNativeWrapperNode.doSingleton(object, this.getContext());
    }

    @Specialization
    static PythonNativeWrapper doPythonClassUncached(PythonManagedClass object, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetNameNode getNameNode) {
        return PythonClassNativeWrapper.wrap(object, getNameNode.execute(inliningTarget, object));
    }

    @Specialization
    static PythonNativeWrapper doPythonTypeUncached(PythonBuiltinClassType object, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetNameNode getNameNode) {
        return PythonClassNativeWrapper.wrap(PythonContext.get(getNameNode).lookupType(object), getNameNode.execute(inliningTarget, (Object)object));
    }

    @Specialization(guards={"!isClass(inliningTarget, object, isTypeNode)", "!isNativeObject(object)", "!isSpecialSingleton(object)"}, limit="1")
    static PythonNativeWrapper runAbstractObject(PythonAbstractObject object, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ConditionProfile noWrapperProfile, @Cached TypeNodes.IsTypeNode isTypeNode) {
        assert (object != PNone.NO_VALUE);
        return PythonObjectNativeWrapper.wrap(object, noWrapperProfile);
    }

    @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, object)", "!isNativeWrapper(object)", "!isNativeNull(object)"}, limit="1")
    static PythonNativeWrapper doForeignObject(Object object, @Bind(value="this") Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode) {
        assert (!CApiTransitions.isBackendPointerObject(object));
        assert (!(object instanceof String));
        return TruffleObjectNativeWrapper.wrap(object);
    }

    protected static boolean isNaN(double d) {
        return Double.isNaN(d);
    }
}

