/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiMemberAccessNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtAsPythonObjectNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

public class CApiMemberAccessNodes {
    public static final int T_SHORT = 0;
    public static final int T_INT = 1;
    public static final int T_LONG = 2;
    public static final int T_FLOAT = 3;
    public static final int T_DOUBLE = 4;
    public static final int T_STRING = 5;
    public static final int T_OBJECT = 6;
    public static final int T_CHAR = 7;
    public static final int T_BYTE = 8;
    public static final int T_UBYTE = 9;
    public static final int T_USHORT = 10;
    public static final int T_UINT = 11;
    public static final int T_ULONG = 12;
    public static final int T_STRING_INPLACE = 13;
    public static final int T_BOOL = 14;
    public static final int T_OBJECT_EX = 16;
    public static final int T_LONGLONG = 17;
    public static final int T_ULONGLONG = 18;
    public static final int T_PYSSIZET = 19;
    public static final int T_NONE = 20;

    private static boolean isReadOnlyType(int type) {
        return type == 5 || type == 13;
    }

    private static CStructAccess.ReadBaseNode getReadNode(int type) {
        switch (type) {
            case 0: 
            case 10: {
                return CStructAccessFactory.ReadI16NodeGen.create();
            }
            case 1: 
            case 11: {
                return CStructAccessFactory.ReadI32NodeGen.create();
            }
            case 2: 
            case 12: {
                return CStructAccessFactory.ReadI64NodeGen.create();
            }
            case 3: {
                return CStructAccessFactory.ReadFloatNodeGen.create();
            }
            case 4: {
                return CStructAccessFactory.ReadDoubleNodeGen.create();
            }
            case 5: {
                return CStructAccessFactory.ReadPointerNodeGen.create();
            }
            case 6: {
                return CStructAccessFactory.ReadObjectNodeGen.create();
            }
            case 16: {
                return CStructAccessFactory.ReadObjectNodeGen.create();
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                return CStructAccessFactory.ReadByteNodeGen.create();
            }
            case 13: {
                return CStructAccessFactory.GetElementPtrNodeGen.create();
            }
            case 17: 
            case 18: {
                assert (CStructs.long__long.size() == 8);
                return CStructAccessFactory.ReadI64NodeGen.create();
            }
            case 19: {
                assert (CStructs.Py_ssize_t.size() == 8);
                return CStructAccessFactory.ReadI64NodeGen.create();
            }
            case 20: {
                return null;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
    }

    private static CExtAsPythonObjectNode getReadConverterNode(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 19: 
            case 20: {
                return null;
            }
            case 5: 
            case 13: {
                return CExtCommonNodesFactory.StringAsPythonStringNodeGen.create();
            }
            case 14: {
                return CExtCommonNodesFactory.NativePrimitiveAsPythonBooleanNodeGen.create();
            }
            case 7: {
                return CExtCommonNodesFactory.NativePrimitiveAsPythonCharNodeGen.create();
            }
            case 9: {
                return CExtCommonNodesFactory.NativeUnsignedByteNodeGen.create();
            }
            case 10: {
                return CExtCommonNodesFactory.NativeUnsignedShortNodeGen.create();
            }
            case 11: 
            case 12: 
            case 18: {
                return CExtCommonNodesFactory.NativeUnsignedPrimitiveAsPythonObjectNodeGen.create();
            }
            case 6: 
            case 16: {
                return null;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
    }

    private static WriteTypeNode getWriteNode(int type) {
        switch (type) {
            case 0: 
            case 10: {
                return CApiMemberAccessNodesFactory.WriteShortNodeGen.create();
            }
            case 1: {
                return CApiMemberAccessNodesFactory.WriteIntNodeGen.create();
            }
            case 11: {
                return CApiMemberAccessNodesFactory.WriteUIntNodeGen.create();
            }
            case 2: {
                return CApiMemberAccessNodesFactory.WriteLongNodeGen.create();
            }
            case 3: {
                return CApiMemberAccessNodesFactory.WriteFloatNodeGen.create();
            }
            case 4: {
                return CApiMemberAccessNodesFactory.WriteDoubleNodeGen.create();
            }
            case 5: 
            case 13: 
            case 20: {
                return null;
            }
            case 6: {
                return CApiMemberAccessNodesFactory.WriteObjectNodeGen.create();
            }
            case 16: {
                return CApiMemberAccessNodesFactory.WriteObjectExNodeGen.create();
            }
            case 7: {
                return CApiMemberAccessNodesFactory.WriteCharNodeGen.create();
            }
            case 8: 
            case 9: 
            case 14: {
                return CApiMemberAccessNodesFactory.WriteByteNodeGen.create();
            }
            case 12: 
            case 18: {
                return CApiMemberAccessNodesFactory.WriteULongNodeGen.create();
            }
            case 17: 
            case 19: {
                assert (CStructs.long__long.size() == 8);
                assert (CStructs.Py_ssize_t.size() == 8);
                return CApiMemberAccessNodesFactory.WriteLongNodeGen.create();
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
    }

    static abstract class WriteShortNode
    extends WriteTypeNode {
        WriteShortNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteI16Node write) {
            write.write(pointer, (short)asLong.toInt64(newValue, true));
        }
    }

    static abstract class WriteIntNode
    extends WriteTypeNode {
        WriteIntNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteIntNode write) {
            write.write(pointer, (int)asLong.toInt64(newValue, true));
        }
    }

    static abstract class WriteUIntNode
    extends WriteTypeNode {
        WriteUIntNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteIntNode write, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile) {
            try {
                write.write(pointer, (int)asLong.toUInt64(newValue, true));
            }
            catch (PException e) {
                e.expectOverflowError(inliningTarget, exceptionProfile);
                write.write(pointer, (int)asLong.toInt64(newValue, true));
            }
        }
    }

    static abstract class WriteLongNode
    extends WriteTypeNode {
        WriteLongNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteLongNode write, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile) {
            try {
                write.write(pointer, asLong.toInt64(newValue, true));
            }
            catch (PException e) {
                e.expectOverflowError(inliningTarget, exceptionProfile);
                write.write(pointer, -1L);
                throw e;
            }
        }
    }

    static abstract class WriteFloatNode
    extends WriteTypeNode {
        WriteFloatNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CExtCommonNodes.AsNativeDoubleNode asDouble, @Cached CStructAccess.WriteFloatNode write) {
            write.write(pointer, (float)asDouble.executeDouble(newValue));
        }
    }

    static abstract class WriteDoubleNode
    extends WriteTypeNode {
        WriteDoubleNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.AsNativeDoubleNode asDouble, @Cached CStructAccess.WriteDoubleNode write, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile) {
            try {
                write.write(pointer, asDouble.executeDouble(newValue));
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, exceptionProfile);
                write.write(pointer, -1.0);
                throw e;
            }
        }
    }

    static abstract class WriteObjectNode
    extends WriteTypeNode {
        WriteObjectNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CStructAccess.WriteObjectNewRefNode write) {
            write.write(pointer, newValue);
        }
    }

    static abstract class WriteObjectExNode
    extends WriteTypeNode {
        WriteObjectExNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CStructAccess.ReadObjectNode read, @Cached CStructAccess.WriteObjectNewRefNode write, @Cached PRaiseNode raise) {
            Object current = read.readGeneric(pointer, 0L);
            if (newValue == DescriptorDeleteMarker.INSTANCE && current == PNone.NO_VALUE) {
                throw raise.raise(PythonBuiltinClassType.AttributeError);
            }
            write.write(pointer, newValue);
        }
    }

    static abstract class WriteCharNode
    extends WriteTypeNode {
        WriteCharNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CExtCommonNodes.AsNativeCharNode asChar, @Cached CStructAccess.WriteByteNode write) {
            write.write(pointer, asChar.executeByte(newValue));
        }
    }

    static abstract class WriteByteNode
    extends WriteTypeNode {
        WriteByteNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteByteNode write) {
            write.write(pointer, (byte)asLong.toInt64(newValue, true));
        }
    }

    static abstract class WriteULongNode
    extends WriteTypeNode {
        WriteULongNode() {
        }

        @Specialization
        static void write(Object pointer, Object newValue, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.AsNativePrimitiveNode asLong, @Cached CStructAccess.WriteLongNode write, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile) {
            try {
                write.write(pointer, asLong.toUInt64(newValue, true));
            }
            catch (PException e) {
                e.expectOverflowError(inliningTarget, exceptionProfile);
                write.write(pointer, -1L);
                throw e;
            }
        }
    }

    @Builtin(name="write_member", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    public static abstract class WriteMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin BUILTIN = WriteMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;
        @Node.Child
        private GetClassNode getClassNode;
        @Node.Child
        private TypeNodes.IsSameTypeNode isSameTypeNode;
        @Node.Child
        private WriteTypeNode write;
        @Node.Child
        private CStructAccess.GetElementPtrNode getElement;
        private final int type;
        private final int offset;

        protected WriteMemberNode(int type, int offset) {
            this.type = type;
            this.offset = offset;
            this.write = CApiMemberAccessNodes.getWriteNode(type);
            this.toSulongNode = CApiTransitionsFactory.PythonToNativeNodeGen.create();
            this.getElement = CStructAccessFactory.GetElementPtrNodeGen.create();
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, Object value) {
            Object selfPtr = this.toSulongNode.execute(self);
            selfPtr = this.getElement.readGeneric(selfPtr, this.offset);
            if (this.type != 6 && this.type != 16 && value == DescriptorDeleteMarker.INSTANCE) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
            }
            if (this.type == 14 && !this.ensureIsSameTypeNode().executeCached((Object)PythonBuiltinClassType.Boolean, this.ensureGetClassNode().executeCached(value))) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTRIBUTE_TYPE_VALUE_MUST_BE_BOOL);
            }
            this.write.execute(selfPtr, value);
            return PNone.NONE;
        }

        private GetClassNode ensureGetClassNode() {
            if (this.getClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getClassNode;
        }

        private TypeNodes.IsSameTypeNode ensureIsSameTypeNode() {
            if (this.isSameTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSameTypeNode = (TypeNodes.IsSameTypeNode)this.insert(TypeNodes.IsSameTypeNode.create());
            }
            return this.isSameTypeNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, Object owner, TruffleString propertyName, int type, int offset) {
            if (CApiMemberAccessNodes.isReadOnlyType(type)) {
                return ReadOnlyMemberNode.createBuiltinFunction(language, propertyName);
            }
            if (type == 20) {
                return BadMemberDescrNode.createBuiltinFunction(language, propertyName);
            }
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), BUILTIN, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<WriteMemberNode>(CApiMemberAccessNodesFactory.WriteMemberNodeGen.create(type, offset)), true), CApiMemberAccessNodes.class, BUILTIN.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(BUILTIN, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, owner, 0, flags, callTarget);
        }
    }

    static abstract class WriteTypeNode
    extends Node {
        WriteTypeNode() {
        }

        abstract void execute(Object var1, Object var2);
    }

    @Builtin(name="bad_member_descr", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    protected static abstract class BadMemberDescrNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin BUILTIN = BadMemberDescrNode.class.getAnnotation(Builtin.class);

        protected BadMemberDescrNode() {
        }

        @Specialization
        Object doGeneric(Object self, Object value) {
            if (value == DescriptorDeleteMarker.INSTANCE) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
            }
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_MEMBER_DESCR_TYPE_FOR_P, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), BUILTIN, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<BadMemberDescrNode>(CApiMemberAccessNodesFactory.BadMemberDescrNodeGen.create()), true), CApiMemberAccessNodes.class, BUILTIN.name());
            int flags = PBuiltinFunction.getFlags(BUILTIN, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="member_write_read_only", minNumOfPositionalArgs=1, parameterNames={"$self", "value"})
    protected static abstract class ReadOnlyMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin BUILTIN = ReadOnlyMemberNode.class.getAnnotation(Builtin.class);
        private final TruffleString propertyName;

        protected ReadOnlyMemberNode(TruffleString propertyName) {
            this.propertyName = propertyName;
        }

        @Specialization
        Object doGeneric(Object self, Object value) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, this.propertyName, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), BUILTIN, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<ReadOnlyMemberNode>(CApiMemberAccessNodesFactory.ReadOnlyMemberNodeGen.create(propertyName)), true), CApiMemberAccessNodes.class, BUILTIN.name());
            int flags = PBuiltinFunction.getFlags(BUILTIN, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="read_member", minNumOfPositionalArgs=1, parameterNames={"$self"})
    public static abstract class ReadMemberNode
    extends PythonUnaryBuiltinNode {
        private static final Builtin BUILTIN = ReadMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;
        @Node.Child
        private CExtAsPythonObjectNode asPythonObjectNode;
        @Node.Child
        private PForeignToPTypeNode fromForeign;
        @Node.Child
        private PRaiseNode raiseNode;
        @Node.Child
        private CStructAccess.ReadBaseNode read;
        private final int type;
        private final int offset;

        protected ReadMemberNode(int type, int offset, CExtAsPythonObjectNode asPythonObjectNode) {
            this.type = type;
            this.read = CApiMemberAccessNodes.getReadNode(type);
            this.offset = offset;
            this.asPythonObjectNode = asPythonObjectNode;
            if (asPythonObjectNode == null) {
                this.fromForeign = PForeignToPTypeNode.create();
            }
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self) {
            if (this.read == null) {
                return PNone.NONE;
            }
            Object nativeResult = this.read.readGeneric(this.ensureToSulongNode().execute(self), this.offset);
            assert (!(nativeResult instanceof Byte || nativeResult instanceof Short || nativeResult instanceof Float || nativeResult instanceof Character || nativeResult instanceof PException || nativeResult instanceof String)) : nativeResult + " " + nativeResult.getClass();
            if (this.type == 16 && nativeResult == PNone.NO_VALUE) {
                throw this.ensureRaiseNode().raise(PythonBuiltinClassType.AttributeError);
            }
            if (this.type == 6 && nativeResult == PNone.NO_VALUE) {
                nativeResult = PNone.NONE;
            }
            if (this.asPythonObjectNode != null) {
                return this.asPythonObjectNode.execute(nativeResult);
            }
            return nativeResult;
        }

        private CApiTransitions.PythonToNativeNode ensureToSulongNode() {
            if (this.toSulongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSulongNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.toSulongNode;
        }

        private PRaiseNode ensureRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, Object owner, TruffleString propertyName, int type, int offset) {
            CExtAsPythonObjectNode asPythonObjectNode = CApiMemberAccessNodes.getReadConverterNode(type);
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), BUILTIN, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<ReadMemberNode>(CApiMemberAccessNodesFactory.ReadMemberNodeGen.create(type, offset, asPythonObjectNode)), true), CApiMemberAccessNodes.class, BUILTIN.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(BUILTIN, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, owner, 0, flags, callTarget);
        }
    }

    public static class HPyMemberNodeFactory<T extends PythonBuiltinBaseNode>
    implements NodeFactory<T> {
        private final T node;

        public HPyMemberNodeFactory(T node) {
            this.node = node;
        }

        public T createNode(Object ... arguments) {
            return (T)((PythonBuiltinBaseNode)NodeUtil.cloneNode(this.node));
        }

        public Class<T> getNodeClass() {
            return HPyMemberNodeFactory.determineNodeClass(this.node);
        }

        private static <T> Class<T> determineNodeClass(T node) {
            CompilerAsserts.neverPartOfCompilation();
            Class nodeClass = node.getClass();
            GeneratedBy genBy = nodeClass.getAnnotation(GeneratedBy.class);
            if (genBy != null) {
                nodeClass = genBy.value();
                assert (nodeClass.isAssignableFrom(node.getClass()));
            }
            return nodeClass;
        }

        public List<List<Class<?>>> getNodeSignatures() {
            throw new IllegalAccessError();
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            throw new IllegalAccessError();
        }
    }
}

