/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCFuncPtrType})
public final class PyCFuncPtrTypeBuiltins
extends PythonBuiltins {
    protected static final int PARAMFLAG_FIN = 1;
    protected static final int PARAMFLAG_FOUT = 2;
    protected static final int PARAMFLAG_FLCID = 4;
    protected static final TruffleString T_FLAGS_ = PythonUtils.tsLiteral("_flags_");
    protected static final TruffleString T_ARGTYPES_ = PythonUtils.tsLiteral("_argtypes_");
    protected static final TruffleString T_RESTYPE_ = PythonUtils.tsLiteral("_restype_");
    protected static final TruffleString T__CHECK_RETVAL_ = PythonUtils.tsLiteral("_check_retval_");
    protected static final TruffleString T___CTYPES_FROM_OUTPARAM__ = PythonUtils.tsLiteral("__ctypes_from_outparam__");
    private static final TruffleString T_X_BRACES = PythonUtils.tsLiteral("X{}");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCFuncPtrTypeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @ImportStatic(value={PyCPointerTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class PyCFuncPtrTypeNewNode
    extends PythonBuiltinNode {
        protected PyCFuncPtrTypeNewNode() {
        }

        @Specialization
        Object PyCFuncPtrType_new(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.TypeNode typeNew, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CastToJavaIntExactNode asNumber, @Cached PyObjectLookupAttr lookupAttr, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict, @Cached PyCallableCheckNode callableCheck, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            StgDictObject stgdict = this.factory().createStgDictObject((Object)PythonBuiltinClassType.StgDict);
            stgdict.paramfunc = 2;
            stgdict.format = T_X_BRACES;
            stgdict.flags |= 0x100;
            Object result = typeNew.execute(frame, type, args[0], args[1], args[2], kwds);
            PDict resDict = getDict.execute(result);
            if (resDict == null) {
                resDict = this.factory().createDictFixedStorage((PythonObject)result);
            }
            addAllToOtherNode.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), stgdict);
            setDict.execute(inliningTarget, result, stgdict);
            stgdict.align = FFIType.FieldDesc.P.pffi_type.alignment;
            stgdict.length = 1;
            stgdict.size = FFIType.ffi_type_pointer.size;
            stgdict.setfunc = FFIType.FieldSet.nil;
            stgdict.ffi_type_pointer = FFIType.ffi_type_pointer;
            Object ob = getItem.execute(inliningTarget, stgdict.getDictStorage(), T_FLAGS_);
            if (!PGuards.isInteger(ob)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CLASS_MUST_DEFINE_FLAGS_WHICH_MUST_BE_AN_INTEGER);
            }
            stgdict.flags = asNumber.execute(inliningTarget, ob) | 0x100;
            ob = getItem.execute(inliningTarget, stgdict.getDictStorage(), T_ARGTYPES_);
            if (ob != null) {
                if (!PGuards.isPTuple(ob)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.ARGTYPES_MUST_BE_A_SEQUENCE_OF_TYPES);
                }
                Object[] obtuple = getArray.execute(inliningTarget, ((PTuple)ob).getSequenceStorage());
                Object[] converters = PyCFuncPtrTypeNewNode.converters_from_argtypes(frame, inliningTarget, obtuple, this.getRaiseNode(), lookupAttr);
                stgdict.argtypes = obtuple;
                stgdict.converters = converters;
            }
            if (!PGuards.isPNone(ob = getItem.execute(inliningTarget, stgdict.getDictStorage(), T_RESTYPE_))) {
                StgDictObject dict = pyTypeStgDictNode.execute(ob);
                if (dict == null && !callableCheck.execute(inliningTarget, ob)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.RESTYPE_MUST_BE_A_TYPE_A_CALLABLE_OR_NONE1);
                }
                stgdict.restype = ob;
                Object checker = lookupAttr.execute((Frame)frame, inliningTarget, ob, T__CHECK_RETVAL_);
                stgdict.checker = checker != PNone.NO_VALUE ? checker : null;
            }
            return result;
        }

        static Object[] converters_from_argtypes(VirtualFrame frame, Node inliningTarget, Object[] args, PRaiseNode raiseNode, PyObjectLookupAttr lookupAttr) {
            int nArgs = args.length;
            Object[] converters = new Object[nArgs];
            for (int i = 0; i < nArgs; ++i) {
                Object tp = args[i];
                Object cnv = lookupAttr.execute((Frame)frame, inliningTarget, tp, CDataTypeBuiltins.T_FROM_PARAM);
                if (cnv == PNone.NO_VALUE) {
                    throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.ITEM_D_IN_ARGTYPES_HAS_NO_FROM_PARAM_METHOD, i + 1);
                }
                converters[i] = cnv;
            }
            return converters;
        }
    }
}

