/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(defineModule="errno")
public final class ErrnoModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return new ArrayList();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        PDict errorCode = core.factory().createDict();
        for (OSErrorEnum value : OSErrorEnum.values()) {
            this.addConstant(value.getNumber(), PythonUtils.toTruffleStringUncached(value.name()), errorCode);
        }
        this.addBuiltinConstant("errorcode", (Object)errorCode);
    }

    private void addConstant(int number, TruffleString name, PDict dict) {
        this.addBuiltinConstant(name, (Object)number);
        dict.setItem(number, name);
    }
}

