/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.HANAWkbDecoder;
import org.geolatte.geom.codec.HANAWkbEncoder;
import org.geolatte.geom.codec.MySqlWkbDecoder;
import org.geolatte.geom.codec.MySqlWkbEncoder;
import org.geolatte.geom.codec.PostgisWkbDecoder;
import org.geolatte.geom.codec.PostgisWkbEncoder;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;

public class Wkb {
    private static final Dialect DEFAULT_DIALECT = Dialect.POSTGIS_EWKB_1;
    private static final Map<Dialect, Class<? extends WkbDecoder>> DECODERS = new HashMap<Dialect, Class<? extends WkbDecoder>>();
    private static final Map<Dialect, Class<? extends WkbEncoder>> ENCODERS = new HashMap<Dialect, Class<? extends WkbEncoder>>();

    public static ByteBuffer toWkb(Geometry geometry) {
        return Wkb.toWkb(geometry, ByteOrder.NDR);
    }

    public static ByteBuffer toWkb(Geometry<?> geometry, ByteOrder byteOrder) {
        WkbEncoder encoder = Wkb.newEncoder(DEFAULT_DIALECT);
        return encoder.encode(geometry, byteOrder);
    }

    public static Geometry<?> fromWkb(ByteBuffer byteBuffer) {
        WkbDecoder decoder = Wkb.newDecoder(DEFAULT_DIALECT);
        return decoder.decode(byteBuffer);
    }

    public static WkbDecoder newDecoder(Dialect dialect) {
        Class<? extends WkbDecoder> decoderClass = DECODERS.get((Object)dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkb.createInstance(decoderClass);
    }

    public static WkbDecoder newDecoder() {
        Class<? extends WkbDecoder> decoderClass = DECODERS.get((Object)DEFAULT_DIALECT);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkb.createInstance(decoderClass);
    }

    public static WkbEncoder newEncoder(Dialect dialect) {
        Class<? extends WkbEncoder> decoderClass = ENCODERS.get((Object)dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkb.createInstance(decoderClass);
    }

    public static WkbEncoder newEncoder() {
        Class<? extends WkbEncoder> decoderClass = ENCODERS.get((Object)DEFAULT_DIALECT);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkb.createInstance(decoderClass);
    }

    private static <T> T createInstance(Class<? extends T> codecClass) {
        if (codecClass == null) {
            throw new IllegalArgumentException("Null WKB codec class argument not allowed.");
        }
        try {
            return codecClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DECODERS.put(Dialect.POSTGIS_EWKB_1, PostgisWkbDecoder.class);
        DECODERS.put(Dialect.MYSQL_WKB, MySqlWkbDecoder.class);
        DECODERS.put(Dialect.HANA_EWKB, HANAWkbDecoder.class);
        ENCODERS.put(Dialect.POSTGIS_EWKB_1, PostgisWkbEncoder.class);
        ENCODERS.put(Dialect.MYSQL_WKB, MySqlWkbEncoder.class);
        ENCODERS.put(Dialect.HANA_EWKB, HANAWkbEncoder.class);
    }

    public static enum Dialect {
        POSTGIS_EWKB_1,
        MYSQL_WKB,
        HANA_EWKB;

    }
}

