/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.test.profiler.CommandExecutionResult;
import org.flowable.engine.test.profiler.CommandStats;

public class ProfileSession {
    protected String name;
    protected Date startTime;
    protected Date endTime;
    protected long totalTime;
    protected ThreadLocal<CommandExecutionResult> currentCommandExecution = new ThreadLocal();
    protected Map<String, List<CommandExecutionResult>> commandExecutionResults = new HashMap<String, List<CommandExecutionResult>>();

    public ProfileSession(String name) {
        this.name = name;
        this.startTime = new Date();
    }

    public CommandExecutionResult getCurrentCommandExecution() {
        return this.currentCommandExecution.get();
    }

    public void setCurrentCommandExecution(CommandExecutionResult commandExecutionResult) {
        this.currentCommandExecution.set(commandExecutionResult);
    }

    public void clearCurrentCommandExecution() {
        this.currentCommandExecution.set(null);
    }

    public synchronized void addCommandExecution(String classFqn, CommandExecutionResult commandExecutionResult) {
        if (!this.commandExecutionResults.containsKey(classFqn)) {
            this.commandExecutionResults.put(classFqn, new ArrayList());
        }
        this.commandExecutionResults.get(classFqn).add(commandExecutionResult);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTimeStamp) {
        this.endTime = endTimeStamp;
        if (this.startTime != null) {
            this.totalTime = this.endTime.getTime() - this.startTime.getTime();
        }
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public Map<String, List<CommandExecutionResult>> getCommandExecutions() {
        return this.commandExecutionResults;
    }

    public void setCommandExecutions(Map<String, List<CommandExecutionResult>> commandExecutionResults) {
        this.commandExecutionResults = commandExecutionResults;
    }

    public Map<String, CommandStats> calculateSummaryStatistics() {
        HashMap<String, CommandStats> result = new HashMap<String, CommandStats>();
        for (String className : this.commandExecutionResults.keySet()) {
            List<CommandExecutionResult> executions = this.commandExecutionResults.get(className);
            CommandStats commandStats = new CommandStats(executions);
            result.put(className, commandStats);
        }
        return result;
    }
}

