/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;
import org.flowable.engine.impl.JobQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CachedEntityMatcher;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.engine.impl.persistence.entity.data.JobDataManager;
import org.flowable.engine.impl.persistence.entity.data.impl.cachematcher.JobsByExecutionIdMatcher;
import org.flowable.engine.runtime.Job;

public class MybatisJobDataManager
extends AbstractDataManager<JobEntity>
implements JobDataManager {
    protected CachedEntityMatcher<JobEntity> jobsByExecutionIdMatcher = new JobsByExecutionIdMatcher();

    public MybatisJobDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends JobEntity> getManagedEntityClass() {
        return JobEntityImpl.class;
    }

    public JobEntity create() {
        return new JobEntityImpl();
    }

    @Override
    public List<JobEntity> findJobsToExecute(Page page) {
        return this.getDbSqlSession().selectList("selectJobsToExecute", null, page);
    }

    @Override
    public List<JobEntity> findJobsByExecutionId(String executionId) {
        return this.getList("selectJobsByExecutionId", executionId, this.jobsByExecutionIdMatcher, true);
    }

    @Override
    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectJobsByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<JobEntity> findExpiredJobs(Page page) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        Date now = this.getClock().getCurrentTime();
        params.put("now", now);
        Date maxTimeout = new Date(now.getTime() - (long)this.getProcessEngineConfiguration().getAsyncExecutorResetExpiredJobsMaxTimeout());
        params.put("maxTimeout", maxTimeout);
        return this.getDbSqlSession().selectList("selectExpiredJobs", params, page);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", (ListQueryParameterObject)jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", (Object)jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }

    @Override
    public void resetExpiredJob(String jobId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", jobId);
        params.put("now", this.processEngineConfiguration.getClock().getCurrentTime());
        this.getDbSqlSession().update("resetExpiredJob", params);
    }
}

