/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import org.flowable.engine.debug.ExecutionTreeUtil;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.interceptor.CommandInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExecutionTreeCommandInvoker
extends CommandInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExecutionTreeCommandInvoker.class);

    @Override
    public void executeOperation(Runnable runnable) {
        AbstractOperation operation;
        if (runnable instanceof AbstractOperation && (operation = (AbstractOperation)runnable).getExecution() != null) {
            LOGGER.info("Execution tree while executing operation {} :", operation.getClass());
            LOGGER.info("{}", (Object)(System.lineSeparator() + ExecutionTreeUtil.buildExecutionTree(operation.getExecution())));
        }
        super.executeOperation(runnable);
    }
}

