/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class VariableRemovedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "variable-removed";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return CommandContextUtil.getHistoricVariableInstanceEntityManager(commandContext).findById(this.getStringFromJson(historicalData, "id")) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricVariableInstanceEntityManager();
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)historicVariableInstanceEntityManager.findById(this.getStringFromJson(historicalData, "id"));
        if (historicVariable != null) {
            historicVariableInstanceEntityManager.delete(historicVariable);
        }
    }
}

