/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Date;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;

public class SetTaskDueDateCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected Date dueDate;

    public SetTaskDueDateCmd(String taskId, Date dueDate) {
        super(taskId);
        this.dueDate = dueDate;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.setTaskDueDate(this.taskId, this.dueDate);
            return null;
        }
        task.setDueDate(this.dueDate);
        CommandContextUtil.getHistoryManager(commandContext).recordTaskInfoChange(task);
        CommandContextUtil.getTaskEntityManager(commandContext).update(task);
        return null;
    }
}

