/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.content.api.ContentService;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.api.FormService;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormInstanceModel;
import org.flowable.form.model.FormModel;

public class GetStartFormModelCmd
implements Command<FormModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processInstanceId;

    public GetStartFormModelCmd(String processDefinitionId, String processInstanceId) {
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
    }

    public FormModel execute(CommandContext commandContext) {
        StartEvent startEvent;
        FormService formService = CommandContextUtil.getFormService();
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        FormInstanceModel formModel = null;
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(this.processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            formModel = formService.getFormInstanceModelByKeyAndParentDeploymentId(startEvent.getFormKey(), processDefinition.getDeploymentId(), null, this.processInstanceId, null, processDefinition.getTenantId());
        }
        if (formModel == null) {
            throw new FlowableObjectNotFoundException("Form model for process definition " + this.processDefinitionId + " cannot be found");
        }
        this.fetchRelatedContentInfoIfNeeded((FormModel)formModel);
        return formModel;
    }

    protected void fetchRelatedContentInfoIfNeeded(FormModel formModel) {
        ContentService contentService = CommandContextUtil.getContentService();
        if (contentService == null) {
            return;
        }
        if (formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                if (!"upload".equals(formField.getType())) continue;
                ArrayList contentItemIds = null;
                if (formField.getValue() instanceof List) {
                    contentItemIds = (ArrayList)formField.getValue();
                } else if (formField.getValue() instanceof String) {
                    String[] splittedString = ((String)formField.getValue()).split(",");
                    contentItemIds = new ArrayList();
                    Collections.addAll(contentItemIds, splittedString);
                }
                if (contentItemIds == null) continue;
                HashSet contentItemIdSet = new HashSet(contentItemIds);
                List contentItems = contentService.createContentItemQuery().ids(contentItemIdSet).list();
                formField.setValue((Object)contentItems);
            }
        }
    }
}

