/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.task.IdentityLink;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetIdentityLinksForTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        TaskEntity task = (TaskEntity)CommandContextUtil.getTaskEntityManager(commandContext).findById(this.taskId);
        List<IdentityLink> identityLinks = task.getIdentityLinks();
        if (task.getAssignee() != null) {
            identityLink = (IdentityLinkEntity)CommandContextUtil.getIdentityLinkEntityManager(commandContext).create();
            identityLink.setUserId(task.getAssignee());
            identityLink.setType("assignee");
            identityLink.setTaskId(task.getId());
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = (IdentityLinkEntity)CommandContextUtil.getIdentityLinkEntityManager(commandContext).create();
            identityLink.setUserId(task.getOwner());
            identityLink.setTaskId(task.getId());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }
}

