/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.engine.impl.persistence.entity.SuspensionState;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String processInstanceId;

    public AbstractSetProcessInstanceStateCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new FlowableIllegalArgumentException("ProcessInstanceId cannot be null.");
        }
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findById(this.processInstanceId);
        if (executionEntity == null) {
            throw new FlowableObjectNotFoundException("Cannot find processInstance for id '" + this.processInstanceId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            throw new FlowableException("Cannot set suspension state for execution '" + this.processInstanceId + "': not a process instance.");
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, executionEntity.getProcessDefinitionId())) {
            if (this.getNewState() == SuspensionState.ACTIVE) {
                CommandContextUtil.getProcessEngineConfiguration().getFlowable5CompatibilityHandler().activateProcessInstance(this.processInstanceId);
            } else {
                CommandContextUtil.getProcessEngineConfiguration().getFlowable5CompatibilityHandler().suspendProcessInstance(this.processInstanceId);
            }
            return null;
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        executionEntityManager.update(executionEntity, false);
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(this.processInstanceId);
        for (ExecutionEntity executionEntity2 : childExecutions) {
            if (executionEntity2.getId().equals(this.processInstanceId)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity2, this.getNewState());
            executionEntityManager.update(executionEntity2, false);
        }
        List<TaskEntity> tasks = CommandContextUtil.getTaskEntityManager(commandContext).findTasksByProcessInstanceId(this.processInstanceId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(taskEntity, this.getNewState());
            CommandContextUtil.getTaskEntityManager(commandContext).update(taskEntity, false);
        }
        if (this.getNewState() == SuspensionState.ACTIVE) {
            List<SuspendedJobEntity> list = CommandContextUtil.getSuspendedJobEntityManager(commandContext).findJobsByProcessInstanceId(this.processInstanceId);
            for (SuspendedJobEntity suspendedJob : list) {
                CommandContextUtil.getJobManager(commandContext).activateSuspendedJob(suspendedJob);
            }
        } else {
            List<TimerJobEntity> list = CommandContextUtil.getTimerJobEntityManager(commandContext).findJobsByProcessInstanceId(this.processInstanceId);
            for (TimerJobEntity timerJob : list) {
                CommandContextUtil.getJobManager(commandContext).moveJobToSuspendedJob(timerJob);
            }
            List list2 = CommandContextUtil.getJobEntityManager(commandContext).findJobsByProcessInstanceId(this.processInstanceId);
            for (JobEntity job : list2) {
                CommandContextUtil.getJobManager(commandContext).moveJobToSuspendedJob(job);
            }
        }
        return null;
    }

    protected abstract SuspensionState getNewState();
}

