/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventListener;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.el.NoExecutionVariableScope;

public class DelegateExpressionFlowableEventListener
extends BaseDelegateEventListener {
    protected Expression expression;
    protected boolean failOnException;

    public DelegateExpressionFlowableEventListener(Expression expression, Class<?> entityClass) {
        this.expression = expression;
        this.setEntityClass(entityClass);
    }

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event)) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, new NoExecutionVariableScope());
            if (delegate instanceof FlowableEventListener) {
                this.failOnException = ((FlowableEventListener)delegate).isFailOnException();
                ((FlowableEventListener)delegate).onEvent(event);
            } else {
                this.failOnException = true;
                throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + FlowableEventListener.class.getName());
            }
        }
    }

    public boolean isFailOnException() {
        return this.failOnException;
    }
}

