/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor.message;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.JobQueryImpl;
import org.flowable.engine.impl.asyncexecutor.message.AsyncJobMessageHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Job;

public class AsyncJobMessageReceiver {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected AsyncJobMessageHandler asyncJobMessageHandler;

    public AsyncJobMessageReceiver() {
    }

    public AsyncJobMessageReceiver(ProcessEngineConfigurationImpl processEngineConfiguration, AsyncJobMessageHandler asyncJobMessageHandler) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.asyncJobMessageHandler = asyncJobMessageHandler;
    }

    public void messageForJobReceived(final String jobId) {
        if (this.processEngineConfiguration == null) {
            throw new FlowableException("Programmatic error: this class needs a ProcessEngineConfigurationImpl instance");
        }
        if (this.asyncJobMessageHandler == null) {
            throw new FlowableException("Programmatic error: this class needs an AsyncJobMessageHandler instance.");
        }
        this.processEngineConfiguration.getManagementService().executeCommand(new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntityManager jobEntityManager = CommandContextUtil.getJobEntityManager(commandContext);
                JobQueryImpl query = new JobQueryImpl();
                query.jobId(jobId);
                List<Job> jobs = jobEntityManager.findJobsByQueryCriteria(query);
                if (jobs == null || jobs.isEmpty()) {
                    throw new FlowableException("No job found for job id " + jobId);
                }
                if (jobs.size() > 1) {
                    throw new FlowableException("Multiple results for job id " + jobId);
                }
                if (!(jobs.get(0) instanceof JobEntity)) {
                    throw new FlowableException("Job with id " + jobId + " is not an instance of job entity, cannot handle this job");
                }
                JobEntity jobEntity = (JobEntity)jobs.get(0);
                if (AsyncJobMessageReceiver.this.asyncJobMessageHandler.handleJob(jobEntity)) {
                    jobEntityManager.delete(jobEntity);
                }
                return null;
            }
        });
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public AsyncJobMessageHandler getAsyncJobMessageHandler() {
        return this.asyncJobMessageHandler;
    }

    public void setAsyncJobMessageHandler(AsyncJobMessageHandler asyncJobMessageHandler) {
        this.asyncJobMessageHandler = asyncJobMessageHandler;
    }
}

