/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.flowable.engine.ManagementService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.management.TableMetaData;
import org.flowable.engine.common.api.management.TablePageQuery;
import org.flowable.engine.common.impl.cmd.CustomSqlExecution;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.db.DbSqlSessionFactory;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.DeadLetterJobQueryImpl;
import org.flowable.engine.impl.HistoryJobQueryImpl;
import org.flowable.engine.impl.JobQueryImpl;
import org.flowable.engine.impl.ServiceImpl;
import org.flowable.engine.impl.SuspendedJobQueryImpl;
import org.flowable.engine.impl.TablePageQueryImpl;
import org.flowable.engine.impl.TimerJobQueryImpl;
import org.flowable.engine.impl.cmd.DeleteDeadLetterJobCmd;
import org.flowable.engine.impl.cmd.DeleteEventLogEntry;
import org.flowable.engine.impl.cmd.DeleteHistoryJobCmd;
import org.flowable.engine.impl.cmd.DeleteJobCmd;
import org.flowable.engine.impl.cmd.DeleteSuspendedJobCmd;
import org.flowable.engine.impl.cmd.DeleteTimerJobCmd;
import org.flowable.engine.impl.cmd.ExecuteCustomSqlCmd;
import org.flowable.engine.impl.cmd.ExecuteJobCmd;
import org.flowable.engine.impl.cmd.GetEventLogEntriesCmd;
import org.flowable.engine.impl.cmd.GetJobExceptionStacktraceCmd;
import org.flowable.engine.impl.cmd.GetPropertiesCmd;
import org.flowable.engine.impl.cmd.GetTableCountCmd;
import org.flowable.engine.impl.cmd.GetTableMetaDataCmd;
import org.flowable.engine.impl.cmd.GetTableNameCmd;
import org.flowable.engine.impl.cmd.JobType;
import org.flowable.engine.impl.cmd.MoveDeadLetterJobToExecutableJobCmd;
import org.flowable.engine.impl.cmd.MoveJobToDeadLetterJobCmd;
import org.flowable.engine.impl.cmd.MoveTimerToExecutableJobCmd;
import org.flowable.engine.impl.cmd.RescheduleTimerJobCmd;
import org.flowable.engine.impl.cmd.SetJobRetriesCmd;
import org.flowable.engine.impl.cmd.SetTimerJobRetriesCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.DeadLetterJobQuery;
import org.flowable.engine.runtime.HistoryJobQuery;
import org.flowable.engine.runtime.Job;
import org.flowable.engine.runtime.JobQuery;
import org.flowable.engine.runtime.SuspendedJobQuery;
import org.flowable.engine.runtime.TimerJobQuery;

public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    @Override
    public Map<String, Long> getTableCount() {
        return (Map)this.commandExecutor.execute((Command)new GetTableCountCmd());
    }

    @Override
    public String getTableName(Class<?> entityClass) {
        return (String)this.commandExecutor.execute((Command)new GetTableNameCmd(entityClass));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return (TableMetaData)this.commandExecutor.execute((Command)new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("JobId is null");
        }
        try {
            this.commandExecutor.execute((Command)new ExecuteJobCmd(jobId));
        }
        catch (RuntimeException e) {
            if (e instanceof FlowableException) {
                throw e;
            }
            throw new FlowableException("Job " + jobId + " failed", (Throwable)e);
        }
    }

    @Override
    public Job moveTimerToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveTimerToExecutableJobCmd(jobId));
    }

    @Override
    public Job moveJobToDeadLetterJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveJobToDeadLetterJobCmd(jobId));
    }

    @Override
    public Job moveDeadLetterJobToExecutableJob(String jobId, int retries) {
        return (Job)this.commandExecutor.execute((Command)new MoveDeadLetterJobToExecutableJobCmd(jobId, retries));
    }

    @Override
    public void deleteJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteJobCmd(jobId));
    }

    @Override
    public void deleteTimerJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteTimerJobCmd(jobId));
    }

    @Override
    public void deleteSuspendedJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteSuspendedJobCmd(jobId));
    }

    @Override
    public void deleteDeadLetterJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteDeadLetterJobCmd(jobId));
    }

    @Override
    public void deleteHistoryJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteHistoryJobCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetJobRetriesCmd(jobId, retries));
    }

    @Override
    public void setTimerJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetTimerJobRetriesCmd(jobId, retries));
    }

    @Override
    public Job rescheduleTimeDateJob(String jobId, String timeDate) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, timeDate, null, null, null, null));
    }

    @Override
    public Job rescheduleTimeDurationJob(String jobId, String timeDuration) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, null, timeDuration, null, null, null));
    }

    @Override
    public Job rescheduleTimeCycleJob(String jobId, String timeCycle) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, null, null, timeCycle, null, null));
    }

    @Override
    public Job rescheduleTimerJob(String jobId, String timeDate, String timeDuration, String timeCycle, String endDate, String calendarName) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, timeDate, timeDuration, timeCycle, endDate, calendarName));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public TimerJobQuery createTimerJobQuery() {
        return new TimerJobQueryImpl(this.commandExecutor);
    }

    @Override
    public SuspendedJobQuery createSuspendedJobQuery() {
        return new SuspendedJobQueryImpl(this.commandExecutor);
    }

    @Override
    public DeadLetterJobQuery createDeadLetterJobQuery() {
        return new DeadLetterJobQueryImpl(this.commandExecutor);
    }

    @Override
    public HistoryJobQuery createHistoryJobQuery() {
        return new HistoryJobQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.ASYNC));
    }

    @Override
    public String getTimerJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.TIMER));
    }

    @Override
    public String getSuspendedJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.SUSPENDED));
    }

    @Override
    public String getDeadLetterJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.DEADLETTER));
    }

    @Override
    public Map<String, String> getProperties() {
        return (Map)this.commandExecutor.execute((Command)new GetPropertiesCmd());
    }

    @Override
    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        CommandConfig config = this.commandExecutor.getDefaultConfig().transactionNotSupported();
        return (String)this.commandExecutor.execute(config, (Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
                DbSqlSession dbSqlSession = new DbSqlSession(dbSqlSessionFactory, CommandContextUtil.getEntityCache(commandContext), connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                return CommandContextUtil.getProcessEngineConfiguration(commandContext).getDbSchemaManager().dbSchemaUpdate();
            }
        });
    }

    @Override
    public <T> T executeCommand(Command<T> command) {
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(command);
    }

    @Override
    public <T> T executeCommand(CommandConfig config, Command<T> command) {
        if (config == null) {
            throw new FlowableIllegalArgumentException("The config is null");
        }
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(config, command);
    }

    @Override
    public <MapperType, ResultType> ResultType executeCustomSql(CustomSqlExecution<MapperType, ResultType> customSqlExecution) {
        Class mapperClass = customSqlExecution.getMapperClass();
        return (ResultType)this.commandExecutor.execute(new ExecuteCustomSqlCmd<MapperType, ResultType>(mapperClass, customSqlExecution));
    }

    @Override
    public List<EventLogEntry> getEventLogEntries(Long startLogNr, Long pageSize) {
        return (List)this.commandExecutor.execute((Command)new GetEventLogEntriesCmd(startLogNr, pageSize));
    }

    @Override
    public List<EventLogEntry> getEventLogEntriesByProcessInstanceId(String processInstanceId) {
        return (List)this.commandExecutor.execute((Command)new GetEventLogEntriesCmd(processInstanceId));
    }

    @Override
    public void deleteEventLogEntry(long logNr) {
        this.commandExecutor.execute((Command)new DeleteEventLogEntry(logNr));
    }
}

