/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.flowable.engine.cfg.ProcessEngineConfigurator;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.CustomMyBatisTypeHandlerConfig;
import org.flowable.engine.common.impl.db.CustomMybatisTypeAliasConfig;
import org.flowable.engine.common.impl.db.DbSqlSessionFactory;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractEngineConfigurator
implements ProcessEngineConfigurator {
    @Override
    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        List<CustomMyBatisTypeHandlerConfig> typeHandlerConfigs;
        this.registerCustomDeployers(processEngineConfiguration);
        this.registerCustomMybatisMappings(processEngineConfiguration);
        List<CustomMybatisTypeAliasConfig> typeAliasConfigs = this.getMybatisTypeAliases();
        if (typeAliasConfigs != null) {
            for (CustomMybatisTypeAliasConfig customMybatisTypeAliasConfig : typeAliasConfigs) {
                if (processEngineConfiguration.getDependentEngineMybatisTypeAliasConfigs() == null) {
                    processEngineConfiguration.setDependentEngineMybatisTypeAliasConfigs(new ArrayList());
                }
                processEngineConfiguration.getDependentEngineMybatisTypeAliasConfigs().add(customMybatisTypeAliasConfig);
            }
        }
        if ((typeHandlerConfigs = this.getMybatisTypeHandlers()) != null) {
            for (CustomMyBatisTypeHandlerConfig typeHandler : typeHandlerConfigs) {
                if (processEngineConfiguration.getDependentEngineMybatisTypeHandlerConfigs() == null) {
                    processEngineConfiguration.setDependentEngineMybatisTypeHandlerConfigs(new ArrayList());
                }
                processEngineConfiguration.getDependentEngineMybatisTypeHandlerConfigs().add(typeHandler);
            }
        }
    }

    protected void registerCustomDeployers(ProcessEngineConfigurationImpl processEngineConfiguration) {
        List<Deployer> deployers = this.getCustomDeployers();
        if (deployers != null) {
            if (processEngineConfiguration.getCustomPostDeployers() == null) {
                processEngineConfiguration.setCustomPostDeployers(new ArrayList<Deployer>());
            }
            processEngineConfiguration.getCustomPostDeployers().addAll(deployers);
        }
    }

    protected abstract List<Deployer> getCustomDeployers();

    protected abstract String getMybatisCfgPath();

    protected void registerCustomMybatisMappings(ProcessEngineConfigurationImpl processEngineConfiguration) {
        String cfgPath = this.getMybatisCfgPath();
        if (cfgPath != null) {
            HashSet<String> resources = new HashSet<String>();
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(cfgPath);){
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document document = docBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName("mapper");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    resources.add(node.getAttributes().getNamedItem("resource").getTextContent());
                }
            }
            catch (IOException e) {
                throw new FlowableException("Could not read IDM Mybatis configuration file", (Throwable)e);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new FlowableException("Could not parse Mybatis configuration file", (Throwable)e);
            }
            if (processEngineConfiguration.getCustomMybatisXMLMappers() == null) {
                processEngineConfiguration.setCustomMybatisXMLMappers(resources);
            } else {
                processEngineConfiguration.getCustomMybatisXMLMappers().addAll(resources);
            }
        }
    }

    protected List<CustomMybatisTypeAliasConfig> getMybatisTypeAliases() {
        return null;
    }

    protected List<CustomMyBatisTypeHandlerConfig> getMybatisTypeHandlers() {
        return null;
    }

    protected void initialiseCommonProperties(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration, String engineKey) {
        this.initEngineConfigurations(processEngineConfiguration, targetEngineConfiguration, engineKey);
        this.initCommandContextFactory(processEngineConfiguration, targetEngineConfiguration);
        this.initDataSource(processEngineConfiguration, targetEngineConfiguration);
        this.initDbSqlSessionFactory(processEngineConfiguration, targetEngineConfiguration);
        this.initSessionFactories(processEngineConfiguration, targetEngineConfiguration);
        this.initDbProperties(processEngineConfiguration, targetEngineConfiguration);
        this.initEventDispatcher(processEngineConfiguration, targetEngineConfiguration);
        this.initClock(processEngineConfiguration, targetEngineConfiguration);
    }

    protected void initEngineConfigurations(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration, String engineKey) {
        targetEngineConfiguration.setEngineConfigurations(processEngineConfiguration.getEngineConfigurations());
    }

    protected void initCommandContextFactory(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setCommandContextFactory(processEngineConfiguration.getCommandContextFactory());
    }

    protected void initDataSource(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (processEngineConfiguration.getDataSource() == null) {
            throw new FlowableException("A datasource is required for initializing the IDM engine ");
        }
        targetEngineConfiguration.setDataSource(processEngineConfiguration.getDataSource());
    }

    protected void initDbSqlSessionFactory(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        DbSqlSessionFactory dbSqlSessionFactory = processEngineConfiguration.getDbSqlSessionFactory();
        targetEngineConfiguration.setDbSqlSessionFactory(processEngineConfiguration.getDbSqlSessionFactory());
        targetEngineConfiguration.setSqlSessionFactory(processEngineConfiguration.getSqlSessionFactory());
        if (this.getEntityInsertionOrder() != null) {
            for (Class<? extends Entity> clazz : this.getEntityInsertionOrder()) {
                dbSqlSessionFactory.getInsertionOrder().add(clazz);
            }
        }
        if (this.getEntityDeletionOrder() != null) {
            for (Class<? extends Entity> clazz : this.getEntityDeletionOrder()) {
                dbSqlSessionFactory.getDeletionOrder().add(clazz);
            }
        }
    }

    protected void initSessionFactories(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setSessionFactories(processEngineConfiguration.getSessionFactories());
    }

    protected void initDbProperties(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setDatabaseType(processEngineConfiguration.getDatabaseType());
        targetEngineConfiguration.setDatabaseCatalog(processEngineConfiguration.getDatabaseCatalog());
        targetEngineConfiguration.setDatabaseSchema(processEngineConfiguration.getDatabaseSchema());
        targetEngineConfiguration.setDatabaseSchemaUpdate(processEngineConfiguration.getDatabaseSchemaUpdate());
        targetEngineConfiguration.setDatabaseTablePrefix(processEngineConfiguration.getDatabaseTablePrefix());
        targetEngineConfiguration.setDatabaseWildcardEscapeCharacter(processEngineConfiguration.getDatabaseWildcardEscapeCharacter());
        targetEngineConfiguration.setDefaultCommandConfig(processEngineConfiguration.getDefaultCommandConfig());
        targetEngineConfiguration.setSchemaCommandConfig(processEngineConfiguration.getSchemaCommandConfig());
        targetEngineConfiguration.setTransactionFactory(processEngineConfiguration.getTransactionFactory());
        targetEngineConfiguration.setTransactionContextFactory(processEngineConfiguration.getTransactionContextFactory());
        targetEngineConfiguration.setTransactionsExternallyManaged(processEngineConfiguration.isTransactionsExternallyManaged());
    }

    protected void initEventDispatcher(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (processEngineConfiguration.getEventDispatcher() != null) {
            targetEngineConfiguration.setEventDispatcher(processEngineConfiguration.getEventDispatcher());
        }
    }

    protected void initClock(ProcessEngineConfigurationImpl processEngineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setClock(processEngineConfiguration.getClock());
    }

    protected abstract List<Class<? extends Entity>> getEntityInsertionOrder();

    protected abstract List<Class<? extends Entity>> getEntityDeletionOrder();
}

