/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.history.HistoricMilestoneInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryConfigurationSettings;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryHelper;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.history.HistoricMilestoneInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.history.HistoricPlanItemInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.entitylink.api.history.HistoricEntityLink;
import org.flowable.entitylink.api.history.HistoricEntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.entitylink.service.impl.persistence.entity.HistoricEntityLinkEntity;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class DefaultCmmnHistoryManager
implements CmmnHistoryManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCmmnHistoryManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected CmmnHistoryConfigurationSettings getHistoryConfigurationSettings() {
        return this.cmmnEngineConfiguration.getCmmnHistoryConfigurationSettings();
    }

    @Override
    public void recordCaseInstanceStart(CaseInstanceEntity caseInstanceEntity) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity)) {
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
            HistoricCaseInstanceEntity historicCaseInstanceEntity = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager().create(caseInstanceEntity);
            historicCaseInstanceEntityManager.insert(historicCaseInstanceEntity);
        }
    }

    @Override
    public void recordCaseInstanceEnd(CaseInstanceEntity caseInstanceEntity, String state, Date endTime) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setEndTime(endTime);
            historicCaseInstanceEntity.setState(state);
        }
    }

    @Override
    public void recordHistoricCaseInstanceReactivated(CaseInstanceEntity caseInstanceEntity) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setEndTime(null);
            historicCaseInstanceEntity.setState(caseInstanceEntity.getState());
            historicCaseInstanceEntity.setLastReactivationTime(caseInstanceEntity.getLastReactivationTime());
            historicCaseInstanceEntity.setLastReactivationUserId(caseInstanceEntity.getLastReactivationUserId());
        }
    }

    @Override
    public void recordUpdateCaseInstanceName(CaseInstanceEntity caseInstanceEntity, String name) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setName(name);
        }
    }

    @Override
    public void recordUpdateBusinessKey(CaseInstanceEntity caseInstanceEntity, String businessKey) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (caseInstanceEntity != null && this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setBusinessKey(businessKey);
        }
    }

    @Override
    public void recordUpdateBusinessStatus(CaseInstanceEntity caseInstanceEntity, String businessStatus) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (caseInstanceEntity != null && this.getHistoryConfigurationSettings().isHistoryEnabledForCaseInstance(caseInstanceEntity) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setBusinessStatus(businessStatus);
        }
    }

    @Override
    public void recordMilestoneReached(MilestoneInstanceEntity milestoneInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForMilestone(milestoneInstance)) {
            HistoricMilestoneInstanceEntityManager historicMilestoneInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricMilestoneInstanceEntityManager();
            HistoricMilestoneInstanceEntity historicMilestoneInstanceEntity = (HistoricMilestoneInstanceEntity)historicMilestoneInstanceEntityManager.create();
            historicMilestoneInstanceEntity.setId(milestoneInstance.getId());
            historicMilestoneInstanceEntity.setName(milestoneInstance.getName());
            historicMilestoneInstanceEntity.setCaseInstanceId(milestoneInstance.getCaseInstanceId());
            historicMilestoneInstanceEntity.setCaseDefinitionId(milestoneInstance.getCaseDefinitionId());
            historicMilestoneInstanceEntity.setElementId(milestoneInstance.getElementId());
            historicMilestoneInstanceEntity.setTimeStamp(this.cmmnEngineConfiguration.getClock().getCurrentTime());
            historicMilestoneInstanceEntity.setTenantId(milestoneInstance.getTenantId());
            historicMilestoneInstanceEntityManager.insert(historicMilestoneInstanceEntity);
        }
    }

    @Override
    public void recordHistoricCaseInstanceDeleted(String caseInstanceId, String tenantId) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabled()) {
            CmmnHistoryHelper.deleteHistoricCaseInstance(this.cmmnEngineConfiguration, caseInstanceId);
        }
    }

    @Override
    public void recordBulkDeleteHistoricCaseInstances(Collection<String> caseInstanceIds) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabled()) {
            CmmnHistoryHelper.bulkDeleteHistoricCaseInstances(caseInstanceIds, this.cmmnEngineConfiguration);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForIdentityLink(identityLink) && (identityLink.getScopeId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkService historicIdentityLinkService = this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setGroupId(identityLink.getGroupId());
            historicIdentityLinkEntity.setScopeDefinitionId(identityLink.getScopeDefinitionId());
            historicIdentityLinkEntity.setScopeId(identityLink.getScopeId());
            historicIdentityLinkEntity.setSubScopeId(identityLink.getSubScopeId());
            historicIdentityLinkEntity.setScopeType(identityLink.getScopeType());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setUserId(identityLink.getUserId());
            historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForIdentityLink(identityLink)) {
            this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().deleteHistoricIdentityLink(identityLink.getId());
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForEntityLink(entityLink) && entityLink.getScopeId() != null) {
            HistoricEntityLinkService historicEntityLinkService = this.cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService();
            HistoricEntityLinkEntity historicEntityLinkEntity = (HistoricEntityLinkEntity)historicEntityLinkService.createHistoricEntityLink();
            historicEntityLinkEntity.setId(entityLink.getId());
            historicEntityLinkEntity.setLinkType(entityLink.getLinkType());
            historicEntityLinkEntity.setCreateTime(entityLink.getCreateTime());
            historicEntityLinkEntity.setScopeId(entityLink.getScopeId());
            historicEntityLinkEntity.setSubScopeId(entityLink.getSubScopeId());
            historicEntityLinkEntity.setScopeType(entityLink.getScopeType());
            historicEntityLinkEntity.setScopeDefinitionId(entityLink.getScopeDefinitionId());
            historicEntityLinkEntity.setParentElementId(entityLink.getParentElementId());
            historicEntityLinkEntity.setReferenceScopeId(entityLink.getReferenceScopeId());
            historicEntityLinkEntity.setReferenceScopeType(entityLink.getReferenceScopeType());
            historicEntityLinkEntity.setReferenceScopeDefinitionId(entityLink.getReferenceScopeDefinitionId());
            historicEntityLinkEntity.setRootScopeId(entityLink.getRootScopeId());
            historicEntityLinkEntity.setRootScopeType(entityLink.getRootScopeType());
            historicEntityLinkEntity.setHierarchyType(entityLink.getHierarchyType());
            historicEntityLinkService.insertHistoricEntityLink((HistoricEntityLink)historicEntityLinkEntity, false);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForEntityLink(entityLink)) {
            this.cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService().deleteHistoricEntityLink(entityLink.getId());
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variableInstanceEntity, Date createTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variableInstanceEntity)) {
            this.cmmnEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().createAndInsert(variableInstanceEntity, createTime);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variableInstanceEntity, Date updateTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variableInstanceEntity)) {
            this.cmmnEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().recordVariableUpdate(variableInstanceEntity, updateTime);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variableInstanceEntity) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variableInstanceEntity)) {
            this.cmmnEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().recordVariableRemoved(variableInstanceEntity);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)task)) {
            this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().recordTaskCreated(task);
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, String userId, String deleteReason, Date endTime) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)task) && (historicTaskInstance = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().recordTaskEnd(task, deleteReason, endTime)) != null) {
            historicTaskInstance.setState("completed");
            historicTaskInstance.setCompletedBy(userId);
            historicTaskInstance.setLastUpdateTime(endTime);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity task, Date changeTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)task)) {
            this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().recordTaskInfoChange(task, changeTime, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
        }
    }

    @Override
    public void recordHistoricTaskDeleted(HistoricTaskInstance task) {
        if (task != null && this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)task)) {
            TaskHelper.deleteHistoricTask(task.getId(), this.cmmnEngineConfiguration);
        }
    }

    @Override
    public void recordPlanItemInstanceCreated(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForPlanItemInstance(planItemInstanceEntity)) {
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
            HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity = historicPlanItemInstanceEntityManager.create((PlanItemInstance)planItemInstanceEntity);
            historicPlanItemInstanceEntity.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
            historicPlanItemInstanceEntityManager.insert(historicPlanItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceReactivated(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForPlanItemInstance(planItemInstanceEntity)) {
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
            HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity = historicPlanItemInstanceEntityManager.create((PlanItemInstance)planItemInstanceEntity);
            historicPlanItemInstanceEntity.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
            historicPlanItemInstanceEntityManager.insert(historicPlanItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceUpdated(PlanItemInstanceEntity planItemInstanceEntity) {
        HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager;
        HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForPlanItemInstance(planItemInstanceEntity) && (historicPlanItemInstanceEntity = (HistoricPlanItemInstanceEntity)(historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager()).findById(planItemInstanceEntity.getId())) != null) {
            historicPlanItemInstanceEntity.setFormKey(planItemInstanceEntity.getFormKey());
            historicPlanItemInstanceEntity.setElementId(planItemInstanceEntity.getElementId());
        }
    }

    @Override
    public void recordPlanItemInstanceAvailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastAvailableTime(), h -> h.setLastAvailableTime(planItemInstanceEntity.getLastAvailableTime()));
    }

    @Override
    public void recordPlanItemInstanceUnavailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastUnavailableTime(), h -> h.setLastUnavailableTime(planItemInstanceEntity.getLastUnavailableTime()));
    }

    @Override
    public void recordPlanItemInstanceEnabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastEnabledTime(), h -> h.setLastEnabledTime(planItemInstanceEntity.getLastEnabledTime()));
    }

    @Override
    public void recordPlanItemInstanceDisabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastDisabledTime(), h -> h.setLastDisabledTime(planItemInstanceEntity.getLastDisabledTime()));
    }

    @Override
    public void recordPlanItemInstanceStarted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastStartedTime(), h -> {
            h.setLastStartedTime(planItemInstanceEntity.getLastStartedTime());
            h.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
            h.setReferenceId(planItemInstanceEntity.getReferenceId());
            h.setReferenceType(planItemInstanceEntity.getReferenceType());
        });
    }

    @Override
    public void recordPlanItemInstanceSuspended(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, planItemInstanceEntity.getLastSuspendedTime(), h -> h.setLastSuspendedTime(planItemInstanceEntity.getLastSuspendedTime()));
    }

    @Override
    public void recordPlanItemInstanceCompleted(PlanItemInstanceEntity planItemInstanceEntity) {
        Date completedTime = planItemInstanceEntity.getCompletedTime();
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, completedTime, h -> {
            h.setEndedTime(completedTime);
            h.setCompletedTime(completedTime);
            h.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
        });
    }

    @Override
    public void recordPlanItemInstanceTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        Date terminatedTime = planItemInstanceEntity.getTerminatedTime();
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, terminatedTime, h -> {
            h.setEndedTime(terminatedTime);
            h.setTerminatedTime(terminatedTime);
            h.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
        });
    }

    @Override
    public void recordPlanItemInstanceOccurred(PlanItemInstanceEntity planItemInstanceEntity) {
        Date occurredTime = planItemInstanceEntity.getOccurredTime();
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, occurredTime, h -> {
            h.setEndedTime(occurredTime);
            h.setOccurredTime(occurredTime);
            h.setShowInOverview(this.evaluateShowInOverview(planItemInstanceEntity));
        });
    }

    @Override
    public void recordPlanItemInstanceExit(PlanItemInstanceEntity planItemInstanceEntity) {
        Date exitTime = planItemInstanceEntity.getExitTime();
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, exitTime, h -> {
            h.setEndedTime(exitTime);
            h.setExitTime(exitTime);
        });
    }

    @Override
    public void updateCaseDefinitionIdInHistory(CaseDefinition caseDefinition, CaseInstanceEntity caseInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabled(caseDefinition.getId())) {
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
            HistoricCaseInstanceEntity historicCaseInstance = (HistoricCaseInstanceEntity)historicCaseInstanceEntityManager.findById(caseInstance.getId());
            historicCaseInstance.setCaseDefinitionId(caseDefinition.getId());
            historicCaseInstanceEntityManager.update(historicCaseInstance);
            HistoricTaskService historicTaskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            HistoricTaskInstanceQueryImpl taskQuery = new HistoricTaskInstanceQueryImpl();
            taskQuery.caseInstanceId(caseInstance.getId());
            List historicTasks = historicTaskService.findHistoricTaskInstancesByQueryCriteria(taskQuery);
            if (historicTasks != null) {
                for (HistoricTaskInstance historicTaskInstance : historicTasks) {
                    HistoricTaskInstanceEntity taskEntity = (HistoricTaskInstanceEntity)historicTaskInstance;
                    taskEntity.setScopeDefinitionId(caseDefinition.getId());
                    historicTaskService.updateHistoricTask(taskEntity, true);
                }
            }
            HistoricPlanItemInstanceQueryImpl historicPlanItemQuery = new HistoricPlanItemInstanceQueryImpl();
            historicPlanItemQuery.planItemInstanceCaseInstanceId(caseInstance.getId());
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
            List<HistoricPlanItemInstance> historicPlanItems = historicPlanItemInstanceEntityManager.findByCriteria(historicPlanItemQuery);
            if (historicPlanItems != null) {
                for (HistoricPlanItemInstance historicPlanItemInstance : historicPlanItems) {
                    HistoricPlanItemInstanceEntity planItemEntity = (HistoricPlanItemInstanceEntity)historicPlanItemInstance;
                    planItemEntity.setCaseDefinitionId(caseDefinition.getId());
                    historicPlanItemInstanceEntityManager.update(planItemEntity);
                }
            }
            HistoricMilestoneInstanceQueryImpl historicMilestoneInstanceQuery = new HistoricMilestoneInstanceQueryImpl();
            historicMilestoneInstanceQuery.milestoneInstanceCaseInstanceId(caseInstance.getId());
            HistoricMilestoneInstanceEntityManager historicMilestoneInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricMilestoneInstanceEntityManager();
            List<HistoricMilestoneInstance> historicMilestoneInstances = historicMilestoneInstanceEntityManager.findHistoricMilestoneInstancesByQueryCriteria(historicMilestoneInstanceQuery);
            if (historicMilestoneInstances != null) {
                for (HistoricMilestoneInstance historicMilestoneInstance : historicMilestoneInstances) {
                    HistoricMilestoneInstanceEntity milestoneEntity = (HistoricMilestoneInstanceEntity)historicMilestoneInstance;
                    milestoneEntity.setCaseDefinitionId(caseDefinition.getId());
                    historicMilestoneInstanceEntityManager.update(milestoneEntity);
                }
            }
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().createHistoricTaskLogEntry(taskLogEntryBuilder);
    }

    @Override
    public void deleteHistoricUserTaskLogEntry(long logNumber) {
        this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().deleteHistoricTaskLogEntry(logNumber);
    }

    protected void recordHistoricPlanItemInstanceEntity(PlanItemInstanceEntity planItemInstanceEntity, Date lastUpdatedTime, Consumer<HistoricPlanItemInstanceEntity> changes) {
        HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager;
        HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForPlanItemInstance(planItemInstanceEntity) && (historicPlanItemInstanceEntity = (HistoricPlanItemInstanceEntity)(historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager()).findById(planItemInstanceEntity.getId())) != null) {
            historicPlanItemInstanceEntity.setState(planItemInstanceEntity.getState());
            historicPlanItemInstanceEntity.setLastUpdatedTime(lastUpdatedTime);
            changes.accept(historicPlanItemInstanceEntity);
            historicPlanItemInstanceEntity.setEntryCriterionId(planItemInstanceEntity.getEntryCriterionId());
            historicPlanItemInstanceEntity.setExitCriterionId(planItemInstanceEntity.getExitCriterionId());
        }
    }

    public boolean evaluateShowInOverview(PlanItemInstanceEntity planItemInstanceEntity) {
        boolean showInOverview = false;
        if (planItemInstanceEntity.getPlanItem() != null) {
            PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
            String includeInStageOverviewValue = null;
            if (planItemInstanceEntity.isStage()) {
                if (planItemDefinition instanceof Stage) {
                    Stage stage = (Stage)planItemDefinition;
                    includeInStageOverviewValue = stage.getIncludeInStageOverview();
                }
            } else if (planItemDefinition instanceof Milestone) {
                Milestone milestone = (Milestone)planItemDefinition;
                includeInStageOverviewValue = milestone.getIncludeInStageOverview();
            }
            if (StringUtils.isNotEmpty(includeInStageOverviewValue)) {
                if ("true".equalsIgnoreCase(includeInStageOverviewValue)) {
                    showInOverview = true;
                } else if (!"false".equalsIgnoreCase(includeInStageOverviewValue)) {
                    Expression stageExpression = this.cmmnEngineConfiguration.getExpressionManager().createExpression(includeInStageOverviewValue);
                    Object stageValueObject = stageExpression.getValue((VariableContainer)planItemInstanceEntity);
                    if (!(stageValueObject instanceof Boolean)) {
                        throw new FlowableException("Include in stage overview expression does not resolve to a boolean value " + includeInStageOverviewValue + ": " + stageValueObject + " for " + planItemInstanceEntity);
                    }
                    showInOverview = (Boolean)stageValueObject;
                }
            }
        }
        return showInOverview;
    }
}

