/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CompositeCmmnHistoryManager
implements CmmnHistoryManager {
    protected final Collection<CmmnHistoryManager> historyManagers;

    public CompositeCmmnHistoryManager(Collection<CmmnHistoryManager> historyManagers) {
        this.historyManagers = new ArrayList<CmmnHistoryManager>(historyManagers);
    }

    @Override
    public void recordCaseInstanceStart(CaseInstanceEntity caseInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordCaseInstanceStart(caseInstanceEntity);
        }
    }

    @Override
    public void recordCaseInstanceEnd(CaseInstanceEntity caseInstanceEntity, String state, Date endTime) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordCaseInstanceEnd(caseInstanceEntity, state, endTime);
        }
    }

    @Override
    public void recordHistoricCaseInstanceReactivated(CaseInstanceEntity caseInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricCaseInstanceReactivated(caseInstanceEntity);
        }
    }

    @Override
    public void recordUpdateCaseInstanceName(CaseInstanceEntity caseInstanceEntity, String name) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordUpdateCaseInstanceName(caseInstanceEntity, name);
        }
    }

    @Override
    public void recordUpdateBusinessKey(CaseInstanceEntity caseInstanceEntity, String businessKey) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordUpdateBusinessKey(caseInstanceEntity, businessKey);
        }
    }

    @Override
    public void recordUpdateBusinessStatus(CaseInstanceEntity caseInstanceEntity, String businessStatus) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordUpdateBusinessStatus(caseInstanceEntity, businessStatus);
        }
    }

    @Override
    public void recordMilestoneReached(MilestoneInstanceEntity milestoneInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordMilestoneReached(milestoneInstanceEntity);
        }
    }

    @Override
    public void recordHistoricCaseInstanceDeleted(String caseInstanceId, String tenantId) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricCaseInstanceDeleted(caseInstanceId, tenantId);
        }
    }

    @Override
    public void recordBulkDeleteHistoricCaseInstances(Collection<String> caseInstanceIds) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordBulkDeleteHistoricCaseInstances(caseInstanceIds);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordIdentityLinkCreated(identityLink);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordIdentityLinkDeleted(identityLink);
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordEntityLinkCreated(entityLink);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordEntityLinkDeleted(entityLink);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableCreate(variable, createTime);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable, Date updateTime) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableUpdate(variable, updateTime);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableRemoved(variable);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskCreated(task);
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, String userId, String deleteReason, Date endTime) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskEnd(task, userId, deleteReason, endTime);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, Date changeTime) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskInfoChange(taskEntity, changeTime);
        }
    }

    @Override
    public void recordHistoricTaskDeleted(HistoricTaskInstance task) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricTaskDeleted(task);
        }
    }

    @Override
    public void recordPlanItemInstanceCreated(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceCreated(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceReactivated(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceReactivated(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceUpdated(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceUpdated(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceAvailable(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceAvailable(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceUnavailable(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceUnavailable(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceEnabled(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceEnabled(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceDisabled(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceDisabled(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceStarted(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceStarted(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceSuspended(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceSuspended(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceCompleted(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceCompleted(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceOccurred(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceOccurred(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceTerminated(planItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceExit(PlanItemInstanceEntity planItemInstanceEntity) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordPlanItemInstanceExit(planItemInstanceEntity);
        }
    }

    @Override
    public void updateCaseDefinitionIdInHistory(CaseDefinition caseDefinition, CaseInstanceEntity caseInstance) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.updateCaseDefinitionIdInHistory(caseDefinition, caseInstance);
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricUserTaskLogEntry(taskLogEntryBuilder);
        }
    }

    @Override
    public void deleteHistoricUserTaskLogEntry(long logNumber) {
        for (CmmnHistoryManager historyManager : this.historyManagers) {
            historyManager.deleteHistoricUserTaskLogEntry(logNumber);
        }
    }

    public void addHistoryManager(CmmnHistoryManager historyManager) {
        this.historyManagers.add(historyManager);
    }
}

