/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.db;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDbSchemaManager
implements SchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDbSchemaManager.class);
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/app/db/liquibase/flowable-app-db-changelog.xml";

    public void initSchema() {
        this.initSchema(CommandContextUtil.getAppEngineConfiguration());
    }

    public void initSchema(AppEngineConfiguration appEngineConfiguration) {
        this.initSchema(appEngineConfiguration, appEngineConfiguration.getDatabaseSchemaUpdate());
    }

    public void initSchema(AppEngineConfiguration appEngineConfiguration, String databaseSchemaUpdate) {
        Liquibase liquibase = null;
        try {
            if ("create-drop".equals(databaseSchemaUpdate)) {
                this.schemaCreate();
            } else if ("drop-create".equals(databaseSchemaUpdate)) {
                this.schemaDrop();
                this.schemaCreate();
            } else if ("true".equals(databaseSchemaUpdate)) {
                this.schemaUpdate();
            } else if ("false".equals(databaseSchemaUpdate)) {
                this.schemaCheckVersion();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising app data model", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    protected Liquibase createLiquibaseInstance(AppEngineConfiguration appEngineConfiguration) throws SQLException, DatabaseException, LiquibaseException {
        String databaseCatalog;
        Connection jdbcConnection = null;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        jdbcConnection = commandContext == null ? appEngineConfiguration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            jdbcConnection.commit();
        }
        JdbcConnection connection = new JdbcConnection(jdbcConnection);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        database.setDatabaseChangeLogTableName("ACT_APP_" + database.getDatabaseChangeLogTableName());
        database.setDatabaseChangeLogLockTableName("ACT_APP_" + database.getDatabaseChangeLogLockTableName());
        String databaseSchema = appEngineConfiguration.getDatabaseSchema();
        if (StringUtils.isNotEmpty((CharSequence)databaseSchema)) {
            database.setDefaultSchemaName(databaseSchema);
            database.setLiquibaseSchemaName(databaseSchema);
        }
        if (StringUtils.isNotEmpty((CharSequence)(databaseCatalog = appEngineConfiguration.getDatabaseCatalog()))) {
            database.setDefaultCatalogName(databaseCatalog);
            database.setLiquibaseCatalogName(databaseCatalog);
        }
        return this.createLiquibaseInstance(database);
    }

    public Liquibase createLiquibaseInstance(Database database) throws LiquibaseException {
        return new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
    }

    public void schemaCreate() {
        Liquibase liquibase = null;
        try {
            this.getCommonSchemaManager().schemaCreate();
            this.getIdentityLinkSchemaManager().schemaCreate();
            this.getVariableSchemaManager().schemaCreate();
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.update("app");
            this.closeDatabase(liquibase);
        }
        catch (Exception e) {
            try {
                throw new FlowableException("Error creating App engine tables", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
    }

    public void schemaDrop() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.dropAll();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping App engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
        try {
            this.getVariableSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String schemaUpdate() {
        Liquibase liquibase = null;
        try {
            this.getCommonSchemaManager().schemaUpdate();
            if (CommandContextUtil.getAppEngineConfiguration().isExecuteServiceSchemaManagers()) {
                this.getIdentityLinkSchemaManager().schemaUpdate();
                this.getVariableSchemaManager().schemaUpdate();
            }
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.update("cmmn");
            this.closeDatabase(liquibase);
        }
        catch (Exception e) {
            try {
                throw new FlowableException("Error updating App engine tables", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        return null;
    }

    public void schemaCheckVersion() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.validate();
        }
        catch (Exception e) {
            throw new FlowableException("Error validating app engine schema", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getCommonSchemaManager();
    }

    protected SchemaManager getIdentityLinkSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getIdentityLinkSchemaManager();
    }

    protected SchemaManager getVariableSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getVariableSchemaManager();
    }

    private void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null && CommandContextUtil.getCommandContext() == null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                LOGGER.warn("Error closing database", (Throwable)e);
            }
        }
    }
}

