/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring.autodeployment;

import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.flowable.common.engine.api.FlowableException;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "default";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(Resource[] resources, AppRepositoryService repositoryService) {
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            if (resourceName.contains("/")) {
                resourceName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            } else if (resourceName.contains("\\")) {
                resourceName = resourceName.substring(resourceName.lastIndexOf("\\") + 1);
            }
            AppDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            try {
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip")) {
                    deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                } else {
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
            }
            catch (IOException e) {
                throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
            deploymentBuilder.deploy();
        }
    }
}

