/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jaybird.util.FbDatetimeConversion;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

class FBTimestampField
extends AbstractWithoutTimeZoneField {
    @NullMarked
    FBTimestampField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getTimestamp();
    }

    @Override
    public String getString() throws SQLException {
        return this.convertForGet(this.getLocalDateTime(), FbDatetimeConversion::formatSqlTimestamp, String.class);
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        return localDateTime != null ? localDateTime.toLocalDate() : null;
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        return localDateTime != null ? localDateTime.toLocalTime() : null;
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        return this.getDatatypeCoder().decodeLocalDateTime(this.getFieldData());
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setLocalDateTime(this.fromString(value, FbDatetimeConversion::parseIsoOrSqlTimestamp));
    }

    @Override
    void setLocalDate(LocalDate value) throws SQLException {
        this.setLocalDateTime(this.convertForSet(value, LocalDate::atStartOfDay, LocalDate.class));
    }

    @Override
    void setLocalTime(LocalTime value) throws SQLException {
        this.setLocalDateTime(this.convertForSet(value, LocalDate.EPOCH::atTime, LocalTime.class));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeLocalDateTime(value));
    }
}

