/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.function.Function;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jaybird.util.FbDatetimeConversion;
import org.firebirdsql.jaybird.util.IOUtils;
import org.firebirdsql.jaybird.util.LegacyDatetimeConversions;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TrimmableField;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

class FBStringField
extends FBField
implements TrimmableField {
    static final String SHORT_TRUE = "Y";
    static final String SHORT_FALSE = "N";
    static final String LONG_TRUE = "true";
    static final String LONG_FALSE = "false";
    static final String SHORT_TRUE_2 = "T";
    static final String SHORT_TRUE_3 = "1";
    protected final int possibleCharLength;
    private boolean trimTrailing;

    @NullMarked
    FBStringField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        int charLength = fieldDescriptor.getCharacterLength();
        this.possibleCharLength = charLength != -1 ? charLength : fieldDescriptor.getLength();
    }

    @Override
    public final void setTrimTrailing(boolean trimTrailing) {
        this.trimTrailing = trimTrailing;
    }

    @Override
    public final boolean isTrimTrailing() {
        return this.trimTrailing;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("byte", string, (Throwable)nfex);
        }
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("short", string, (Throwable)nfex);
        }
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("int", string, (Throwable)nfex);
        }
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        String string = this.getString().trim();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("long", string, (Throwable)nfex);
        }
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.getValueAs(BigDecimal.class, BigDecimal::new);
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        String string = this.getString().trim();
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("float", string, (Throwable)nfex);
        }
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        String string = this.getString().trim();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException nfex) {
            throw this.invalidGetConversion("double", string, (Throwable)nfex);
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        String trimmedValue = this.getString().trim();
        return trimmedValue.equalsIgnoreCase(LONG_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_2) || trimmedValue.equals(SHORT_TRUE_3);
    }

    @Override
    public String getString() throws SQLException {
        String result = this.applyTrimTrailing(this.getDatatypeCoder().decodeString(this.getFieldData()));
        if (this.requiredType == 12 || this.isTrimTrailing()) {
            return result;
        }
        return this.fixPadding(result);
    }

    private String fixPadding(String result) {
        if (result != null && result.length() > this.possibleCharLength && result.codePointCount(0, result.length()) > this.possibleCharLength) {
            return result.substring(0, result.offsetByCodePoints(0, this.possibleCharLength));
        }
        return result;
    }

    final String applyTrimTrailing(String value) {
        return this.trimTrailing ? TrimmableField.trimTrailing(value) : value;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return (byte[])this.getFieldData().clone();
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        return this.getValueAs(LocalDate.class, FbDatetimeConversion::parseSqlDate);
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        return this.getValueAs(LocalTime.class, LocalTime::parse);
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        return this.convertForGet(this.getLocalDateTime(), Timestamp::valueOf, Timestamp.class);
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        return this.getValueAs(LocalDateTime.class, FbDatetimeConversion::parseIsoOrSqlTimestamp);
    }

    @Override
    OffsetTime getOffsetTime() throws SQLException {
        return this.getValueAs(OffsetTime.class, OffsetTime::parse);
    }

    @Override
    OffsetDateTime getOffsetDateTime() throws SQLException {
        return this.getValueAs(OffsetDateTime.class, OffsetDateTime::parse);
    }

    @Override
    ZonedDateTime getZonedDateTime() throws SQLException {
        return this.getValueAs(ZonedDateTime.class, ZonedDateTime::parse);
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        return this.getValueAs(BigInteger.class, BigInteger::new);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setString(Byte.toString(value));
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setString(Short.toString(value));
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setString(Integer.toString(value));
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setString(Long.toString(value));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setString(Float.toString(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setString(Double.toString(value));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        if (this.possibleCharLength > 4) {
            this.setString(value ? LONG_TRUE : LONG_FALSE);
        } else {
            this.setString(value ? SHORT_TRUE : SHORT_FALSE);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        int codePointCount;
        if (this.setWhenNull(value)) {
            return;
        }
        DatatypeCoder datatypeCoder = this.getDatatypeCoder();
        EncodingDefinition encodingDefinition = datatypeCoder.getEncodingDefinition();
        if (encodingDefinition.getFirebirdCharacterSetId() == 4 && value.length() > this.possibleCharLength && (codePointCount = value.codePointCount(0, value.length())) > this.possibleCharLength) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, codePointCount, this.possibleCharLength);
        }
        byte[] data = datatypeCoder.encodeString(value);
        if (data.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, data.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(data);
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setBytes(IOUtils.toBytes(in, (int)length));
        }
        catch (IOException ioex) {
            throw this.invalidSetConversion(InputStream.class, ioex);
        }
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setString(IOUtils.toString(in, (int)length));
        }
        catch (IOException ioex) {
            throw this.invalidSetConversion(Reader.class, ioex);
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, value.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(value);
    }

    @Override
    void setLocalDate(LocalDate localDate) throws SQLException {
        this.setAsString(localDate);
    }

    @Override
    void setLocalTime(LocalTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        this.setString(this.convertForSet(value, v -> FbDatetimeConversion.formatSqlTimestamp(LegacyDatetimeConversions.toLocalDateTime(v, cal)), Timestamp.class));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        this.setString(this.convertForSet(value, v -> FbDatetimeConversion.formatSqlTimestamp(v.toLocalDateTime()), Timestamp.class));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setOffsetTime(OffsetTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setOffsetDateTime(OffsetDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setZonedDateTime(ZonedDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        this.setAsString(value);
    }

    private void setAsString(Object value) throws SQLException {
        this.setString(value != null ? value.toString() : null);
    }

    private <T> T getValueAs(@NonNull Class<T> type, @NonNull Function<String, T> converter) throws SQLException {
        return this.convertForGet(this.getString(), converter.compose(String::trim), type);
    }
}

