/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

final class FBLongField
extends FBField {
    private static final BigDecimal BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    @NullMarked
    FBLongField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getLong();
    }

    @Override
    public byte getByte() throws SQLException {
        long value = this.getLong();
        if (value > 127L || value < -128L) {
            throw this.outOfRangeGetConversion("byte", value);
        }
        return (byte)value;
    }

    @NullMarked
    private SQLException outOfRangeGetConversion(String type, long value) {
        return this.invalidGetConversion(type, "value %d out of range".formatted(value));
    }

    @Override
    public short getShort() throws SQLException {
        long value = this.getLong();
        if (value > 32767L || value < -32768L) {
            throw this.outOfRangeGetConversion("short", value);
        }
        return (short)value;
    }

    @Override
    public int getInt() throws SQLException {
        long value = this.getLong();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw this.outOfRangeGetConversion("int", value);
        }
        return (int)value;
    }

    @Override
    public long getLong() throws SQLException {
        return this.getDatatypeCoder().decodeLong(this.getFieldData());
    }

    @Override
    public float getFloat() throws SQLException {
        return this.getLong();
    }

    @Override
    public double getDouble() throws SQLException {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.getLong());
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.getLong() == 1L;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getLong());
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setLong(Long.parseLong(string));
        }
        catch (NumberFormatException nfex) {
            throw this.invalidSetConversion(String.class, string, (Throwable)nfex);
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1L : 0L);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw this.invalidSetConversion("float", String.format("value %f out of range", Float.valueOf(value)));
        }
        this.setLong((long)value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw this.invalidSetConversion("double", String.format("value %f out of range", value));
        }
        this.setLong((long)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeLong(value));
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BD_MAX_LONG) > 0 || value.compareTo(BD_MIN_LONG) < 0) {
            throw this.invalidSetConversion(BigDecimal.class, String.format("value %f out of range", value));
        }
        this.setLong(value.longValue());
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BI_MAX_LONG) > 0 || value.compareTo(BI_MIN_LONG) < 0) {
            throw this.invalidSetConversion(BigInteger.class, String.format("value %d out of range", value));
        }
        this.setLong(value.longValueExact());
    }
}

