/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

final class FBFloatField
extends FBField {
    private static final BigDecimal BD_MAX_FLOAT = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal BD_MIN_FLOAT = new BigDecimal(-3.4028234663852886E38);

    @NullMarked
    FBFloatField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDouble();
    }

    @Override
    public byte getByte() throws SQLException {
        float value = this.getFloat();
        if (value > 127.0f || value < -128.0f) {
            throw this.outOfRangeGetConversion("byte", value);
        }
        return (byte)value;
    }

    @NullMarked
    private SQLException outOfRangeGetConversion(String type, float value) {
        return this.invalidGetConversion(type, "value %f out of range".formatted(Float.valueOf(value)));
    }

    @Override
    public short getShort() throws SQLException {
        float value = this.getFloat();
        if (value > 32767.0f || value < -32768.0f) {
            throw this.outOfRangeGetConversion("short", value);
        }
        return (short)value;
    }

    @Override
    public int getInt() throws SQLException {
        float value = this.getFloat();
        if (value > 2.1474836E9f || value < -2.1474836E9f) {
            throw this.outOfRangeGetConversion("int", value);
        }
        return (int)value;
    }

    @Override
    public long getLong() throws SQLException {
        float value = this.getFloat();
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw this.outOfRangeGetConversion("long", value);
        }
        return (long)value;
    }

    @Override
    public float getFloat() throws SQLException {
        return this.getDatatypeCoder().decodeFloat(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        return this.getFloat();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.getFloat() == 1.0f;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getFloat());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setFloat(Float.parseFloat(string));
        }
        catch (NumberFormatException nfex) {
            throw this.invalidSetConversion(String.class, string, (Throwable)nfex);
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setFloat(value ? 1.0f : 0.0f);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeFloat(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value == Double.NEGATIVE_INFINITY) {
            this.setFloat(Float.NEGATIVE_INFINITY);
        } else if (value == Double.POSITIVE_INFINITY) {
            this.setFloat(Float.POSITIVE_INFINITY);
        } else {
            if (value > 3.4028234663852886E38 || value < -3.4028234663852886E38) {
                throw this.invalidSetConversion("double", String.format("value %f out of range", value));
            }
            this.setFloat((float)value);
        }
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BD_MAX_FLOAT) > 0 || value.compareTo(BD_MIN_FLOAT) < 0) {
            throw this.invalidSetConversion(BigDecimal.class, String.format("value %f out of range", value));
        }
        this.setFloat(value.floatValue());
    }
}

