/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum QuoteStrategy {
    DIALECT_1{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return sb.append(objectName);
        }

        @Override
        public String quoteObjectName(String objectName) {
            return objectName;
        }

        @Override
        public StringBuilder appendLiteral(String value, StringBuilder sb) {
            return DIALECT_3.appendQuoted(value, sb);
        }
    }
    ,
    DIALECT_3{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return this.appendWithQuoteEscaped('\"', objectName, sb);
        }

        @Override
        public String quoteObjectName(String objectName) {
            return this.appendQuoted(objectName, new StringBuilder(objectName.length() + 2)).toString();
        }

        @Override
        public StringBuilder appendLiteral(String value, StringBuilder sb) {
            return this.appendWithQuoteEscaped('\'', value, sb);
        }
    }
    ,
    NO_QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return DIALECT_1.appendQuoted(objectName, sb);
        }

        @Override
        public String quoteObjectName(String objectName) {
            return DIALECT_1.quoteObjectName(objectName);
        }

        @Override
        public StringBuilder appendLiteral(String value, StringBuilder sb) {
            return DIALECT_1.appendLiteral(value, sb);
        }
    }
    ,
    QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return DIALECT_3.appendQuoted(objectName, sb);
        }

        @Override
        public String quoteObjectName(String objectName) {
            return DIALECT_3.quoteObjectName(objectName);
        }

        @Override
        public StringBuilder appendLiteral(String value, StringBuilder sb) {
            return DIALECT_3.appendLiteral(value, sb);
        }
    };


    public abstract StringBuilder appendQuoted(String var1, StringBuilder var2);

    public abstract String quoteObjectName(String var1);

    public abstract StringBuilder appendLiteral(String var1, StringBuilder var2);

    public String quoteLiteral(String value) {
        return this.appendLiteral(value, new StringBuilder(value.length() + 2)).toString();
    }

    StringBuilder appendWithQuoteEscaped(char quoteChar, String value, StringBuilder sb) {
        sb.append(quoteChar);
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (currentChar == quoteChar) {
                sb.append(quoteChar);
            }
            sb.append(currentChar);
        }
        return sb.append(quoteChar);
    }

    public static QuoteStrategy forDialect(int dialect) {
        return dialect == 1 ? DIALECT_1 : DIALECT_3;
    }
}

