/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;

public final class IOUtils {
    private static final int TRANSFER_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static byte[] toBytes(InputStream in, int length) throws IOException {
        if (length == -1) {
            return in.readAllBytes();
        }
        return in.readNBytes(length);
    }

    public static String toString(Reader in, int length) throws IOException {
        StringWriter out = new StringWriter();
        if (length == -1) {
            in.transferTo(out);
        } else {
            int counter;
            char[] buff = new char[Math.min(8192, length)];
            for (int toRead = length; toRead > 0 && (counter = in.read(buff, 0, Math.min(toRead, buff.length))) != -1; toRead -= counter) {
                out.write(buff, 0, counter);
            }
        }
        return out.toString();
    }
}

