/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.version12.V12Statement;

public class V13Statement
extends V12Statement {
    public V13Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected RowValue readSqlData() throws SQLException, IOException {
        RowDescriptor rowDescriptor = this.getRowDescriptor();
        RowValue rowValue = rowDescriptor.createDefaultFieldValues();
        BlrCalculator blrCalculator = this.getBlrCalculator();
        XdrInputStream xdrIn = this.getXdrIn();
        int nullBitsLen = (rowDescriptor.getCount() + 7) / 8;
        BitSet nullBits = BitSet.valueOf(xdrIn.readBuffer(nullBitsLen));
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            if (nullBits.get(idx)) {
                rowValue.setFieldData(idx, null);
                continue;
            }
            int len = blrCalculator.calculateIoLength(fieldDescriptor);
            byte[] buffer = this.readColumnData(xdrIn, len);
            rowValue.setFieldData(idx, buffer);
        }
        return rowValue;
    }

    @Override
    protected void writeSqlData(RowDescriptor rowDescriptor, RowValue fieldValues, boolean useActualLength) throws IOException, SQLException {
        this.writeSqlData(this.getXdrOut(), this.getBlrCalculator(), rowDescriptor, fieldValues, useActualLength);
    }

    protected void writeSqlData(XdrOutputStream xdrOut, BlrCalculator blrCalculator, RowDescriptor rowDescriptor, RowValue fieldValues, boolean useActualLength) throws IOException, SQLException {
        BitSet nullBits = new BitSet(fieldValues.getCount());
        for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
            nullBits.set(idx, fieldValues.getFieldData(idx) == null);
        }
        byte[] nullBitsBytes = nullBits.toByteArray();
        xdrOut.write(nullBitsBytes);
        int requiredBytes = (rowDescriptor.getCount() + 7) / 8;
        int remainingBytes = requiredBytes - nullBitsBytes.length;
        if (remainingBytes > 0) {
            xdrOut.write(new byte[remainingBytes]);
        }
        xdrOut.writeAlignment(requiredBytes);
        for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
            if (nullBits.get(idx)) continue;
            byte[] buffer = fieldValues.getFieldData(idx);
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int len = useActualLength ? blrCalculator.calculateIoLength(fieldDescriptor, buffer) : blrCalculator.calculateIoLength(fieldDescriptor);
            this.writeColumnData(xdrOut, len, buffer, fieldDescriptor);
        }
    }
}

