/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.version10.V10WireOperations;

public class V11WireOperations
extends V10WireOperations {
    private final ArrayList<DeferredAction> deferredActions = new ArrayList();

    public V11WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    public final void enqueueDeferredAction(DeferredAction deferredAction) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.deferredActions.add(deferredAction);
            this.afterEnqueueDeferredAction();
        }
    }

    protected void afterEnqueueDeferredAction() throws SQLException {
    }

    protected final int deferredActionCount() {
        return this.deferredActions.size();
    }

    protected final boolean completeDeferredActionsRequiresSync() {
        return this.deferredActions.stream().anyMatch(DeferredAction::requiresSync);
    }

    @Override
    public void completeDeferredActions() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.completeDeferredActionsRequiresSync()) {
                this.getXdrOut().flush();
            }
            this.processDeferredActions();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    @Override
    public final void processDeferredActions() {
        try (LockCloseable ignored = this.withLock();){
            if (this.deferredActions.isEmpty()) {
                return;
            }
            DeferredAction[] actions = this.deferredActions.toArray(new DeferredAction[0]);
            this.deferredActions.clear();
            for (DeferredAction action : actions) {
                try {
                    action.processResponse(this.readResponse(action.getWarningMessageCallback()));
                }
                catch (IOException e) {
                    action.onException(FbExceptionBuilder.ioReadError(e));
                }
                catch (Exception e) {
                    action.onException(e);
                }
            }
            this.afterProcessDeferredActions(actions.length);
        }
    }

    protected void afterProcessDeferredActions(int processedDeferredActions) {
        if (processedDeferredActions > 10) {
            this.deferredActions.trimToSize();
        }
    }
}

