/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AbstractFbWireBlob;
import org.firebirdsql.gds.ng.wire.AbstractFbWireInputBlob;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;

public class V10InputBlob
extends AbstractFbWireInputBlob
implements FbWireBlob,
DatabaseListener {
    private static final int STATE_END_OF_BLOB = 2;

    public V10InputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) throws SQLException {
        super(database, transaction, blobParameterBuffer, blobId);
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobClosed();
            this.clearDeferredException();
            this.sendOpen(AbstractFbWireBlob.BlobOpenOperation.INPUT_BLOB, true);
            this.receiveOpenResponse();
            this.resetEof();
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public byte[] getSegment(int sizeRequested) throws SQLException {
        try {
            GenericResponse response;
            if (sizeRequested <= 0) {
                throw FbExceptionBuilder.forException(337248257).messageParameter(sizeRequested).toSQLException();
            }
            try (LockCloseable ignored = this.withLock();){
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                this.requestGetSegment(sizeRequested);
                response = this.receiveGetSegmentResponse();
                this.throwAndClearDeferredException();
            }
            return V10InputBlob.extractGetSegmentResponse(response.data());
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    private void requestGetSegment(int sizeRequested) throws SQLException {
        try {
            this.sendGetSegment(this.segmentRequestSize(sizeRequested));
            this.getXdrOut().flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private GenericResponse receiveGetSegmentResponse() throws SQLException {
        try {
            GenericResponse response = this.getDatabase().readGenericResponse(null);
            if (response.objectHandle() == 2) {
                this.setEof();
            }
            return response;
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    private static byte[] extractGetSegmentResponse(byte[] responseBuffer) {
        if (responseBuffer.length == 0) {
            return responseBuffer;
        }
        byte[] data = new byte[V10InputBlob.getTotalSegmentSize(responseBuffer)];
        int responsePos = 0;
        int dataPos = 0;
        while (responsePos < responseBuffer.length) {
            int segmentLength = VaxEncoding.iscVaxInteger2(responseBuffer, responsePos);
            System.arraycopy(responseBuffer, responsePos += 2, data, dataPos, segmentLength);
            responsePos += segmentLength;
            dataPos += segmentLength;
        }
        return data;
    }

    private static int getTotalSegmentSize(byte[] segmentBuffer) {
        int count = 0;
        int pos = 0;
        while (pos < segmentBuffer.length) {
            int segmentLength = VaxEncoding.iscVaxInteger2(segmentBuffer, pos);
            pos += 2 + segmentLength;
            count += segmentLength;
        }
        return count;
    }

    private int segmentRequestSize(int size) {
        return Math.min(Math.max(size, size + 2), this.getMaximumSegmentSize());
    }

    protected void sendGetSegment(int len) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(36);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(len);
        xdrOut.writeInt(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int get(byte[] b, int off, int len, int minLen) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            int sizeRequested;
            int count;
            this.validateBufferLength(b, off, len);
            if (len == 0) {
                int n = 0;
                return n;
            }
            if (minLen <= 0 || minLen > len) {
                throw FbExceptionBuilder.forNonTransientException(337248330).messageParameter("minLen", len, minLen).toSQLException();
            }
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            for (count = 0; count < minLen && !this.isEof(); count += this.extractGetSegmentResponse(b, off + count, sizeRequested)) {
                sizeRequested = len - count;
                this.requestGetSegment(sizeRequested);
            }
            this.throwAndClearDeferredException();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    private int extractGetSegmentResponse(byte[] b, int off, int len) throws SQLException {
        try {
            SQLException exception;
            FbWireOperations wireOps = this.getDatabase().getWireOperations();
            V10InputBlob.requireOpResponse(wireOps);
            XdrInputStream xdrIn = this.getXdrIn();
            int objHandle = xdrIn.readInt();
            xdrIn.skipNBytes(8L);
            int bufferLength = xdrIn.readInt();
            int count = 0;
            if (bufferLength > 0) {
                int bufferRemaining = bufferLength;
                while (bufferRemaining > 2) {
                    int segmentLength = VaxEncoding.decodeVaxInteger2WithoutLength(xdrIn);
                    if (segmentLength > (bufferRemaining -= 2)) {
                        throw new IOException("Inconsistent segment buffer: segment length %d, remaining buffer was %d".formatted(segmentLength, bufferRemaining));
                    }
                    if (segmentLength > len - count) {
                        throw new IOException("Returned segment length %d exceeded remaining size %d".formatted(segmentLength, len - count));
                    }
                    xdrIn.readFully(b, off + count, segmentLength);
                    bufferRemaining -= segmentLength;
                    count += segmentLength;
                }
                xdrIn.skipNBytes(bufferRemaining);
                xdrIn.skipPadding(bufferLength);
            }
            if ((exception = wireOps.readStatusVector()) != null && !(exception instanceof SQLWarning)) {
                throw exception;
            }
            if (objHandle == 2) {
                this.setEof();
            }
            return count;
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    private static void requireOpResponse(FbWireOperations wireOps) throws SQLException, IOException {
        int opCode = wireOps.readNextOperation();
        if (opCode != 9) {
            wireOps.readOperationResponse(opCode, null);
            throw new SQLException("Unexpected response to op_get_segment: " + opCode);
        }
    }

    @Override
    public void seek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            this.sendSeek(offset, seekMode);
            this.receiveSeekResponse();
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    private void sendSeek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(61);
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeInt(seekMode.getSeekModeId());
            xdrOut.writeInt(offset);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveSeekResponse() throws SQLException {
        try {
            this.getDatabase().readResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }
}

