/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.AbstractEventHandle;
import org.firebirdsql.gds.ng.wire.AsynchronousChannelListener;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;

public final class WireEventHandle
extends AbstractEventHandle
implements AsynchronousChannelListener {
    private static final AtomicInteger localEventId = new AtomicInteger();
    private final byte[] eventNameBytes;
    private int internalCount;
    private int previousInternalCount;
    private int localId;
    private int eventId;

    public WireEventHandle(String eventName, EventHandler eventHandler, Encoding encoding) {
        super(eventName, eventHandler);
        this.eventNameBytes = encoding.encodeToCharset(eventName);
        if (this.eventNameBytes.length > 256) {
            throw new IllegalArgumentException("Event name as bytes too long");
        }
    }

    public synchronized void calculateCount() {
        this.setEventCount(this.internalCount - this.previousInternalCount);
        this.previousInternalCount = this.internalCount;
    }

    public synchronized void setEventId(int eventId) {
        this.eventId = eventId;
    }

    @Override
    public synchronized int getEventId() {
        return this.eventId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int assignNewLocalId() {
        int newLocalId = localEventId.incrementAndGet();
        WireEventHandle wireEventHandle = this;
        synchronized (wireEventHandle) {
            this.localId = newLocalId;
            return this.localId;
        }
    }

    public synchronized int getLocalId() {
        return this.localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        int currentInternalCount;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(2 + this.eventNameBytes.length + 4);
        byteOut.write(1);
        byteOut.write(this.eventNameBytes.length);
        byteOut.write(this.eventNameBytes);
        WireEventHandle wireEventHandle = this;
        synchronized (wireEventHandle) {
            currentInternalCount = this.internalCount;
        }
        VaxEncoding.encodeVaxIntegerWithoutLength(byteOut, currentInternalCount);
        return byteOut.toByteArray();
    }

    @Override
    public void channelClosing(FbWireAsynchronousChannel channel) {
        channel.removeChannelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReceived(FbWireAsynchronousChannel channel, AsynchronousChannelListener.Event event) {
        if (event.eventId() != this.getLocalId()) {
            return;
        }
        channel.removeChannelListener(this);
        WireEventHandle wireEventHandle = this;
        synchronized (wireEventHandle) {
            this.internalCount = event.eventCount();
        }
        this.onEventOccurred();
    }

    public String toString() {
        return "WireEventHandle:{ name:" + this.getEventName() + ", localId:" + this.localId + ", internalCount:" + this.internalCount + ", previousInternalCount:" + this.previousInternalCount + " }";
    }
}

