/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.jaybird.util.PluginLoader;

public final class ProtocolCollection
implements Iterable<ProtocolDescriptor> {
    private final Map<Integer, ProtocolDescriptor> descriptorMap;
    private static final ProtocolCollection AVAILABLE_PROTOCOLS;
    private static final ProtocolCollection SUPPORTED_PROTOCOLS;

    private ProtocolCollection(Map<Integer, ProtocolDescriptor> protocolDescriptors) {
        this.descriptorMap = Collections.unmodifiableMap(protocolDescriptors);
    }

    @Override
    public Iterator<ProtocolDescriptor> iterator() {
        return this.descriptorMap.values().iterator();
    }

    public ProtocolDescriptor getProtocolDescriptor(int protocolVersion) {
        return this.descriptorMap.get(protocolVersion);
    }

    public int getProtocolCount() {
        return this.descriptorMap.size();
    }

    public List<Integer> getProtocolVersions() {
        ArrayList<Integer> versions = new ArrayList<Integer>(this.getProtocolCount());
        for (ProtocolDescriptor descriptor : this) {
            versions.add(descriptor.getVersion());
        }
        return versions;
    }

    public Stream<ProtocolDescriptor> stream() {
        return this.descriptorMap.values().stream();
    }

    public static ProtocolCollection create(ProtocolDescriptor ... descriptors) {
        return ProtocolCollection.create(Arrays.asList(descriptors));
    }

    private static ProtocolCollection create(Collection<ProtocolDescriptor> descriptors) {
        HashMap<Integer, ProtocolDescriptor> descriptorMap = new HashMap<Integer, ProtocolDescriptor>();
        for (ProtocolDescriptor descriptor : descriptors) {
            ProtocolDescriptor existingDescriptor = (ProtocolDescriptor)descriptorMap.get(descriptor.getVersion());
            if (existingDescriptor != null && descriptor.getWeight() <= existingDescriptor.getWeight()) continue;
            descriptorMap.put(descriptor.getVersion(), descriptor);
        }
        return new ProtocolCollection(descriptorMap);
    }

    public static ProtocolCollection getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public static ProtocolCollection getAvailableProtocols() {
        return AVAILABLE_PROTOCOLS;
    }

    public static ProtocolCollection getProtocols(String enableProtocol) {
        if (enableProtocol == null) {
            return ProtocolCollection.getSupportedProtocols();
        }
        return switch (enableProtocol.trim()) {
            case "" -> ProtocolCollection.getSupportedProtocols();
            case "*" -> ProtocolCollection.getAvailableProtocols();
            default -> ProtocolCollection.getProtocols0(enableProtocol);
        };
    }

    private static ProtocolCollection getProtocols0(String enableProtocol) {
        return ProtocolCollection.create(Stream.concat(SUPPORTED_PROTOCOLS.stream(), Arrays.stream(enableProtocol.split(",")).map(ProtocolCollection::tryParseInt).filter(Objects::nonNull).mapToInt(Integer::intValue).distinct().mapToObj(ProtocolCollection::tryGetProtocolDescriptorUnmaskedAndMasked).filter(Objects::nonNull)).toList());
    }

    private static ProtocolDescriptor tryGetProtocolDescriptorUnmaskedAndMasked(int version) {
        ProtocolDescriptor descriptor = AVAILABLE_PROTOCOLS.getProtocolDescriptor(version);
        if (descriptor == null && (version & 0x8000) != 32768 && version != 10) {
            descriptor = AVAILABLE_PROTOCOLS.getProtocolDescriptor(0x8000 | version);
        }
        return descriptor;
    }

    private static Integer tryParseInt(String s) {
        try {
            return Integer.valueOf(s.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        Collection<ProtocolDescriptor> availableProtocols = PluginLoader.findPlugins(ProtocolDescriptor.class, List.of("org.firebirdsql.gds.ng.wire.version10.Version10Descriptor", "org.firebirdsql.gds.ng.wire.version11.Version11Descriptor", "org.firebirdsql.gds.ng.wire.version12.Version12Descriptor", "org.firebirdsql.gds.ng.wire.version13.Version13Descriptor", "org.firebirdsql.gds.ng.wire.version15.Version15Descriptor", "org.firebirdsql.gds.ng.wire.version16.Version16Descriptor", "org.firebirdsql.gds.ng.wire.version18.Version18Descriptor"));
        AVAILABLE_PROTOCOLS = ProtocolCollection.create(availableProtocols);
        SUPPORTED_PROTOCOLS = ProtocolCollection.create(availableProtocols.stream().filter(p -> 32781 <= p.getVersion() && p.getVersion() <= 32786).toList());
    }
}

