/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.hbase.HBaseColumn;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.hbase.HBaseTable;
import org.apache.metamodel.hbase.HBaseUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;

class HBaseCreateTableBuilder
extends AbstractTableCreationBuilder<HBaseUpdateCallback> {
    private byte[][] splitKeys;

    public HBaseCreateTableBuilder(HBaseUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
        if (!(schema instanceof MutableSchema)) {
            throw new IllegalArgumentException("Not a mutable schema: " + schema);
        }
    }

    public byte[][] getSplitKeys() {
        return this.splitKeys;
    }

    public void setSplitKeys(byte[][] splitKeys) {
        this.splitKeys = splitKeys;
    }

    public Table execute() {
        Set<String> columnFamilies = this.getColumnFamilies();
        if (columnFamilies == null || columnFamilies.isEmpty()) {
            throw new MetaModelException("Can't create a table without column families.");
        }
        MutableTable table = this.getTable();
        if (this.getSplitKeys() != null) {
            ((HBaseDataContext)((HBaseUpdateCallback)this.getUpdateCallback()).getDataContext()).getHBaseClient().createTable(table.getName(), columnFamilies, this.getSplitKeys());
        } else {
            ((HBaseDataContext)((HBaseUpdateCallback)this.getUpdateCallback()).getDataContext()).getHBaseClient().createTable(table.getName(), columnFamilies);
        }
        this.addNewTableToSchema((Table)table);
        return this.getSchema().getTableByName(table.getName());
    }

    private Set<String> getColumnFamilies() {
        return this.getTable().getColumns().stream().map(column -> {
            if (column instanceof HBaseColumn) {
                return ((HBaseColumn)((Object)column)).getColumnFamily();
            }
            String columnName = column.getName();
            String[] columnNameParts = columnName.split(":");
            if (columnNameParts.length > 0 && columnNameParts.length < 3) {
                return columnNameParts[0];
            }
            throw new MetaModelException("Can't determine column family for column \"" + columnName + "\".");
        }).distinct().collect(Collectors.toSet());
    }

    private void addNewTableToSchema(Table table) {
        MutableSchema schema = (MutableSchema)this.getSchema();
        Set<String> columnFamilies = this.getColumnFamilies();
        SimpleTableDef emptyTableDef = new SimpleTableDef(table.getName(), columnFamilies.toArray(new String[columnFamilies.size()]));
        schema.addTable((Table)new HBaseTable((HBaseDataContext)((HBaseUpdateCallback)this.getUpdateCallback()).getDataContext(), emptyTableDef, schema, HBaseConfiguration.DEFAULT_ROW_KEY_TYPE));
    }
}

