/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.MockTcpTransport;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.local.LocalTransport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractSimpleTransportTestCase
extends ESTestCase {
    protected ThreadPool threadPool;
    protected static final Version version0 = Version.CURRENT.minimumCompatibilityVersion();
    private ClusterSettings clusterSettings;
    protected volatile DiscoveryNode nodeA;
    protected volatile MockTransportService serviceA;
    protected static final Version version1 = Version.fromId((int)(Version.CURRENT.id + 1));
    protected volatile DiscoveryNode nodeB;
    protected volatile MockTransportService serviceB;

    protected abstract MockTransportService build(Settings var1, Version var2, ClusterSettings var3, boolean var4);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName());
        this.clusterSettings = new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
        this.serviceA = this.buildService("TS_A", version0, this.clusterSettings);
        this.nodeA = this.serviceA.getLocalNode();
        this.serviceB = this.buildService("TS_B", version1, null);
        this.nodeB = this.serviceB.getLocalNode();
        final CountDownLatch latch = new CountDownLatch(2);
        TransportConnectionListener waitForConnection = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                latch.countDown();
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                Assert.fail((String)("disconnect should not be called " + node));
            }
        };
        this.serviceA.addConnectionListener(waitForConnection);
        this.serviceB.addConnectionListener(waitForConnection);
        int numHandshakes = 1;
        this.serviceA.connectToNode(this.nodeB);
        this.serviceB.connectToNode(this.nodeA);
        this.assertNumHandshakes(numHandshakes, this.serviceA.getOriginalTransport());
        this.assertNumHandshakes(numHandshakes, this.serviceB.getOriginalTransport());
        AbstractSimpleTransportTestCase.assertThat((String)"failed to wait for all nodes to connect", (Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.equalTo((Object)true));
        this.serviceA.removeConnectionListener(waitForConnection);
        this.serviceB.removeConnectionListener(waitForConnection);
    }

    private MockTransportService buildService(String name, Version version, ClusterSettings clusterSettings, Settings settings, boolean acceptRequests, boolean doHandshake) {
        MockTransportService service = this.build(Settings.builder().put(settings).put(Node.NODE_NAME_SETTING.getKey(), name).put(TransportService.TRACE_LOG_INCLUDE_SETTING.getKey(), "").put(TransportService.TRACE_LOG_EXCLUDE_SETTING.getKey(), "NOTHING").build(), version, clusterSettings, doHandshake);
        if (acceptRequests) {
            service.acceptIncomingRequests();
        }
        return service;
    }

    private MockTransportService buildService(String name, Version version, ClusterSettings clusterSettings) {
        return this.buildService(name, version, clusterSettings, Settings.EMPTY, true, true);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.assertNoPendingHandshakes(this.serviceA.getOriginalTransport());
            this.assertNoPendingHandshakes(this.serviceB.getOriginalTransport());
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.serviceA, this.serviceB, () -> {
                try {
                    AbstractSimpleTransportTestCase.terminate(this.threadPool);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.serviceA, this.serviceB, () -> {
            try {
                AbstractSimpleTransportTestCase.terminate(this.threadPool);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }});
    }

    public void assertNumHandshakes(long expected, Transport transport) {
        if (transport instanceof TcpTransport) {
            AbstractSimpleTransportTestCase.assertEquals((long)expected, (long)((TcpTransport)transport).getNumHandshakes());
        }
    }

    public void assertNoPendingHandshakes(Transport transport) {
        if (transport instanceof TcpTransport) {
            AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)((TcpTransport)transport).getNumPendingHandshakes());
        }
    }

    public void testHelloWorld() {
        StringMessageResponse message;
        this.serviceA.registerRequestHandler("sayHello", StringMessageRequest::new, "generic", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            try {
                channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + ((StringMessageRequest)request).message));
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHello", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            message = (StringMessageResponse)((Object)res.get());
            AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
        res = this.serviceB.submitRequest(this.nodeA, "sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withCompress(true).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            message = (StringMessageResponse)((Object)res.get());
            AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
    }

    public void testThreadContext() throws ExecutionException, InterruptedException {
        this.serviceA.registerRequestHandler("ping_pong", StringMessageRequest::new, "generic", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertEquals((Object)"ping_user", (Object)this.threadPool.getThreadContext().getHeader("test.ping.user"));
            AbstractSimpleTransportTestCase.assertNull((Object)this.threadPool.getThreadContext().getTransient("my_private_context"));
            try {
                StringMessageResponse response = new StringMessageResponse("pong");
                this.threadPool.getThreadContext().putHeader("test.pong.user", "pong_user");
                channel.sendResponse((TransportResponse)response);
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        });
        final Object context = new Object();
        final String executor = AbstractSimpleTransportTestCase.randomFrom(ThreadPool.THREAD_POOL_TYPES.keySet().toArray(new String[0]));
        TransportResponseHandler<StringMessageResponse> responseHandler = new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return executor;
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"pong", (Matcher)Matchers.equalTo((Object)response.message));
                Assert.assertEquals((Object)"ping_user", (Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getHeader("test.ping.user"));
                Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getHeader("test.pong.user"));
                Assert.assertSame((Object)context, (Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("my_private_context"));
                AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().putHeader("some.temp.header", "booooom");
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        };
        StringMessageRequest ping = new StringMessageRequest("ping");
        this.threadPool.getThreadContext().putHeader("test.ping.user", "ping_user");
        this.threadPool.getThreadContext().putTransient("my_private_context", context);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "ping_pong", ping, (TransportResponseHandler)responseHandler);
        StringMessageResponse message = (StringMessageResponse)((Object)res.get());
        AbstractSimpleTransportTestCase.assertThat((Object)"pong", (Matcher)Matchers.equalTo((Object)message.message));
        AbstractSimpleTransportTestCase.assertEquals((Object)"ping_user", (Object)this.threadPool.getThreadContext().getHeader("test.ping.user"));
        AbstractSimpleTransportTestCase.assertSame((Object)context, (Object)this.threadPool.getThreadContext().getTransient("my_private_context"));
        AbstractSimpleTransportTestCase.assertNull((String)"this header is only visible in the handler context", (Object)this.threadPool.getThreadContext().getHeader("some.temp.header"));
    }

    public void testLocalNodeConnection() throws InterruptedException {
        AbstractSimpleTransportTestCase.assertTrue((String)"serviceA is not connected to nodeA", (boolean)this.serviceA.nodeConnected(this.nodeA));
        this.serviceA.disconnectFromNode(this.nodeA);
        final AtomicReference exception = new AtomicReference();
        this.serviceA.registerRequestHandler("localNode", StringMessageRequest::new, "generic", (request, channel) -> {
            try {
                channel.sendResponse((TransportResponse)new StringMessageResponse(((StringMessageRequest)request).message));
            }
            catch (IOException e) {
                exception.set(e);
            }
        });
        final AtomicReference responseString = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        this.serviceA.sendRequest(this.nodeA, "localNode", new StringMessageRequest("test"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public void handleResponse(StringMessageResponse response) {
                responseString.set(response.message);
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                exception.set(exp);
                responseLatch.countDown();
            }

            public String executor() {
                return "generic";
            }
        });
        responseLatch.await();
        AbstractSimpleTransportTestCase.assertNull(exception.get());
        AbstractSimpleTransportTestCase.assertThat(responseString.get(), (Matcher)Matchers.equalTo((Object)"test"));
    }

    public void testAdapterSendReceiveCallbacks() throws Exception {
        TransportRequestHandler requestHandler = (request, channel) -> {
            try {
                if (AbstractSimpleTransportTestCase.randomBoolean()) {
                    channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
                } else {
                    channel.sendResponse((Exception)((Object)new ElasticsearchException("simulated", new Object[0])));
                }
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        };
        String ACTION = "action";
        this.serviceA.registerRequestHandler("action", TransportRequest.Empty::new, "generic", requestHandler);
        this.serviceB.registerRequestHandler("action", TransportRequest.Empty::new, "generic", requestHandler);
        class CountingTracer
        extends MockTransportService.Tracer {
            AtomicInteger requestsReceived = new AtomicInteger();
            AtomicInteger requestsSent = new AtomicInteger();
            AtomicInteger responseReceived = new AtomicInteger();
            AtomicInteger responseSent = new AtomicInteger();

            CountingTracer() {
            }

            @Override
            public void receivedRequest(long requestId, String action) {
                if (action.equals("action")) {
                    this.requestsReceived.incrementAndGet();
                }
            }

            @Override
            public void responseSent(long requestId, String action) {
                if (action.equals("action")) {
                    this.responseSent.incrementAndGet();
                }
            }

            @Override
            public void responseSent(long requestId, String action, Throwable t) {
                if (action.equals("action")) {
                    this.responseSent.incrementAndGet();
                }
            }

            @Override
            public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
                if (action.equals("action")) {
                    this.responseReceived.incrementAndGet();
                }
            }

            @Override
            public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
                if (action.equals("action")) {
                    this.requestsSent.incrementAndGet();
                }
            }
        }
        CountingTracer tracerA = new CountingTracer();
        CountingTracer tracerB = new CountingTracer();
        this.serviceA.addTracer(tracerA);
        this.serviceB.addTracer(tracerB);
        try {
            this.serviceA.submitRequest(this.nodeB, "action", (TransportRequest)TransportRequest.Empty.INSTANCE, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).get();
        }
        catch (ExecutionException e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ElasticsearchException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)ExceptionsHelper.unwrapCause((Throwable)e.getCause()).getMessage(), (Matcher)Matchers.equalTo((Object)"simulated"));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsSent.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
        }));
        try {
            this.serviceA.submitRequest(this.nodeA, "action", (TransportRequest)TransportRequest.Empty.INSTANCE, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).get();
        }
        catch (ExecutionException e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ElasticsearchException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)ExceptionsHelper.unwrapCause((Throwable)e.getCause()).getMessage(), (Matcher)Matchers.equalTo((Object)"simulated"));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsSent.get(), (Matcher)Matchers.equalTo((Object)2));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseReceived.get(), (Matcher)Matchers.equalTo((Object)2));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
        }));
    }

    public void testVoidMessageCompressed() {
        this.serviceA.registerRequestHandler("sayHello", TransportRequest.Empty::new, "generic", (request, channel) -> {
            try {
                TransportResponseOptions responseOptions = TransportResponseOptions.builder().withCompress(true).build();
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE, responseOptions);
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHello", (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.builder().withCompress(true).build(), (TransportResponseHandler)new TransportResponseHandler<TransportResponse.Empty>(){

            public TransportResponse.Empty newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(TransportResponse.Empty response) {
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            TransportResponse.Empty message = (TransportResponse.Empty)res.get();
            AbstractSimpleTransportTestCase.assertThat((Object)message, (Matcher)Matchers.notNullValue());
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
    }

    public void testHelloWorldCompressed() {
        this.serviceA.registerRequestHandler("sayHello", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel) {
                Assert.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)request.message));
                try {
                    TransportResponseOptions responseOptions = TransportResponseOptions.builder().withCompress(true).build();
                    channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + request.message), responseOptions);
                }
                catch (IOException e) {
                    AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withCompress(true).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            StringMessageResponse message = (StringMessageResponse)((Object)res.get());
            AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
    }

    public void testErrorMessage() {
        this.serviceA.registerRequestHandler("sayHelloException", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel) throws Exception {
                Assert.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)request.message));
                throw new RuntimeException("bad message !!!");
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHelloException", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)"runtime_exception: bad message !!!", (Matcher)Matchers.equalTo((Object)exp.getCause().getMessage()));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"runtime_exception: bad message !!!"));
        }
    }

    public void testDisconnectListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        TransportConnectionListener disconnectListener = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                Assert.fail((String)("node connected should not be called, all connection have been done previously, node: " + node));
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                latch.countDown();
            }
        };
        this.serviceA.addConnectionListener(disconnectListener);
        this.serviceB.close();
        AbstractSimpleTransportTestCase.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.equalTo((Object)true));
    }

    public void testConcurrentSendRespondAndDisconnect() throws BrokenBarrierException, InterruptedException {
        int sender;
        final Set sendingErrors = ConcurrentCollections.newConcurrentSet();
        Set responseErrors = ConcurrentCollections.newConcurrentSet();
        this.serviceA.registerRequestHandler("test", TestRequest::new, AbstractSimpleTransportTestCase.randomBoolean() ? "same" : "generic", (request, channel) -> {
            try {
                channel.sendResponse((TransportResponse)new TestResponse());
            }
            catch (Exception e) {
                this.logger.info("caught exception while responding", (Throwable)e);
                responseErrors.add(e);
            }
        });
        TransportRequestHandler ignoringRequestHandler = (request, channel) -> {
            try {
                channel.sendResponse((TransportResponse)new TestResponse());
            }
            catch (Exception e) {
                this.logger.trace("caught exception while responding from node B", (Throwable)e);
            }
        };
        this.serviceB.registerRequestHandler("test", TestRequest::new, "same", ignoringRequestHandler);
        int halfSenders = AbstractSimpleTransportTestCase.scaledRandomIntBetween(3, 10);
        final CyclicBarrier go = new CyclicBarrier(halfSenders * 2 + 1);
        final CountDownLatch done = new CountDownLatch(halfSenders * 2);
        int i = 0;
        while (i < halfSenders) {
            sender = i++;
            this.threadPool.executor("generic").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    AbstractSimpleTransportTestCase.this.logger.trace("caught exception while sending from B", (Throwable)e);
                }

                protected void doRun() throws Exception {
                    go.await();
                    for (int iter = 0; iter < 10; ++iter) {
                        PlainActionFuture listener = new PlainActionFuture();
                        String info = sender + "_B_" + iter;
                        AbstractSimpleTransportTestCase.this.serviceB.sendRequest(AbstractSimpleTransportTestCase.this.nodeA, "test", new TestRequest(info), (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)listener, TestResponse::new));
                        try {
                            listener.actionGet();
                            continue;
                        }
                        catch (Exception e) {
                            AbstractSimpleTransportTestCase.this.logger.trace(() -> new ParameterizedMessage("caught exception while sending to node {}", (Object)AbstractSimpleTransportTestCase.this.nodeA), (Throwable)e);
                        }
                    }
                }

                public void onAfter() {
                    done.countDown();
                }
            });
        }
        i = 0;
        while (i < halfSenders) {
            sender = i++;
            this.threadPool.executor("generic").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    AbstractSimpleTransportTestCase.this.logger.error("unexpected error", (Throwable)e);
                    sendingErrors.add(e);
                }

                protected void doRun() throws Exception {
                    go.await();
                    for (int iter = 0; iter < 10; ++iter) {
                        PlainActionFuture listener = new PlainActionFuture();
                        String info = sender + "_" + iter;
                        DiscoveryNode node = AbstractSimpleTransportTestCase.this.nodeB;
                        try {
                            AbstractSimpleTransportTestCase.this.serviceA.sendRequest(node, "test", new TestRequest(info), (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)listener, TestResponse::new));
                            try {
                                listener.actionGet();
                            }
                            catch (ConnectTransportException connectTransportException) {
                            }
                            catch (Exception e) {
                                AbstractSimpleTransportTestCase.this.logger.error(() -> new ParameterizedMessage("caught exception while sending to node {}", (Object)node), (Throwable)e);
                                sendingErrors.add(e);
                            }
                            continue;
                        }
                        catch (NodeNotConnectedException nodeNotConnectedException) {
                            // empty catch block
                        }
                    }
                }

                public void onAfter() {
                    done.countDown();
                }
            });
        }
        go.await();
        for (i = 0; i <= 10; ++i) {
            if (i % 3 == 0) {
                this.serviceB.close();
                MockTransportService newService = this.buildService("TS_B_" + i, version1, null);
                newService.registerRequestHandler("test", TestRequest::new, "same", ignoringRequestHandler);
                this.serviceB = newService;
                this.nodeB = newService.getLocalDiscoNode();
                this.serviceB.connectToNode(this.nodeA);
                this.serviceA.connectToNode(this.nodeB);
                continue;
            }
            if (this.serviceA.nodeConnected(this.nodeB)) {
                this.serviceA.disconnectFromNode(this.nodeB);
                continue;
            }
            this.serviceA.connectToNode(this.nodeB);
        }
        done.await();
        AbstractSimpleTransportTestCase.assertThat((String)"found non connection errors while sending", (Object)sendingErrors, (Matcher)Matchers.empty());
        AbstractSimpleTransportTestCase.assertThat((String)"found non connection errors while responding", (Object)responseErrors, (Matcher)Matchers.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotifyOnShutdown() throws Exception {
        CountDownLatch latch2 = new CountDownLatch(1);
        try {
            this.serviceA.registerRequestHandler("foobar", StringMessageRequest::new, "generic", (request, channel) -> {
                try {
                    latch2.await();
                    this.logger.info("Stop ServiceB now");
                    this.serviceB.stop();
                }
                catch (Exception e) {
                    AbstractSimpleTransportTestCase.fail((String)e.getMessage());
                }
            });
            TransportFuture foobar = this.serviceB.submitRequest(this.nodeA, "foobar", new StringMessageRequest(""), TransportRequestOptions.EMPTY, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME);
            latch2.countDown();
            try {
                foobar.txGet();
                AbstractSimpleTransportTestCase.fail((String)"TransportException expected");
            }
            catch (TransportException transportException) {
                // empty catch block
            }
        }
        finally {
            this.serviceB.close();
            this.serviceA.disconnectFromNode(this.nodeB);
        }
    }

    public void testTimeoutSendExceptionWithNeverSendingBackResponse() throws Exception {
        this.serviceA.registerRequestHandler("sayHelloTimeoutNoResponse", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel) {
                Assert.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)request.message));
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHelloTimeoutNoResponse", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            StringMessageResponse message = (StringMessageResponse)((Object)res.txGet());
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
    }

    public void testTimeoutSendExceptionWithDelayedResponse() throws Exception {
        final CountDownLatch waitForever = new CountDownLatch(1);
        final CountDownLatch doneWaitingForever = new CountDownLatch(1);
        final Semaphore inFlight = new Semaphore(Integer.MAX_VALUE);
        this.serviceA.registerRequestHandler("sayHelloTimeoutDelayedResponse", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(StringMessageRequest request, TransportChannel channel) throws InterruptedException {
                String message = request.message;
                inFlight.acquireUninterruptibly();
                try {
                    if ("forever".equals(message)) {
                        waitForever.await();
                    } else {
                        TimeValue sleep = TimeValue.parseTimeValue((String)message, null, (String)"sleep");
                        Thread.sleep(sleep.millis());
                    }
                    try {
                        channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + request.message));
                    }
                    catch (IOException e) {
                        AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)e);
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    inFlight.release();
                    if ("forever".equals(message)) {
                        doneWaitingForever.countDown();
                    }
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHelloTimeoutDelayedResponse", new StringMessageRequest("forever"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                latch.countDown();
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                latch.countDown();
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
        latch.await();
        ArrayList<Runnable> assertions = new ArrayList<Runnable>();
        int i = 0;
        while (i < 10) {
            final int counter = i++;
            TransportFuture result = this.serviceB.submitRequest(this.nodeA, "sayHelloTimeoutDelayedResponse", new StringMessageRequest(counter + "ms"), TransportRequestOptions.builder().withTimeout(3000L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

                public StringMessageResponse newInstance() {
                    return new StringMessageResponse();
                }

                public String executor() {
                    return "generic";
                }

                public void handleResponse(StringMessageResponse response) {
                    Assert.assertThat((Object)("hello " + counter + "ms"), (Matcher)Matchers.equalTo((Object)response.message));
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                    Assert.fail((String)("got exception instead of a response for " + counter + ": " + exp.getDetailedMessage()));
                }
            });
            assertions.add(() -> {
                StringMessageResponse message = (StringMessageResponse)((Object)((Object)result.txGet()));
                AbstractSimpleTransportTestCase.assertThat((Object)message.message, (Matcher)Matchers.equalTo((Object)("hello " + counter + "ms")));
            });
        }
        for (Runnable runnable : assertions) {
            runnable.run();
        }
        waitForever.countDown();
        doneWaitingForever.await();
        AbstractSimpleTransportTestCase.assertTrue((boolean)inFlight.tryAcquire(Integer.MAX_VALUE, 10L, TimeUnit.SECONDS));
    }

    public void testTracerLog() throws InterruptedException {
        String excludeSettings;
        String includeSettings;
        TransportRequestHandler handler = (request, channel) -> channel.sendResponse((TransportResponse)new StringMessageResponse(""));
        TransportRequestHandler<StringMessageRequest> handlerWithError = new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel) throws Exception {
                if (request.timeout() > 0L) {
                    Thread.sleep(request.timeout);
                }
                channel.sendResponse((Exception)new RuntimeException(""));
            }
        };
        final Semaphore requestCompleted = new Semaphore(0);
        TransportResponseHandler<StringMessageResponse> noopResponseHandler = new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public void handleResponse(StringMessageResponse response) {
                requestCompleted.release();
            }

            public void handleException(TransportException exp) {
                requestCompleted.release();
            }

            public String executor() {
                return "same";
            }
        };
        this.serviceA.registerRequestHandler("test", StringMessageRequest::new, "same", handler);
        this.serviceA.registerRequestHandler("testError", StringMessageRequest::new, "same", (TransportRequestHandler)handlerWithError);
        this.serviceB.registerRequestHandler("test", StringMessageRequest::new, "same", handler);
        this.serviceB.registerRequestHandler("testError", StringMessageRequest::new, "same", (TransportRequestHandler)handlerWithError);
        Tracer tracer = new Tracer(new HashSet<String>(Arrays.asList("test", "testError")));
        this.serviceA.addTracer(tracer);
        this.serviceB.addTracer(tracer);
        tracer.reset(4);
        boolean timeout = AbstractSimpleTransportTestCase.randomBoolean();
        TransportRequestOptions options = timeout ? TransportRequestOptions.builder().withTimeout(1L).build() : TransportRequestOptions.EMPTY;
        this.serviceA.sendRequest(this.nodeB, "test", new StringMessageRequest("", 10L), options, (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)false));
        tracer.reset(4);
        this.serviceA.sendRequest(this.nodeB, "testError", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)true));
        if (AbstractSimpleTransportTestCase.randomBoolean()) {
            includeSettings = AbstractSimpleTransportTestCase.randomBoolean() ? "*" : "";
            excludeSettings = "*Error";
        } else {
            includeSettings = "test";
            excludeSettings = "DOESN'T_MATCH";
        }
        this.clusterSettings.applySettings(Settings.builder().put(TransportService.TRACE_LOG_INCLUDE_SETTING.getKey(), includeSettings).put(TransportService.TRACE_LOG_EXCLUDE_SETTING.getKey(), excludeSettings).build());
        tracer.reset(4);
        this.serviceA.sendRequest(this.nodeB, "test", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)false));
        tracer.reset(2);
        this.serviceA.sendRequest(this.nodeB, "testError", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"saw request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)true));
    }

    public void testVersionFrom0to1() throws Exception {
        this.serviceB.registerRequestHandler("/version", Version1Request::new, "same", (TransportRequestHandler)new TransportRequestHandler<Version1Request>(){

            public void messageReceived(Version1Request request, TransportChannel channel) throws Exception {
                Assert.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)request.value2, (Matcher)Matchers.equalTo((Object)0));
                Version1Response response = new Version1Response();
                response.value1 = 1;
                response.value2 = 2;
                channel.sendResponse((TransportResponse)response);
                Assert.assertEquals((Object)version0, (Object)channel.getVersion());
            }
        });
        Version0Request version0Request = new Version0Request();
        version0Request.value1 = 1;
        Version0Response version0Response = (Version0Response)((Object)this.serviceA.submitRequest(this.nodeB, "/version", version0Request, (TransportResponseHandler)new TransportResponseHandler<Version0Response>(){

            public Version0Response newInstance() {
                return new Version0Response();
            }

            public void handleResponse(Version0Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version0Response.value1, (Matcher)Matchers.equalTo((Object)1));
    }

    public void testVersionFrom1to0() throws Exception {
        this.serviceA.registerRequestHandler("/version", Version0Request::new, "same", (TransportRequestHandler)new TransportRequestHandler<Version0Request>(){

            public void messageReceived(Version0Request request, TransportChannel channel) throws Exception {
                Assert.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
                Version0Response response = new Version0Response();
                response.value1 = 1;
                channel.sendResponse((TransportResponse)response);
                Assert.assertEquals((Object)version0, (Object)channel.getVersion());
            }
        });
        Version1Request version1Request = new Version1Request();
        version1Request.value1 = 1;
        version1Request.value2 = 2;
        Version1Response version1Response = (Version1Response)((Object)this.serviceB.submitRequest(this.nodeA, "/version", version1Request, (TransportResponseHandler)new TransportResponseHandler<Version1Response>(){

            public Version1Response newInstance() {
                return new Version1Response();
            }

            public void handleResponse(Version1Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)response.value2, (Matcher)Matchers.equalTo((Object)0));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value1, (Matcher)Matchers.equalTo((Object)1));
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value2, (Matcher)Matchers.equalTo((Object)0));
    }

    public void testVersionFrom1to1() throws Exception {
        this.serviceB.registerRequestHandler("/version", Version1Request::new, "same", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)request.value2, (Matcher)Matchers.equalTo((Object)2));
            Version1Response response = new Version1Response();
            response.value1 = 1;
            response.value2 = 2;
            channel.sendResponse((TransportResponse)response);
            AbstractSimpleTransportTestCase.assertEquals((Object)version1, (Object)channel.getVersion());
        });
        Version1Request version1Request = new Version1Request();
        version1Request.value1 = 1;
        version1Request.value2 = 2;
        Version1Response version1Response = (Version1Response)((Object)this.serviceB.submitRequest(this.nodeB, "/version", version1Request, (TransportResponseHandler)new TransportResponseHandler<Version1Response>(){

            public Version1Response newInstance() {
                return new Version1Response();
            }

            public void handleResponse(Version1Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)response.value2, (Matcher)Matchers.equalTo((Object)2));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value1, (Matcher)Matchers.equalTo((Object)1));
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value2, (Matcher)Matchers.equalTo((Object)2));
    }

    public void testVersionFrom0to0() throws Exception {
        this.serviceA.registerRequestHandler("/version", Version0Request::new, "same", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
            Version0Response response = new Version0Response();
            response.value1 = 1;
            channel.sendResponse((TransportResponse)response);
            AbstractSimpleTransportTestCase.assertEquals((Object)version0, (Object)channel.getVersion());
        });
        Version0Request version0Request = new Version0Request();
        version0Request.value1 = 1;
        Version0Response version0Response = (Version0Response)((Object)this.serviceA.submitRequest(this.nodeA, "/version", version0Request, (TransportResponseHandler)new TransportResponseHandler<Version0Response>(){

            public Version0Response newInstance() {
                return new Version0Response();
            }

            public void handleResponse(Version0Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version0Response.value1, (Matcher)Matchers.equalTo((Object)1));
    }

    public void testMockFailToSendNoConnectRule() throws Exception {
        this.serviceA.registerRequestHandler("sayHello", StringMessageRequest::new, "generic", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            throw new RuntimeException("bad message !!!");
        });
        this.serviceB.addFailToSendNoConnectRule(this.serviceA);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHello", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exp);
                Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConnectTransportException.class));
                Assert.assertThat((Object)((ConnectTransportException)cause).node(), (Matcher)Matchers.equalTo((Object)AbstractSimpleTransportTestCase.this.nodeA));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            AbstractSimpleTransportTestCase.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConnectTransportException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)((ConnectTransportException)cause).node(), (Matcher)Matchers.equalTo((Object)this.nodeA));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSimpleTransportTestCase.assertFalse((boolean)this.serviceB.nodeConnected(this.nodeA))));
        try {
            this.serviceB.connectToNode(this.nodeA);
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (ConnectTransportException connectTransportException) {
            // empty catch block
        }
        AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceB.openConnection(this.nodeA, MockTcpTransport.LIGHT_PROFILE));
    }

    public void testMockUnresponsiveRule() throws IOException {
        this.serviceA.registerRequestHandler("sayHello", StringMessageRequest::new, "generic", (request, channel) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            throw new RuntimeException("bad message !!!");
        });
        this.serviceB.addUnresponsiveRule(this.serviceA);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse newInstance() {
                return new StringMessageResponse();
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
        try {
            this.serviceB.disconnectFromNode(this.nodeA);
            this.serviceB.connectToNode(this.nodeA);
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (ConnectTransportException connectTransportException) {
            // empty catch block
        }
        AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceB.openConnection(this.nodeA, MockTcpTransport.LIGHT_PROFILE));
    }

    public void testHostOnMessages() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicReference addressA = new AtomicReference();
        final AtomicReference addressB = new AtomicReference();
        this.serviceB.registerRequestHandler("action1", TestRequest::new, "same", (TransportRequestHandler)new TransportRequestHandler<TestRequest>(){

            public void messageReceived(TestRequest request, TransportChannel channel) throws Exception {
                addressA.set(request.remoteAddress());
                channel.sendResponse((TransportResponse)new TestResponse());
                latch.countDown();
            }
        });
        this.serviceA.sendRequest(this.nodeB, "action1", new TestRequest(), (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

            public TestResponse newInstance() {
                return new TestResponse();
            }

            public void handleResponse(TestResponse response) {
                addressB.set(response.remoteAddress());
                latch.countDown();
            }

            public void handleException(TransportException exp) {
                latch.countDown();
            }

            public String executor() {
                return "same";
            }
        });
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            AbstractSimpleTransportTestCase.fail((String)"message round trip did not complete within a sensible time frame");
        }
        AbstractSimpleTransportTestCase.assertTrue((boolean)this.nodeA.getAddress().sameHost((TransportAddress)addressA.get()));
        AbstractSimpleTransportTestCase.assertTrue((boolean)this.nodeB.getAddress().sameHost((TransportAddress)addressB.get()));
    }

    public void testBlockingIncomingRequests() throws Exception {
        try (MockTransportService service = this.buildService("TS_TEST", version0, null, Settings.EMPTY, false, false);){
            AtomicBoolean requestProcessed = new AtomicBoolean(false);
            service.registerRequestHandler("action", TestRequest::new, "same", (request, channel) -> {
                requestProcessed.set(true);
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            });
            DiscoveryNode node = service.getLocalNode();
            this.serviceA.close();
            this.serviceA = this.buildService("TS_A", version0, null, Settings.EMPTY, true, false);
            try (Transport.Connection connection = this.serviceA.openConnection(node, null);){
                final CountDownLatch latch = new CountDownLatch(1);
                this.serviceA.sendRequest(connection, "action", new TestRequest(), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

                    public TestResponse newInstance() {
                        return new TestResponse();
                    }

                    public void handleResponse(TestResponse response) {
                        latch.countDown();
                    }

                    public void handleException(TransportException exp) {
                        latch.countDown();
                    }

                    public String executor() {
                        return "same";
                    }
                });
                AbstractSimpleTransportTestCase.assertFalse((boolean)requestProcessed.get());
                service.acceptIncomingRequests();
                AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSimpleTransportTestCase.assertTrue((boolean)requestProcessed.get())));
                latch.await();
            }
        }
    }

    public void testSendRandomRequests() throws InterruptedException {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").put(TransportService.TRACE_LOG_INCLUDE_SETTING.getKey(), "").put(TransportService.TRACE_LOG_EXCLUDE_SETTING.getKey(), "NOTHING").build(), version0, null, true);
        final DiscoveryNode nodeC = serviceC.getLocalNode();
        serviceC.acceptIncomingRequests();
        final CountDownLatch latch = new CountDownLatch(4);
        TransportConnectionListener waitForConnection = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                latch.countDown();
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                Assert.fail((String)("disconnect should not be called " + node));
            }
        };
        this.serviceA.addConnectionListener(waitForConnection);
        this.serviceB.addConnectionListener(waitForConnection);
        serviceC.addConnectionListener(waitForConnection);
        serviceC.connectToNode(this.nodeA);
        serviceC.connectToNode(this.nodeB);
        this.serviceA.connectToNode(nodeC);
        this.serviceB.connectToNode(nodeC);
        latch.await();
        this.serviceA.removeConnectionListener(waitForConnection);
        this.serviceB.removeConnectionListener(waitForConnection);
        serviceC.removeConnectionListener(waitForConnection);
        final HashMap<MockTransportService, DiscoveryNode> toNodeMap = new HashMap<MockTransportService, DiscoveryNode>();
        toNodeMap.put(this.serviceA, this.nodeA);
        toNodeMap.put(this.serviceB, this.nodeB);
        toNodeMap.put(serviceC, nodeC);
        final AtomicBoolean fail = new AtomicBoolean(false);
        class TestRequestHandler
        implements TransportRequestHandler<TestRequest> {
            private final TransportService service;

            TestRequestHandler(TransportService service) {
                this.service = service;
            }

            public void messageReceived(final TestRequest request, final TransportChannel channel) throws Exception {
                if (ESTestCase.randomBoolean()) {
                    Thread.sleep(ESTestCase.randomIntBetween(10, 50));
                }
                if (fail.get()) {
                    throw new IOException("forced failure");
                }
                if (ESTestCase.randomBoolean() && request.resendCount++ < 20) {
                    DiscoveryNode node = ESTestCase.randomFrom(AbstractSimpleTransportTestCase.this.nodeA, AbstractSimpleTransportTestCase.this.nodeB, nodeC);
                    AbstractSimpleTransportTestCase.this.logger.debug("send secondary request from {} to {} - {}", toNodeMap.get(this.service), (Object)node, (Object)request.info);
                    this.service.sendRequest(node, "action1", (TransportRequest)new TestRequest("secondary " + request.info), TransportRequestOptions.builder().withCompress(ESTestCase.randomBoolean()).build(), (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

                        public TestResponse newInstance() {
                            return new TestResponse();
                        }

                        public void handleResponse(TestResponse response) {
                            try {
                                if (ESTestCase.randomBoolean()) {
                                    Thread.sleep(ESTestCase.randomIntBetween(10, 50));
                                }
                                AbstractSimpleTransportTestCase.this.logger.debug("send secondary response {}", (Object)response.info);
                                channel.sendResponse((TransportResponse)response);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void handleException(TransportException exp) {
                            try {
                                AbstractSimpleTransportTestCase.this.logger.debug("send secondary exception response for request {}", (Object)request.info);
                                channel.sendResponse((Exception)exp);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public String executor() {
                            return ESTestCase.randomBoolean() ? "same" : "generic";
                        }
                    });
                } else {
                    AbstractSimpleTransportTestCase.this.logger.debug("send response for {}", (Object)request.info);
                    channel.sendResponse((TransportResponse)new TestResponse("Response for: " + request.info));
                }
            }
        }
        this.serviceB.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(this.serviceB));
        serviceC.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(serviceC));
        this.serviceA.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(this.serviceA));
        int iters = AbstractSimpleTransportTestCase.randomIntBetween(30, 60);
        final CountDownLatch allRequestsDone = new CountDownLatch(iters);
        for (int i = 0; i < iters; ++i) {
            TransportService service = AbstractSimpleTransportTestCase.randomFrom(new TransportService[]{serviceC, this.serviceB, this.serviceA});
            DiscoveryNode node = AbstractSimpleTransportTestCase.randomFrom(nodeC, this.nodeB, this.nodeA);
            this.logger.debug("send from {} to {}", toNodeMap.get(service), (Object)node);
            class TestResponseHandler
            implements TransportResponseHandler<TestResponse> {
                private final int id;

                TestResponseHandler(int id) {
                    this.id = id;
                }

                public TestResponse newInstance() {
                    return new TestResponse();
                }

                public void handleResponse(TestResponse response) {
                    AbstractSimpleTransportTestCase.this.logger.debug("---> received response: {}", (Object)response.info);
                    allRequestsDone.countDown();
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.debug(() -> new ParameterizedMessage("---> received exception for id {}", (Object)this.id), (Throwable)exp);
                    allRequestsDone.countDown();
                    Throwable unwrap = ExceptionsHelper.unwrap((Throwable)exp, (Class[])new Class[]{IOException.class});
                    Assert.assertNotNull((Object)unwrap);
                    Assert.assertEquals(IOException.class, unwrap.getClass());
                    Assert.assertEquals((Object)"forced failure", (Object)unwrap.getMessage());
                }

                public String executor() {
                    return ESTestCase.randomBoolean() ? "same" : "generic";
                }
            }
            service.sendRequest(node, "action1", (TransportRequest)new TestRequest("REQ[" + i + "]"), TransportRequestOptions.builder().withCompress(AbstractSimpleTransportTestCase.randomBoolean()).build(), (TransportResponseHandler)new TestResponseHandler(i));
        }
        this.logger.debug("waiting for response");
        fail.set(AbstractSimpleTransportTestCase.randomBoolean());
        boolean await = allRequestsDone.await(5L, TimeUnit.SECONDS);
        if (!await) {
            this.logger.debug("now failing forcefully");
            fail.set(true);
            AbstractSimpleTransportTestCase.assertTrue((boolean)allRequestsDone.await(5L, TimeUnit.SECONDS));
        }
        this.logger.debug("DONE");
        serviceC.close();
        this.serviceB.disconnectFromNode(nodeC);
        this.serviceA.disconnectFromNode(nodeC);
    }

    public void testRegisterHandlerTwice() {
        this.serviceB.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message) -> {
            throw new AssertionError((Object)"boom");
        });
        AbstractSimpleTransportTestCase.expectThrows(IllegalArgumentException.class, () -> this.serviceB.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message) -> {
            throw new AssertionError((Object)"boom");
        }));
        this.serviceA.registerRequestHandler("action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message) -> {
            throw new AssertionError((Object)"boom");
        });
    }

    public void testTimeoutPerConnection() throws IOException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"Works only on BSD network stacks and apparently windows", (Constants.MAC_OS_X || Constants.FREE_BSD || Constants.WINDOWS ? 1 : 0) != 0);
        AbstractSimpleTransportTestCase.assumeFalse((String)"This test does not work for the local transport as it uses different address types", (this.serviceA.original() instanceof LocalTransport || this.serviceB.original() instanceof LocalTransport ? 1 : 0) != 0);
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(InetAddress.getLocalHost(), 0), 1);
            socket.setReuseAddress(true);
            DiscoveryNode first = new DiscoveryNode("TEST", (TransportAddress)new InetSocketTransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            DiscoveryNode second = new DiscoveryNode("TEST", (TransportAddress)new InetSocketTransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            try (MockTransportService service = this.buildService("TS_TPC", Version.CURRENT, null, Settings.EMPTY, true, false);){
                IOUtils.close((Closeable[])new Closeable[]{service.openConnection(first, builder.build())});
                builder.setConnectTimeout(TimeValue.timeValueMillis((long)1L));
                ConnectionProfile profile = builder.build();
                long startTime = System.nanoTime();
                ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> service.openConnection(second, profile));
                long now = System.nanoTime();
                long timeTaken = TimeValue.nsecToMSec((long)(now - startTime));
                AbstractSimpleTransportTestCase.assertTrue((String)("test didn't timeout quick enough, time taken: [" + timeTaken + "]"), (timeTaken < TimeValue.timeValueSeconds((long)5L).millis() ? 1 : 0) != 0);
                AbstractSimpleTransportTestCase.assertEquals((Object)ex.getMessage(), (Object)("[][" + second.getAddress() + "] connect_timeout[1ms]"));
            }
        }
    }

    public void testHandshakeWithIncompatVersion() {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(Collections.emptyList());
        try (MockTcpTransport transport = new MockTcpTransport(Settings.EMPTY, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, (CircuitBreakerService)new NoneCircuitBreakerService(), namedWriteableRegistry, new NetworkService(Settings.EMPTY, Collections.emptyList()), Version.fromString((String)"2.0.0"));){
            transport.transportServiceAdapter((TransportServiceAdapter)new TransportService.Adapter((TransportService)this.serviceA));
            transport.start();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", transport.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.openConnection(node, builder.build()));
        }
    }

    public void testHandshakeUpdatesVersion() throws IOException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(Collections.emptyList());
        Version version = VersionUtils.randomVersionBetween(AbstractSimpleTransportTestCase.random(), Version.CURRENT.minimumCompatibilityVersion(), Version.CURRENT);
        try (MockTcpTransport transport = new MockTcpTransport(Settings.EMPTY, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, (CircuitBreakerService)new NoneCircuitBreakerService(), namedWriteableRegistry, new NetworkService(Settings.EMPTY, Collections.emptyList()), version);){
            transport.transportServiceAdapter((TransportServiceAdapter)new TransportService.Adapter((TransportService)this.serviceA));
            transport.start();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", transport.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), Version.fromString((String)"2.0.0"));
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            try (Transport.Connection connection = this.serviceA.openConnection(node, builder.build());){
                AbstractSimpleTransportTestCase.assertEquals((Object)connection.getVersion(), (Object)version);
            }
        }
    }

    public void testTcpHandshake() throws IOException, InterruptedException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        TcpTransport originalTransport = (TcpTransport)this.serviceA.getOriginalTransport();
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(Collections.emptyList());
        try (MockTcpTransport transport = new MockTcpTransport(Settings.EMPTY, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, (CircuitBreakerService)new NoneCircuitBreakerService(), namedWriteableRegistry, new NetworkService(Settings.EMPTY, Collections.emptyList())){

            protected String handleRequest(MockTcpTransport.MockChannel mockChannel, String profileName, StreamInput stream, long requestId, int messageLengthBytes, Version version, InetSocketAddress remoteAddress, byte status) throws IOException {
                return super.handleRequest((Object)mockChannel, profileName, stream, requestId, messageLengthBytes, version, remoteAddress, (byte)(status & 0xFFFFFFF7));
            }
        };){
            transport.transportServiceAdapter((TransportServiceAdapter)new TransportService.Adapter((TransportService)this.serviceA));
            transport.start();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", transport.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0);
            try (TcpTransport.NodeChannels connection = originalTransport.openConnection(node, null);){
                Version version = originalTransport.executeHandshake(node, connection.channel(TransportRequestOptions.Type.PING), TimeValue.timeValueSeconds((long)10L));
                AbstractSimpleTransportTestCase.assertNull((Object)version);
            }
        }
        var4_4 = null;
        try (MockTransportService service = this.buildService("TS_TPC", Version.CURRENT, null);
             TcpTransport.NodeChannels connection = originalTransport.openConnection(new DiscoveryNode("TS_TPC", "TS_TPC", service.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0), null);){
            Version version = originalTransport.executeHandshake(connection.getNode(), connection.channel(TransportRequestOptions.Type.PING), TimeValue.timeValueSeconds((long)10L));
            AbstractSimpleTransportTestCase.assertEquals((Object)version, (Object)Version.CURRENT);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public void testTcpHandshakeTimeout() throws IOException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport does a handshake", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(InetAddress.getLocalHost(), 0), 1);
            socket.setReuseAddress(true);
            DiscoveryNode dummy = new DiscoveryNode("TEST", (TransportAddress)new InetSocketTransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            builder.setHandshakeTimeout(TimeValue.timeValueMillis((long)1L));
            ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.connectToNode(dummy, builder.build()));
            AbstractSimpleTransportTestCase.assertEquals((Object)("[][" + dummy.getAddress() + "] handshake_timeout[1ms]"), (Object)ex.getMessage());
        }
    }

    public void testTcpHandshakeConnectionReset() throws IOException, InterruptedException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport does a handshake", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        try (final ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(InetAddress.getLocalHost(), 0), 1);
            socket.setReuseAddress(true);
            DiscoveryNode dummy = new DiscoveryNode("TEST", (TransportAddress)new InetSocketTransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (Socket accept = socket.accept();){
                        if (ESTestCase.randomBoolean()) {
                            accept.getInputStream().read();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
            t.start();
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            builder.setHandshakeTimeout(TimeValue.timeValueHours((long)1L));
            ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.connectToNode(dummy, builder.build()));
            AbstractSimpleTransportTestCase.assertEquals((Object)ex.getMessage(), (Object)("[][" + dummy.getAddress() + "] general node connection failure"));
            AbstractSimpleTransportTestCase.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.startsWith((String)"handshake failed"));
            t.join();
        }
    }

    public void testResponseHeadersArePreserved() throws InterruptedException {
        final ArrayList executors = new ArrayList(ThreadPool.THREAD_POOL_TYPES.keySet());
        CollectionUtil.timSort(executors);
        this.serviceA.registerRequestHandler("action", TestRequest::new, "same", (request, channel) -> {
            this.threadPool.getThreadContext().putTransient("boom", new Object());
            this.threadPool.getThreadContext().addResponseHeader("foo.bar", "baz");
            if ("fail".equals(request.info)) {
                throw new RuntimeException("boom");
            }
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        });
        final CountDownLatch latch = new CountDownLatch(2);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                try {
                    Assert.assertSame((Object)response, (Object)TransportResponse.Empty.INSTANCE);
                    Assert.assertTrue((boolean)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().containsKey("foo.bar"));
                    Assert.assertEquals((long)1L, (long)((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).size());
                    Assert.assertEquals((Object)"baz", ((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).get(0));
                    Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("boom"));
                }
                finally {
                    latch.countDown();
                }
            }

            public void handleException(TransportException exp) {
                try {
                    Assert.assertTrue((boolean)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().containsKey("foo.bar"));
                    Assert.assertEquals((long)1L, (long)((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).size());
                    Assert.assertEquals((Object)"baz", ((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).get(0));
                    Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("boom"));
                }
                finally {
                    latch.countDown();
                }
            }

            public String executor() {
                return (String)ESTestCase.randomFrom(executors);
            }
        };
        this.serviceB.sendRequest(this.nodeA, "action", new TestRequest(AbstractSimpleTransportTestCase.randomFrom("fail", "pass")), (TransportResponseHandler)transportResponseHandler);
        this.serviceA.sendRequest(this.nodeA, "action", new TestRequest(AbstractSimpleTransportTestCase.randomFrom("fail", "pass")), (TransportResponseHandler)transportResponseHandler);
        latch.await();
    }

    public void testHandlerIsInvokedOnConnectionClose() throws IOException, InterruptedException {
        final ArrayList executors = new ArrayList(ThreadPool.THREAD_POOL_TYPES.keySet());
        CollectionUtil.timSort(executors);
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        serviceC.registerRequestHandler("action", TestRequest::new, "same", (request, channel) -> {});
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch latch = new CountDownLatch(1);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                try {
                    Assert.fail((String)"no response expected");
                }
                finally {
                    latch.countDown();
                }
            }

            public void handleException(TransportException exp) {
                try {
                    if (exp instanceof SendRequestTransportException) {
                        Assert.assertTrue((String)exp.getCause().getClass().toString(), (boolean)(exp.getCause() instanceof NodeNotConnectedException));
                    } else {
                        Assert.assertTrue((String)exp.getClass().toString(), (boolean)(exp instanceof NodeDisconnectedException));
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            public String executor() {
                return (String)ESTestCase.randomFrom(executors);
            }
        };
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = this.serviceB.openConnection(serviceC.getLocalNode(), builder.build());){
            serviceC.close();
            this.serviceB.sendRequest(connection, "action", new TestRequest("boom"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
        }
        latch.await();
    }

    public void testConcurrentDisconnectOnNonPublishedConnection() throws IOException, InterruptedException {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        final CountDownLatch receivedLatch = new CountDownLatch(1);
        final CountDownLatch sendResponseLatch = new CountDownLatch(1);
        serviceC.registerRequestHandler("action", TestRequest::new, "same", (request, channel) -> this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
            }

            protected void doRun() throws Exception {
                receivedLatch.countDown();
                sendResponseLatch.await();
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            }
        }));
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                responseLatch.countDown();
            }

            public String executor() {
                return "same";
            }
        };
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = this.serviceB.openConnection(serviceC.getLocalNode(), builder.build());){
            this.serviceB.sendRequest(connection, "action", new TestRequest("hello world"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
            receivedLatch.await();
            serviceC.close();
            sendResponseLatch.countDown();
            responseLatch.await();
        }
    }

    private static class TestResponse
    extends TransportResponse {
        String info;

        TestResponse() {
        }

        TestResponse(String info) {
            this.info = info;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.info = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.info);
        }

        public String toString() {
            return "TestResponse{info='" + this.info + '\'' + '}';
        }
    }

    public static class TestRequest
    extends TransportRequest {
        String info;
        int resendCount;

        public TestRequest() {
        }

        public TestRequest(String info) {
            this.info = info;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.info = in.readOptionalString();
            this.resendCount = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.info);
            out.writeInt(this.resendCount);
        }

        public String toString() {
            return "TestRequest{info='" + this.info + '\'' + '}';
        }
    }

    static class Version1Response
    extends Version0Response {
        int value2;

        Version1Response() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().onOrAfter(version1)) {
                this.value2 = in.readInt();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(version1)) {
                out.writeInt(this.value2);
            }
        }
    }

    static class Version0Response
    extends TransportResponse {
        int value1;

        Version0Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.value1 = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.value1);
        }
    }

    public static class Version1Request
    extends Version0Request {
        int value2;

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().onOrAfter(version1)) {
                this.value2 = in.readInt();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(version1)) {
                out.writeInt(this.value2);
            }
        }
    }

    public static class Version0Request
    extends TransportRequest {
        int value1;

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.value1 = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.value1);
        }
    }

    static class StringMessageResponse
    extends TransportResponse {
        private String message;

        StringMessageResponse(String message) {
            this.message = message;
        }

        StringMessageResponse() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.message = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.message);
        }
    }

    public static class StringMessageRequest
    extends TransportRequest {
        private String message;
        private long timeout;

        StringMessageRequest(String message, long timeout) {
            this.message = message;
            this.timeout = timeout;
        }

        public StringMessageRequest() {
        }

        public StringMessageRequest(String message) {
            this(message, -1L);
        }

        public long timeout() {
            return this.timeout;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.message = in.readString();
            this.timeout = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.message);
            out.writeLong(this.timeout);
        }
    }

    private static class Tracer
    extends MockTransportService.Tracer {
        private final Set<String> actions;
        public volatile boolean sawRequestSent;
        public volatile boolean sawRequestReceived;
        public volatile boolean sawResponseSent;
        public volatile boolean sawErrorSent;
        public volatile boolean sawResponseReceived;
        public AtomicReference<CountDownLatch> expectedEvents = new AtomicReference();

        Tracer(Set<String> actions) {
            this.actions = actions;
        }

        @Override
        public void receivedRequest(long requestId, String action) {
            super.receivedRequest(requestId, action);
            if (this.actions.contains(action)) {
                this.sawRequestReceived = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            super.requestSent(node, requestId, action, options);
            if (this.actions.contains(action)) {
                this.sawRequestSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void responseSent(long requestId, String action) {
            super.responseSent(requestId, action);
            if (this.actions.contains(action)) {
                this.sawResponseSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void responseSent(long requestId, String action, Throwable t) {
            super.responseSent(requestId, action, t);
            if (this.actions.contains(action)) {
                this.sawErrorSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            super.receivedResponse(requestId, sourceNode, action);
            if (this.actions.contains(action)) {
                this.sawResponseReceived = true;
                this.expectedEvents.get().countDown();
            }
        }

        public void reset(int expectedCount) {
            this.sawRequestSent = false;
            this.sawRequestReceived = false;
            this.sawResponseSent = false;
            this.sawErrorSent = false;
            this.sawResponseReceived = false;
            this.expectedEvents.set(new CountDownLatch(expectedCount));
        }
    }
}

