/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class GreaterThanAssertion
extends Assertion {
    private static final Logger logger = Loggers.getLogger(GreaterThanAssertion.class);

    public static GreaterThanAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        if (!(stringObjectTuple.v2() instanceof Comparable)) {
            throw new IllegalArgumentException("gt section can only be used with objects that support natural ordering, found " + stringObjectTuple.v2().getClass().getSimpleName());
        }
        return new GreaterThanAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public GreaterThanAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is greater than [{}] (field: [{}])", actualValue, expectedValue, (Object)this.getField());
        Assert.assertThat((String)("value of [" + this.getField() + "] is not comparable (got [" + this.safeClass(actualValue) + "])"), (Object)actualValue, (Matcher)Matchers.instanceOf(Comparable.class));
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not comparable (got [" + expectedValue.getClass() + "])"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Comparable.class));
        try {
            Assert.assertThat((String)this.errorMessage(), (Object)((Comparable)actualValue), (Matcher)Matchers.greaterThan((Comparable)((Comparable)expectedValue)));
        }
        catch (ClassCastException e) {
            Assert.fail((String)("cast error while checking (" + this.errorMessage() + "): " + e));
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] is not greater than [" + this.getExpectedValue() + "]";
    }
}

