/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.PrimaryShardAllocator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public class TestGatewayAllocator
extends GatewayAllocator {
    Map<String, Map<ShardId, ShardRouting>> knownAllocations = new HashMap<String, Map<ShardId, ShardRouting>>();
    DiscoveryNodes currentNodes = DiscoveryNodes.EMPTY_NODES;
    PrimaryShardAllocator primaryShardAllocator = new PrimaryShardAllocator(Settings.EMPTY){

        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            ShardId shardId = shard.shardId();
            Set ignoreNodes = allocation.getIgnoreNodes(shardId);
            Map<DiscoveryNode, TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> foundShards = TestGatewayAllocator.this.knownAllocations.values().stream().flatMap(shardMap -> shardMap.values().stream()).filter(ks -> ks.shardId().equals((Object)shardId)).filter(ks -> !ignoreNodes.contains(ks.currentNodeId())).filter(ks -> TestGatewayAllocator.this.currentNodes.nodeExists(ks.currentNodeId())).collect(Collectors.toMap(routing -> TestGatewayAllocator.this.currentNodes.get(routing.currentNodeId()), routing -> new TransportNodesListGatewayStartedShards.NodeGatewayStartedShards(TestGatewayAllocator.this.currentNodes.get(routing.currentNodeId()), -1L, routing.allocationId().getId(), routing.primary())));
            return new AsyncShardFetch.FetchResult(shardId, foundShards, ignoreNodes);
        }
    };
    ReplicaShardAllocator replicaShardAllocator = new ReplicaShardAllocator(Settings.EMPTY){

        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            ShardId shardId = shard.shardId();
            return new AsyncShardFetch.FetchResult(shardId, Collections.emptyMap(), allocation.getIgnoreNodes(shardId));
        }

        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return true;
        }
    };

    public TestGatewayAllocator() {
        super(Settings.EMPTY, null, null);
    }

    public void applyStartedShards(RoutingAllocation allocation, List<ShardRouting> startedShards) {
        this.currentNodes = allocation.nodes();
        allocation.routingNodes().shards(ShardRouting::active).forEach(this::addKnownAllocation);
    }

    public void applyFailedShards(RoutingAllocation allocation, List<FailedShard> failedShards) {
        this.currentNodes = allocation.nodes();
        for (FailedShard failedShard : failedShards) {
            ShardRouting failedRouting = failedShard.getRoutingEntry();
            Map<ShardId, ShardRouting> nodeAllocations = this.knownAllocations.get(failedRouting.currentNodeId());
            if (nodeAllocations == null) continue;
            nodeAllocations.remove(failedRouting.shardId());
            if (!nodeAllocations.isEmpty()) continue;
            this.knownAllocations.remove(failedRouting.currentNodeId());
        }
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        this.currentNodes = allocation.nodes();
        TestGatewayAllocator.innerAllocatedUnassigned((RoutingAllocation)allocation, (PrimaryShardAllocator)this.primaryShardAllocator, (ReplicaShardAllocator)this.replicaShardAllocator);
    }

    public void addKnownAllocation(ShardRouting shard) {
        this.knownAllocations.computeIfAbsent(shard.currentNodeId(), id -> new HashMap()).put(shard.shardId(), shard);
    }
}

