/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStoreConfig;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.MockTransportClient;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class InternalTestCluster
extends TestCluster {
    private final Logger logger = Loggers.getLogger(this.getClass());
    public static final int PORTS_PER_JVM = 100;
    public static final int PORTS_PER_CLUSTER = 20;
    private static final int GLOBAL_TRANSPORT_BASE_PORT = 9300;
    private static final int GLOBAL_HTTP_BASE_PORT = 19200;
    private static final int JVM_ORDINAL = Integer.parseInt(System.getProperty("junit4.childvm.id", "0"));
    public static final int JVM_BASE_PORT_OFFSET = 100 * (JVM_ORDINAL + 1);
    private static final AtomicInteger clusterOrdinal = new AtomicInteger();
    private final int CLUSTER_BASE_PORT_OFFSET = JVM_BASE_PORT_OFFSET + clusterOrdinal.getAndIncrement() * 20 % 100;
    public final int TRANSPORT_BASE_PORT = 9300 + this.CLUSTER_BASE_PORT_OFFSET;
    public final int HTTP_BASE_PORT = 19200 + this.CLUSTER_BASE_PORT_OFFSET;
    public static final int DEFAULT_LOW_NUM_MASTER_NODES = 1;
    public static final int DEFAULT_HIGH_NUM_MASTER_NODES = 3;
    static final int DEFAULT_MIN_NUM_DATA_NODES = 1;
    static final int DEFAULT_MAX_NUM_DATA_NODES = LuceneTestCase.TEST_NIGHTLY ? 6 : 3;
    static final int DEFAULT_NUM_CLIENT_NODES = -1;
    static final int DEFAULT_MIN_NUM_CLIENT_NODES = 0;
    static final int DEFAULT_MAX_NUM_CLIENT_NODES = 1;
    static final boolean DEFAULT_ENABLE_HTTP_PIPELINING = true;
    private final NavigableMap<String, NodeAndClient> nodes = new TreeMap<String, NodeAndClient>();
    private final Set<Path> dataDirToClean = new HashSet<Path>();
    private final String clusterName;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Settings defaultSettings;
    private AtomicInteger nextNodeId = new AtomicInteger(0);
    private final long[] sharedNodesSeeds;
    private final int numSharedDedicatedMasterNodes;
    private final int numSharedDataNodes;
    private final int numSharedCoordOnlyNodes;
    private final NodeConfigurationSource nodeConfigurationSource;
    private final ExecutorService executor;
    private final boolean autoManageMinMasterNodes;
    private final Collection<Class<? extends Plugin>> mockPlugins;
    private final String nodePrefix;
    private final Path baseDir;
    private ServiceDisruptionScheme activeDisruptionScheme;
    private Function<Client, Client> clientWrapper;
    public static final String TRANSPORT_CLIENT_PREFIX = "transport_client_";
    public static final RestartCallback EMPTY_CALLBACK = new RestartCallback(){

        @Override
        public Settings onNodeStopped(String node) {
            return null;
        }
    };

    public InternalTestCluster(long clusterSeed, Path baseDir, boolean randomlyAddDedicatedMasters, boolean autoManageMinMasterNodes, int minNumDataNodes, int maxNumDataNodes, String clusterName, NodeConfigurationSource nodeConfigurationSource, int numClientNodes, boolean enableHttpPipelining, String nodePrefix, Collection<Class<? extends Plugin>> mockPlugins, Function<Client, Client> clientWrapper) {
        super(clusterSeed);
        int numOfDataPaths;
        this.autoManageMinMasterNodes = autoManageMinMasterNodes;
        this.clientWrapper = clientWrapper;
        this.baseDir = baseDir;
        this.clusterName = clusterName;
        if (minNumDataNodes < 0 || maxNumDataNodes < 0) {
            throw new IllegalArgumentException("minimum and maximum number of data nodes must be >= 0");
        }
        if (maxNumDataNodes < minNumDataNodes) {
            throw new IllegalArgumentException("maximum number of data nodes must be >= minimum number of  data nodes");
        }
        Random random = new Random(clusterSeed);
        boolean useDedicatedMasterNodes = randomlyAddDedicatedMasters ? random.nextBoolean() : false;
        this.numSharedDataNodes = RandomNumbers.randomIntBetween((Random)random, (int)minNumDataNodes, (int)maxNumDataNodes);
        assert (this.numSharedDataNodes >= 0);
        if (this.numSharedDataNodes == 0) {
            this.numSharedCoordOnlyNodes = 0;
            this.numSharedDedicatedMasterNodes = 0;
        } else {
            this.numSharedDedicatedMasterNodes = useDedicatedMasterNodes ? (random.nextBoolean() ? 1 : 3) : 0;
            this.numSharedCoordOnlyNodes = numClientNodes < 0 ? RandomNumbers.randomIntBetween((Random)random, (int)0, (int)1) : numClientNodes;
        }
        assert (this.numSharedCoordOnlyNodes >= 0);
        this.nodePrefix = nodePrefix;
        assert (nodePrefix != null);
        this.mockPlugins = mockPlugins;
        this.sharedNodesSeeds = new long[this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes];
        for (int i = 0; i < this.sharedNodesSeeds.length; ++i) {
            this.sharedNodesSeeds[i] = random.nextLong();
        }
        this.logger.info("Setup InternalTestCluster [{}] with seed [{}] using [{}] dedicated masters, [{}] (data) nodes and [{}] coord only nodes (min_master_nodes are [{}])", (Object)clusterName, (Object)SeedUtils.formatSeed((long)clusterSeed), (Object)this.numSharedDedicatedMasterNodes, (Object)this.numSharedDataNodes, (Object)this.numSharedCoordOnlyNodes, (Object)(autoManageMinMasterNodes ? "auto-managed" : "manual"));
        this.nodeConfigurationSource = nodeConfigurationSource;
        Settings.Builder builder = Settings.builder();
        if (random.nextInt(5) == 0 && (numOfDataPaths = random.nextInt(5)) > 0) {
            StringBuilder dataPath = new StringBuilder();
            for (int i = 0; i < numOfDataPaths; ++i) {
                dataPath.append(baseDir.resolve("d" + i).toAbsolutePath()).append(',');
            }
            builder.put(Environment.PATH_DATA_SETTING.getKey(), dataPath.toString());
        }
        builder.put(NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.getKey(), Integer.MAX_VALUE);
        builder.put(new Object[]{Environment.PATH_SHARED_DATA_SETTING.getKey(), baseDir.resolve("custom")});
        builder.put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), baseDir});
        builder.put(new Object[]{Environment.PATH_REPO_SETTING.getKey(), baseDir.resolve("repos")});
        builder.put(TransportSettings.PORT.getKey(), this.TRANSPORT_BASE_PORT + "-" + (this.TRANSPORT_BASE_PORT + 20));
        builder.put("http.port", this.HTTP_BASE_PORT + "-" + (this.HTTP_BASE_PORT + 20));
        builder.put("http.pipelining", enableHttpPipelining);
        if (Strings.hasLength((String)System.getProperty("tests.es.logger.level"))) {
            builder.put("logger.level", System.getProperty("tests.es.logger.level"));
        }
        if (Strings.hasLength((String)System.getProperty("es.logger.prefix"))) {
            builder.put("logger.prefix", System.getProperty("es.logger.prefix"));
        }
        builder.put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b");
        builder.put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b");
        builder.put(ScriptService.SCRIPT_MAX_COMPILATIONS_PER_MINUTE.getKey(), 1000);
        if (LuceneTestCase.TEST_NIGHTLY) {
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)5, (int)10));
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)5, (int)10));
        } else if (random.nextInt(100) <= 90) {
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)2, (int)5));
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)2, (int)5));
        }
        builder.put(new Object[]{RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING.getKey(), TimeValue.timeValueMillis((long)RandomNumbers.randomIntBetween((Random)random, (int)20, (int)50))});
        this.defaultSettings = builder.build();
        this.executor = EsExecutors.newScaling((String)"test runner", (int)0, (int)Integer.MAX_VALUE, (long)0L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)EsExecutors.daemonThreadFactory((String)("test_" + clusterName)), (ThreadContext)new ThreadContext(Settings.EMPTY));
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public boolean getAutoManageMinMasterNode() {
        return this.autoManageMinMasterNodes;
    }

    public String[] getNodeNames() {
        return this.nodes.keySet().toArray(Strings.EMPTY_ARRAY);
    }

    private Settings getSettings(int nodeOrdinal, long nodeSeed, Settings others) {
        Settings.Builder builder = Settings.builder().put(this.defaultSettings).put(this.getRandomNodeSettings(nodeSeed));
        Settings settings = this.nodeConfigurationSource.nodeSettings(nodeOrdinal);
        if (settings != null) {
            if (settings.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) != null) {
                throw new IllegalStateException("Tests must not set a '" + ClusterName.CLUSTER_NAME_SETTING.getKey() + "' as a node setting set '" + ClusterName.CLUSTER_NAME_SETTING.getKey() + "': [" + settings.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) + "]");
            }
            builder.put(settings);
        }
        if (others != null) {
            builder.put(others);
        }
        builder.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), this.clusterName);
        return builder.build();
    }

    private Collection<Class<? extends Plugin>> getPlugins() {
        HashSet<Class<? extends Plugin>> plugins = new HashSet<Class<? extends Plugin>>(this.nodeConfigurationSource.nodePlugins());
        plugins.addAll(this.mockPlugins);
        return plugins;
    }

    private Settings getRandomNodeSettings(long seed) {
        Random random = new Random(seed);
        Settings.Builder builder = Settings.builder();
        builder.put(Transport.TRANSPORT_TCP_COMPRESS.getKey(), LuceneTestCase.rarely((Random)random));
        if (random.nextBoolean()) {
            builder.put(new Object[]{"cache.recycler.page.type", RandomPicks.randomFrom((Random)random, (Object[])PageCacheRecycler.Type.values())});
        }
        if (random.nextInt(10) == 0) {
            builder.put(SearchService.KEEPALIVE_INTERVAL_SETTING.getKey(), TimeValue.timeValueMillis((long)(10 + random.nextInt(2000))).getStringRep());
        } else if (random.nextInt(10) != 0) {
            builder.put(SearchService.KEEPALIVE_INTERVAL_SETTING.getKey(), TimeValue.timeValueSeconds((long)(10 + random.nextInt(300))).getStringRep());
        }
        if (random.nextBoolean()) {
            builder.put(SearchService.DEFAULT_KEEPALIVE_SETTING.getKey(), TimeValue.timeValueSeconds((long)(100 + random.nextInt(300))).getStringRep());
        }
        builder.put(EsExecutors.PROCESSORS_SETTING.getKey(), 1 + random.nextInt(3));
        if (random.nextBoolean() && random.nextBoolean()) {
            builder.put("indices.fielddata.cache.size", (long)(1 + random.nextInt(1000)), ByteSizeUnit.MB);
        }
        if (random.nextBoolean()) {
            builder.put(TcpTransport.CONNECTIONS_PER_NODE_RECOVERY.getKey(), random.nextInt(2) + 1);
            builder.put(TcpTransport.CONNECTIONS_PER_NODE_BULK.getKey(), random.nextInt(3) + 1);
            builder.put(TcpTransport.CONNECTIONS_PER_NODE_REG.getKey(), random.nextInt(6) + 1);
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{MappingUpdatedAction.INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.getKey(), new TimeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)10, (int)30), TimeUnit.SECONDS)});
        }
        if (random.nextInt(10) == 0) {
            builder.put(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_TYPE_SETTING.getKey(), "noop");
            builder.put(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING.getKey(), "noop");
        }
        if (random.nextBoolean()) {
            if (random.nextInt(10) == 0) {
                builder.put(new Object[]{IndexStoreConfig.INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10), ByteSizeUnit.MB)});
            } else {
                builder.put(new Object[]{IndexStoreConfig.INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)10, (int)200), ByteSizeUnit.MB)});
            }
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{IndexStoreConfig.INDICES_STORE_THROTTLE_TYPE_SETTING.getKey(), RandomPicks.randomFrom((Random)random, (Object[])StoreRateLimiting.Type.values())});
        }
        if (random.nextBoolean()) {
            if (random.nextInt(10) == 0) {
                builder.put(new Object[]{RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10), ByteSizeUnit.MB)});
            } else {
                builder.put(new Object[]{RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)10, (int)200), ByteSizeUnit.MB)});
            }
        }
        if (random.nextBoolean()) {
            builder.put(TcpTransport.PING_SCHEDULE.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)100, (int)2000) + "ms");
        }
        if (random.nextBoolean()) {
            builder.put(ScriptService.SCRIPT_CACHE_SIZE_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)0, (int)2000));
        }
        if (random.nextBoolean()) {
            builder.put(ScriptService.SCRIPT_CACHE_EXPIRE_SETTING.getKey(), TimeValue.timeValueMillis((long)RandomNumbers.randomIntBetween((Random)random, (int)750, (int)10000000)).getStringRep());
        }
        return builder.build();
    }

    public static String clusterName(String prefix, long clusterSeed) {
        StringBuilder builder = new StringBuilder(prefix);
        int childVM = RandomizedTest.systemPropertyAsInt((String)"junit4.childvm.id", (int)0);
        builder.append("-CHILD_VM=[").append(childVM).append(']');
        builder.append("-CLUSTER_SEED=[").append(clusterSeed).append(']');
        builder.append("-HASH=[").append(SeedUtils.formatSeed((long)System.nanoTime())).append(']');
        return builder.toString();
    }

    private void ensureOpen() {
        if (!this.open.get()) {
            throw new RuntimeException("Cluster is already closed");
        }
    }

    private synchronized NodeAndClient getOrBuildRandomNode() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient;
        }
        NodeAndClient buildNode = this.buildNode(1);
        buildNode.startNode();
        this.publishNode(buildNode);
        return buildNode;
    }

    private synchronized NodeAndClient getRandomNodeAndClient() {
        return this.getRandomNodeAndClient(nc -> true);
    }

    private synchronized NodeAndClient getRandomNodeAndClient(Predicate<NodeAndClient> predicate) {
        this.ensureOpen();
        Collection values = this.nodes.values().stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
        if (!values.isEmpty()) {
            int whichOne = this.random.nextInt(values.size());
            for (NodeAndClient nodeAndClient : values) {
                if (whichOne-- != 0) continue;
                return nodeAndClient;
            }
        }
        return null;
    }

    public synchronized void ensureAtLeastNumDataNodes(int n) {
        int size;
        boolean added = false;
        for (int i = size = this.numDataNodes(); i < n; ++i) {
            this.logger.info("increasing cluster size from {} to {}", (Object)size, (Object)n);
            added = true;
            if (this.numSharedDedicatedMasterNodes > 0) {
                this.startDataOnlyNode(Settings.EMPTY);
                continue;
            }
            this.startNode(Settings.EMPTY);
        }
        if (added) {
            this.validateClusterFormed();
        }
    }

    public synchronized void ensureAtMostNumDataNodes(int n) throws IOException {
        int size = this.numDataNodes();
        if (size <= n) {
            return;
        }
        Stream collection = n == 0 ? this.nodes.values().stream() : this.nodes.values().stream().filter(new DataNodePredicate().and(new MasterNodePredicate(this.getMasterName()).negate()));
        Iterator values = collection.iterator();
        this.logger.info("changing cluster size from {} data nodes to {}", (Object)size, (Object)n);
        HashSet<NodeAndClient> nodesToRemove = new HashSet<NodeAndClient>();
        int numNodesAndClients = 0;
        while (values.hasNext() && numNodesAndClients++ < size - n) {
            NodeAndClient next = (NodeAndClient)values.next();
            nodesToRemove.add(next);
        }
        this.stopNodesAndClients(nodesToRemove);
        if (!nodesToRemove.isEmpty() && this.size() > 0) {
            this.validateClusterFormed();
        }
    }

    private NodeAndClient buildNode(Settings settings, int defaultMinMasterNodes) {
        int ord = this.nextNodeId.getAndIncrement();
        return this.buildNode(ord, this.random.nextLong(), settings, false, defaultMinMasterNodes);
    }

    private NodeAndClient buildNode(int defaultMinMasterNodes) {
        int ord = this.nextNodeId.getAndIncrement();
        return this.buildNode(ord, this.random.nextLong(), null, false, defaultMinMasterNodes);
    }

    private NodeAndClient buildNode(int nodeId, long seed, Settings settings, boolean reuseExisting, int defaultMinMasterNodes) {
        assert (Thread.holdsLock(this));
        this.ensureOpen();
        settings = this.getSettings(nodeId, seed, settings);
        Collection<Class<? extends Plugin>> plugins = this.getPlugins();
        String name = this.buildNodeName(nodeId, settings);
        if (reuseExisting && this.nodes.containsKey(name)) {
            return (NodeAndClient)this.nodes.get(name);
        }
        assert (reuseExisting || !this.nodes.containsKey(name)) : "node name [" + name + "] already exists but not allowed to use it";
        Settings.Builder finalSettings = Settings.builder().put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), this.baseDir}).put(settings).put("node.name", name).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), seed);
        boolean usingSingleNodeDiscovery = ((String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(finalSettings.build())).equals("single-node");
        if (!usingSingleNodeDiscovery && this.autoManageMinMasterNodes) {
            assert (finalSettings.get(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey()) == null) : "min master nodes may not be set when auto managed";
            assert (finalSettings.get(DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.getKey()) == null) : "automatically managing min master nodes require nodes to complete a join cycle when starting";
            finalSettings.put(ZenDiscovery.MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING.getKey(), "5s").put(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey(), defaultMinMasterNodes);
        } else if (!usingSingleNodeDiscovery && finalSettings.get(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey()) == null) {
            throw new IllegalArgumentException(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey() + " must be configured");
        }
        SecureSettings secureSettings = finalSettings.getSecureSettings();
        MockNode node = new MockNode(finalSettings.build(), plugins);
        try {
            IOUtils.close((Closeable[])new Closeable[]{secureSettings});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new NodeAndClient(name, node, nodeId);
    }

    private String buildNodeName(int id, Settings settings) {
        String prefix = this.nodePrefix;
        prefix = prefix + this.getRoleSuffix(settings);
        return prefix + id;
    }

    private String getRoleSuffix(Settings settings) {
        String suffix = "";
        if (Node.NODE_MASTER_SETTING.exists(settings) && ((Boolean)Node.NODE_MASTER_SETTING.get(settings)).booleanValue()) {
            suffix = suffix + DiscoveryNode.Role.MASTER.getAbbreviation();
        }
        if (Node.NODE_DATA_SETTING.exists(settings) && ((Boolean)Node.NODE_DATA_SETTING.get(settings)).booleanValue()) {
            suffix = suffix + DiscoveryNode.Role.DATA.getAbbreviation();
        }
        if (Node.NODE_MASTER_SETTING.exists(settings) && !((Boolean)Node.NODE_MASTER_SETTING.get(settings)).booleanValue() && Node.NODE_DATA_SETTING.exists(settings) && !((Boolean)Node.NODE_DATA_SETTING.get(settings)).booleanValue()) {
            suffix = suffix + "c";
        }
        return suffix;
    }

    public String nodePrefix() {
        return this.nodePrefix;
    }

    @Override
    public synchronized Client client() {
        this.ensureOpen();
        return this.getOrBuildRandomNode().client(this.random);
    }

    public synchronized Client dataNodeClient() {
        this.ensureOpen();
        return this.getRandomNodeAndClient(new DataNodePredicate()).client(this.random);
    }

    public synchronized Client masterClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new MasterNodePredicate(this.getMasterName()));
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No master client found");
        return null;
    }

    public synchronized Client nonMasterClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new MasterNodePredicate(this.getMasterName()).negate());
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No non-master client found");
        return null;
    }

    public synchronized Client coordOnlyNodeClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new NoDataNoMasterNodePredicate());
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.client(this.random);
        }
        int nodeId = this.nextNodeId.getAndIncrement();
        Settings settings = this.getSettings(nodeId, this.random.nextLong(), Settings.EMPTY);
        this.startCoordinatingOnlyNode(settings);
        return this.getRandomNodeAndClient(new NoDataNoMasterNodePredicate()).client(this.random);
    }

    public synchronized String startCoordinatingOnlyNode(Settings settings) {
        this.ensureOpen();
        Settings.Builder builder = Settings.builder().put(settings).put(Node.NODE_MASTER_SETTING.getKey(), false).put(Node.NODE_DATA_SETTING.getKey(), false).put(Node.NODE_INGEST_SETTING.getKey(), false);
        return this.startNode(builder);
    }

    public synchronized Client transportClient() {
        this.ensureOpen();
        return this.getOrBuildRandomNode().transportClient();
    }

    public synchronized Client client(String nodeName) {
        this.ensureOpen();
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            return nodeAndClient.client(this.random);
        }
        Assert.fail((String)("No node found with name: [" + nodeName + "]"));
        return null;
    }

    public synchronized Client smartClient() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No smart client found");
        return null;
    }

    public synchronized Client client(Predicate<Settings> filterPredicate) {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(nodeAndClient -> filterPredicate.test(((NodeAndClient)nodeAndClient).node.settings()));
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.client(this.random);
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.open.compareAndSet(true, false)) {
            if (this.activeDisruptionScheme != null) {
                this.activeDisruptionScheme.testClusterClosed();
                this.activeDisruptionScheme = null;
            }
            IOUtils.closeWhileHandlingException(this.nodes.values());
            this.nodes.clear();
            this.executor.shutdownNow();
        }
    }

    @Override
    public synchronized void beforeTest(Random random, double transportClientRatio) throws IOException, InterruptedException {
        super.beforeTest(random, transportClientRatio);
        this.reset(true);
    }

    private synchronized void reset(boolean wipeData) throws IOException {
        NodeAndClient nodeAndClient;
        Settings.Builder settings;
        int i;
        for (NodeAndClient nodeAndClient2 : this.nodes.values()) {
            TransportService transportService = (TransportService)nodeAndClient2.node.injector().getInstance(TransportService.class);
            if (!(transportService instanceof MockTransportService)) continue;
            MockTransportService mockTransportService = (MockTransportService)transportService;
            mockTransportService.clearAllRules();
            mockTransportService.clearTracers();
        }
        this.randomlyResetClients();
        int newSize = this.sharedNodesSeeds.length;
        if (this.nextNodeId.get() == newSize && this.nodes.size() == newSize) {
            if (wipeData) {
                this.wipePendingDataDirectories();
            }
            if (this.nodes.size() > 0 && this.autoManageMinMasterNodes) {
                this.updateMinMasterNodes(this.getMasterNodesCount());
            }
            this.logger.debug("Cluster hasn't changed - moving out - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
            return;
        }
        this.logger.debug("Cluster is NOT consistent - restarting shared nodes - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
        ArrayList<NodeAndClient> toClose = new ArrayList<NodeAndClient>();
        for (NodeAndClient nodeAndClient3 : this.nodes.values()) {
            if (nodeAndClient3.nodeAndClientId() < this.sharedNodesSeeds.length) continue;
            this.logger.debug("Close Node [{}] not shared", (Object)nodeAndClient3.name);
            toClose.add(nodeAndClient3);
        }
        this.stopNodesAndClients(toClose);
        if (wipeData) {
            this.wipePendingDataDirectories();
        }
        assert (newSize == this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes);
        int numberOfMasterNodes = this.numSharedDedicatedMasterNodes > 0 ? this.numSharedDedicatedMasterNodes : this.numSharedDataNodes;
        int defaultMinMasterNodes = numberOfMasterNodes / 2 + 1;
        ArrayList<NodeAndClient> toStartAndPublish = new ArrayList<NodeAndClient>();
        for (i = 0; i < this.numSharedDedicatedMasterNodes; ++i) {
            settings = Settings.builder();
            settings.put(Node.NODE_MASTER_SETTING.getKey(), true);
            settings.put(Node.NODE_DATA_SETTING.getKey(), false);
            nodeAndClient = this.buildNode(i, this.sharedNodesSeeds[i], settings.build(), true, defaultMinMasterNodes);
            toStartAndPublish.add(nodeAndClient);
        }
        for (i = this.numSharedDedicatedMasterNodes; i < this.numSharedDedicatedMasterNodes + this.numSharedDataNodes; ++i) {
            settings = Settings.builder();
            if (this.numSharedDedicatedMasterNodes > 0) {
                settings.put(Node.NODE_MASTER_SETTING.getKey(), false).build();
                settings.put(Node.NODE_DATA_SETTING.getKey(), true).build();
            }
            nodeAndClient = this.buildNode(i, this.sharedNodesSeeds[i], settings.build(), true, defaultMinMasterNodes);
            toStartAndPublish.add(nodeAndClient);
        }
        for (i = this.numSharedDedicatedMasterNodes + this.numSharedDataNodes; i < this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes; ++i) {
            settings = Settings.builder().put(Node.NODE_MASTER_SETTING.getKey(), false).put(Node.NODE_DATA_SETTING.getKey(), false).put(Node.NODE_INGEST_SETTING.getKey(), false);
            nodeAndClient = this.buildNode(i, this.sharedNodesSeeds[i], settings.build(), true, defaultMinMasterNodes);
            toStartAndPublish.add(nodeAndClient);
        }
        this.startAndPublishNodesAndClients(toStartAndPublish);
        this.nextNodeId.set(newSize);
        assert (this.size() == newSize);
        if (newSize > 0) {
            this.validateClusterFormed();
        }
        this.logger.debug("Cluster is consistent again - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
    }

    public synchronized void validateClusterFormed() {
        String name = ESTestCase.randomFrom(this.random, this.getNodeNames());
        this.validateClusterFormed(name);
    }

    public synchronized void validateClusterFormed(String viaNode) {
        HashSet<DiscoveryNode> expectedNodes = new HashSet<DiscoveryNode>();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            expectedNodes.add(this.getInstanceFromNode(ClusterService.class, nodeAndClient.node()).localNode());
        }
        this.logger.trace("validating cluster formed via [{}], expecting {}", (Object)viaNode, expectedNodes);
        Client client = this.client(viaNode);
        try {
            if (!ESTestCase.awaitBusy(() -> {
                DiscoveryNodes discoveryNodes = ((ClusterStateResponse)client.admin().cluster().prepareState().get()).getState().nodes();
                if (discoveryNodes.getSize() != expectedNodes.size()) {
                    return false;
                }
                for (DiscoveryNode expectedNode : expectedNodes) {
                    if (discoveryNodes.nodeExists(expectedNode)) continue;
                    return false;
                }
                return true;
            }, 30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("cluster failed to form with expected nodes " + expectedNodes + " and actual nodes " + ((ClusterStateResponse)client.admin().cluster().prepareState().get()).getState().nodes());
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void afterTest() throws IOException {
        this.wipePendingDataDirectories();
        this.randomlyResetClients();
    }

    @Override
    public void beforeIndexDeletion() throws Exception {
        this.assertShardIndexCounter();
        this.assertSameSyncIdSameDocs();
    }

    private void assertSameSyncIdSameDocs() {
        HashMap<String, Long> docsOnShards = new HashMap<String, Long>();
        Collection nodesAndClients = this.nodes.values();
        for (NodeAndClient nodeAndClient : nodesAndClients) {
            IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
            for (IndexService indexService : indexServices) {
                for (IndexShard indexShard : indexService) {
                    String syncId;
                    CommitStats commitStats = indexShard.commitStats();
                    if (commitStats == null || (syncId = (String)commitStats.getUserData().get("sync_id")) == null) continue;
                    long liveDocsOnShard = commitStats.getNumDocs();
                    if (docsOnShards.get(syncId) != null) {
                        Assert.assertThat((String)("sync id is equal but number of docs does not match on node " + nodeAndClient.name + ". expected " + docsOnShards.get(syncId) + " but got " + liveDocsOnShard), docsOnShards.get(syncId), (Matcher)Matchers.equalTo((Object)liveDocsOnShard));
                        continue;
                    }
                    docsOnShards.put(syncId, liveDocsOnShard);
                }
            }
        }
    }

    private void assertShardIndexCounter() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Collection nodesAndClients = this.nodes.values();
            for (NodeAndClient nodeAndClient : nodesAndClients) {
                IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
                for (IndexService indexService : indexServices) {
                    for (IndexShard indexShard : indexService) {
                        int activeOperationsCount = indexShard.getActiveOperationsCount();
                        if (activeOperationsCount <= 0) continue;
                        TaskManager taskManager = this.getInstance(TransportService.class, nodeAndClient.name).getTaskManager();
                        DiscoveryNode localNode = this.getInstance(ClusterService.class, nodeAndClient.name).localNode();
                        List taskInfos = taskManager.getTasks().values().stream().filter(task -> task instanceof ReplicationTask).map(task -> task.taskInfo(localNode.getId(), true)).collect(Collectors.toList());
                        ListTasksResponse response = new ListTasksResponse(taskInfos, Collections.emptyList(), Collections.emptyList());
                        try {
                            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint().value((Object)response);
                            throw new AssertionError((Object)("expected index shard counter on shard " + indexShard.shardId() + " on node " + nodeAndClient.name + " to be 0 but was " + activeOperationsCount + ". Current replication tasks on node:\n" + builder.string()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException("caught exception while building response [" + response + "]", e);
                        }
                    }
                }
            }
        }));
    }

    private void randomlyResetClients() throws IOException {
        if (RandomizedTest.isNightly() && LuceneTestCase.rarely((Random)this.random)) {
            Collection nodesAndClients = this.nodes.values();
            for (NodeAndClient nodeAndClient : nodesAndClients) {
                nodeAndClient.resetClient();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipePendingDataDirectories() {
        assert (Thread.holdsLock(this));
        if (!this.dataDirToClean.isEmpty()) {
            try {
                for (Path path : this.dataDirToClean) {
                    try {
                        FileSystemUtils.deleteSubDirectories((Path[])new Path[]{path});
                        this.logger.info("Successfully wiped data directory for node location: {}", (Object)path);
                    }
                    catch (IOException e) {
                        this.logger.info("Failed to wipe data directory for node location: {}", (Object)path);
                    }
                }
            }
            finally {
                this.dataDirToClean.clear();
            }
        }
    }

    private void markNodeDataDirsAsPendingForWipe(Node node) {
        assert (Thread.holdsLock(this));
        NodeEnvironment nodeEnv = node.getNodeEnvironment();
        if (nodeEnv.hasNodeFile()) {
            this.dataDirToClean.addAll(Arrays.asList(nodeEnv.nodeDataPaths()));
        }
    }

    private void markNodeDataDirsAsNotEligableForWipe(Node node) {
        assert (Thread.holdsLock(this));
        NodeEnvironment nodeEnv = node.getNodeEnvironment();
        if (nodeEnv.hasNodeFile()) {
            this.dataDirToClean.removeAll(Arrays.asList(nodeEnv.nodeDataPaths()));
        }
    }

    public ClusterService clusterService() {
        return this.clusterService(null);
    }

    public synchronized ClusterService clusterService(@Nullable String node) {
        return this.getInstance(ClusterService.class, node);
    }

    public synchronized <T> Iterable<T> getInstances(Class<T> clazz) {
        ArrayList<T> instances = new ArrayList<T>(this.nodes.size());
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            instances.add(this.getInstanceFromNode(clazz, nodeAndClient.node));
        }
        return instances;
    }

    public synchronized <T> Iterable<T> getDataNodeInstances(Class<T> clazz) {
        return this.getInstances(clazz, new DataNodePredicate());
    }

    public synchronized <T> Iterable<T> getDataOrMasterNodeInstances(Class<T> clazz) {
        return this.getInstances(clazz, new DataOrMasterNodePredicate());
    }

    private synchronized <T> Iterable<T> getInstances(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        Iterable filteredNodes = this.nodes.values().stream().filter(predicate)::iterator;
        ArrayList<T> instances = new ArrayList<T>();
        for (NodeAndClient nodeAndClient : filteredNodes) {
            instances.add(this.getInstanceFromNode(clazz, nodeAndClient.node));
        }
        return instances;
    }

    public synchronized <T> T getInstance(Class<T> clazz, String node) {
        return this.getInstance(clazz, (NodeAndClient nc) -> node == null || node.equals(((NodeAndClient)nc).name));
    }

    public synchronized <T> T getDataNodeInstance(Class<T> clazz) {
        return this.getInstance(clazz, new DataNodePredicate());
    }

    private synchronized <T> T getInstance(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(predicate);
        assert (randomNodeAndClient != null);
        return this.getInstanceFromNode(clazz, randomNodeAndClient.node);
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, (NodeAndClient nc) -> true);
    }

    private synchronized <T> T getInstanceFromNode(Class<T> clazz, Node node) {
        return (T)node.injector().getInstance(clazz);
    }

    @Override
    public synchronized int size() {
        return this.nodes.size();
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (HttpServerTransport httpServerTransport : this.getInstances(HttpServerTransport.class)) {
            addresses.add(((InetSocketTransportAddress)httpServerTransport.boundAddress().publishAddress()).address());
        }
        return addresses.toArray(new InetSocketAddress[addresses.size()]);
    }

    public synchronized boolean stopRandomDataNode() throws IOException {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(new DataNodePredicate());
        if (nodeAndClient != null) {
            this.logger.info("Closing random node [{}] ", (Object)nodeAndClient.name);
            this.stopNodesAndClient(nodeAndClient);
            return true;
        }
        return false;
    }

    public synchronized void stopRandomNode(Predicate<Settings> filter) throws IOException {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(nc -> filter.test(((NodeAndClient)nc).node.settings()));
        if (nodeAndClient != null) {
            this.logger.info("Closing filtered random node [{}] ", (Object)nodeAndClient.name);
            this.stopNodesAndClient(nodeAndClient);
        }
    }

    public synchronized void stopCurrentMasterNode() throws IOException {
        this.ensureOpen();
        assert (this.size() > 0);
        String masterNodeName = this.getMasterName();
        assert (this.nodes.containsKey(masterNodeName));
        this.logger.info("Closing master node [{}] ", (Object)masterNodeName);
        this.stopNodesAndClient((NodeAndClient)this.nodes.get(masterNodeName));
    }

    public synchronized void stopRandomNonMasterNode() throws IOException {
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(new MasterNodePredicate(this.getMasterName()).negate());
        if (nodeAndClient != null) {
            this.logger.info("Closing random non master node [{}] current master [{}] ", (Object)nodeAndClient.name, (Object)this.getMasterName());
            this.stopNodesAndClient(nodeAndClient);
        }
    }

    private synchronized void startAndPublishNodesAndClients(List<NodeAndClient> nodeAndClients) {
        if (nodeAndClients.size() > 0) {
            int newMasters = (int)nodeAndClients.stream().filter(NodeAndClient::isMasterEligible).filter(nac -> !this.nodes.containsKey(((NodeAndClient)nac).name)).count();
            int currentMasters = this.getMasterNodesCount();
            if (this.autoManageMinMasterNodes && currentMasters > 1 && newMasters > 0) {
                this.updateMinMasterNodes(currentMasters + newMasters);
            }
            List futures = nodeAndClients.stream().map(node -> this.executor.submit(node::startNode)).collect(Collectors.toList());
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError("interrupted while starting nodes", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("failed to start nodes", e);
            }
            nodeAndClients.forEach(this::publishNode);
            if (this.autoManageMinMasterNodes && currentMasters == 1 && newMasters > 0) {
                this.validateClusterFormed();
                this.updateMinMasterNodes(currentMasters + newMasters);
            }
        }
    }

    private synchronized void stopNodesAndClient(NodeAndClient nodeAndClient) throws IOException {
        this.stopNodesAndClients(Collections.singleton(nodeAndClient));
    }

    private synchronized void stopNodesAndClients(Collection<NodeAndClient> nodeAndClients) throws IOException {
        int masters;
        if (this.autoManageMinMasterNodes && nodeAndClients.size() > 0 && (masters = (int)nodeAndClients.stream().filter(NodeAndClient::isMasterEligible).count()) > 0) {
            this.updateMinMasterNodes(this.getMasterNodesCount() - masters);
        }
        for (NodeAndClient nodeAndClient : nodeAndClients) {
            this.removeDisruptionSchemeFromNode(nodeAndClient);
            NodeAndClient previous = (NodeAndClient)this.nodes.remove(nodeAndClient.name);
            assert (previous == nodeAndClient);
            nodeAndClient.close();
        }
    }

    public void restartRandomNode() throws Exception {
        this.restartRandomNode(EMPTY_CALLBACK);
    }

    public void restartRandomNode(RestartCallback callback) throws Exception {
        this.restartRandomNode(nc -> true, callback);
    }

    public void restartRandomDataNode() throws Exception {
        this.restartRandomDataNode(EMPTY_CALLBACK);
    }

    public void restartRandomDataNode(RestartCallback callback) throws Exception {
        this.restartRandomNode(new DataNodePredicate(), callback);
    }

    private synchronized void restartRandomNode(Predicate<NodeAndClient> predicate, RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(predicate);
        if (nodeAndClient != null) {
            this.restartNode(nodeAndClient, callback);
        }
    }

    public synchronized void restartNode(String nodeName, RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            this.restartNode(nodeAndClient, callback);
        }
    }

    public void fullRestart() throws Exception {
        this.fullRestart(EMPTY_CALLBACK);
    }

    public void rollingRestart() throws Exception {
        this.rollingRestart(EMPTY_CALLBACK);
    }

    public synchronized void rollingRestart(RestartCallback callback) throws Exception {
        int numNodesRestarted = 0;
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
            this.restartNode(nodeAndClient, callback);
        }
    }

    private void restartNode(NodeAndClient nodeAndClient, RestartCallback callback) throws Exception {
        boolean updateMinMaster;
        this.logger.info("Restarting node [{}] ", (Object)nodeAndClient.name);
        if (this.activeDisruptionScheme != null) {
            this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
        }
        int masterNodesCount = this.getMasterNodesCount();
        boolean bl = updateMinMaster = nodeAndClient.isMasterEligible() && masterNodesCount == 2 && this.autoManageMinMasterNodes;
        if (updateMinMaster) {
            this.updateMinMasterNodes(masterNodesCount - 1);
        }
        nodeAndClient.restart(callback, true, this.autoManageMinMasterNodes ? this.getMinMasterNodes(masterNodesCount) : -1);
        if (this.activeDisruptionScheme != null) {
            this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
        }
        if (callback.validateClusterForming() || updateMinMaster) {
            this.validateClusterFormed(nodeAndClient.name);
        }
        if (updateMinMaster) {
            this.updateMinMasterNodes(masterNodesCount);
        }
    }

    public synchronized void fullRestart(RestartCallback callback) throws Exception {
        int numNodesRestarted = 0;
        HashMap<Set, List> nodesByRoles = new HashMap<Set, List>();
        Set[] rolesOrderedByOriginalStartupOrder = new Set[this.nextNodeId.get()];
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
            this.logger.info("Stopping node [{}] ", (Object)nodeAndClient.name);
            if (this.activeDisruptionScheme != null) {
                this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
            }
            nodeAndClient.closeNode();
            nodeAndClient.clearDataIfNeeded(callback);
            DiscoveryNode discoveryNode = this.getInstanceFromNode(ClusterService.class, nodeAndClient.node()).localNode();
            rolesOrderedByOriginalStartupOrder[((NodeAndClient)nodeAndClient).nodeAndClientId] = discoveryNode.getRoles();
            nodesByRoles.computeIfAbsent(discoveryNode.getRoles(), k -> new ArrayList()).add(nodeAndClient);
        }
        assert (nodesByRoles.values().stream().collect(Collectors.summingInt(List::size)).intValue() == this.nodes.size());
        for (List sameRoleNodes : nodesByRoles.values()) {
            Collections.shuffle(sameRoleNodes, this.random);
        }
        ArrayList<NodeAndClient> startUpOrder = new ArrayList<NodeAndClient>();
        for (Set roles : rolesOrderedByOriginalStartupOrder) {
            if (roles == null) continue;
            List nodesByRole = (List)nodesByRoles.get(roles);
            startUpOrder.add((NodeAndClient)nodesByRole.remove(0));
        }
        assert (nodesByRoles.values().stream().collect(Collectors.summingInt(List::size)) == 0);
        for (NodeAndClient nodeAndClient : startUpOrder) {
            this.logger.info("resetting node [{}] ", (Object)nodeAndClient.name);
            nodeAndClient.recreateNodeOnRestart(callback, false, this.autoManageMinMasterNodes ? this.getMinMasterNodes(this.getMasterNodesCount()) : -1);
        }
        this.startAndPublishNodesAndClients(startUpOrder);
        if (callback.validateClusterForming()) {
            this.validateClusterFormed();
        }
    }

    public String getMasterName() {
        return this.getMasterName(null);
    }

    public String getMasterName(@Nullable String viaNode) {
        try {
            Client client = viaNode != null ? this.client(viaNode) : this.client();
            ClusterState state = ((ClusterStateResponse)client.admin().cluster().prepareState().execute().actionGet()).getState();
            return state.nodes().getMasterNode().getName();
        }
        catch (Exception e) {
            this.logger.warn("Can't fetch cluster state", (Throwable)e);
            throw new RuntimeException("Can't get master node " + e.getMessage(), e);
        }
    }

    synchronized Set<String> allDataNodesButN(int numNodes) {
        return this.nRandomDataNodes(this.numDataNodes() - numNodes);
    }

    private synchronized Set<String> nRandomDataNodes(int numNodes) {
        assert (this.size() >= numNodes);
        Map<String, NodeAndClient> dataNodes = this.nodes.entrySet().stream().filter(new EntryNodePredicate(new DataNodePredicate())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashSet<String> set = new HashSet<String>();
        Iterator<String> iterator = dataNodes.keySet().iterator();
        for (int i = 0; i < numNodes; ++i) {
            assert (iterator.hasNext());
            set.add(iterator.next());
        }
        return set;
    }

    public synchronized Set<String> nodesInclude(String index) {
        if (this.clusterService().state().routingTable().hasIndex(index)) {
            List allShards = this.clusterService().state().routingTable().allShards(index);
            DiscoveryNodes discoveryNodes = this.clusterService().state().getNodes();
            HashSet<String> nodes = new HashSet<String>();
            for (ShardRouting shardRouting : allShards) {
                if (!shardRouting.assignedToNode()) continue;
                DiscoveryNode discoveryNode = discoveryNodes.get(shardRouting.currentNodeId());
                nodes.add(discoveryNode.getName());
            }
            return nodes;
        }
        return Collections.emptySet();
    }

    public synchronized String startNode() {
        return this.startNode(Settings.EMPTY);
    }

    public synchronized String startNode(Settings.Builder settings) {
        return this.startNode(settings.build());
    }

    public synchronized String startNode(Settings settings) {
        int defaultMinMasterNodes = this.getMinMasterNodes(this.getMasterNodesCount() + ((Boolean)Node.NODE_MASTER_SETTING.get(settings) != false ? 1 : 0));
        NodeAndClient buildNode = this.buildNode(settings, defaultMinMasterNodes);
        this.startAndPublishNodesAndClients(Collections.singletonList(buildNode));
        return buildNode.name;
    }

    public synchronized List<String> startNodes(int numOfNodes) {
        return this.startNodes(numOfNodes, Settings.EMPTY);
    }

    public synchronized List<String> startNodes(int numOfNodes, Settings settings) {
        return this.startNodes((Settings[])Collections.nCopies(numOfNodes, settings).stream().toArray(Settings[]::new));
    }

    public synchronized List<String> startNodes(Settings ... settings) {
        int defaultMinMasterNodes;
        if (this.autoManageMinMasterNodes) {
            int mastersDelta = (int)Stream.of(settings).filter(arg_0 -> ((Setting)Node.NODE_MASTER_SETTING).get(arg_0)).count();
            defaultMinMasterNodes = this.getMinMasterNodes(this.getMasterNodesCount() + mastersDelta);
        } else {
            defaultMinMasterNodes = -1;
        }
        ArrayList<NodeAndClient> nodes = new ArrayList<NodeAndClient>();
        for (Settings nodeSettings : settings) {
            nodes.add(this.buildNode(nodeSettings, defaultMinMasterNodes));
        }
        this.startAndPublishNodesAndClients(nodes);
        if (this.autoManageMinMasterNodes) {
            this.validateClusterFormed();
        }
        return nodes.stream().map(NodeAndClient::getName).collect(Collectors.toList());
    }

    public synchronized List<String> startMasterOnlyNodes(int numNodes) {
        return this.startMasterOnlyNodes(numNodes, Settings.EMPTY);
    }

    public synchronized List<String> startMasterOnlyNodes(int numNodes, Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put(Node.NODE_MASTER_SETTING.getKey(), true).put(Node.NODE_DATA_SETTING.getKey(), false).build();
        return this.startNodes(numNodes, settings1);
    }

    public synchronized List<String> startDataOnlyNodes(int numNodes) {
        return this.startDataOnlyNodes(numNodes, Settings.EMPTY);
    }

    public synchronized List<String> startDataOnlyNodes(int numNodes, Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put(Node.NODE_MASTER_SETTING.getKey(), false).put(Node.NODE_DATA_SETTING.getKey(), true).build();
        return this.startNodes(numNodes, settings1);
    }

    private int updateMinMasterNodes(int eligibleMasterNodeCount) {
        assert (this.autoManageMinMasterNodes);
        int minMasterNodes = this.getMinMasterNodes(eligibleMasterNodeCount);
        if (this.getMasterNodesCount() > 0) {
            this.logger.debug("updating min_master_nodes to [{}]", (Object)minMasterNodes);
            try {
                ElasticsearchAssertions.assertAcked(this.client().admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey(), minMasterNodes)));
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to update minimum master node to [{}] (current masters [{}])", (Throwable)e, new Object[]{minMasterNodes, this.getMasterNodesCount()});
            }
        }
        return minMasterNodes;
    }

    private int getMinMasterNodes(int eligibleMasterNodes) {
        return eligibleMasterNodes / 2 + 1;
    }

    private int getMasterNodesCount() {
        return (int)this.nodes.values().stream().filter(n -> (Boolean)Node.NODE_MASTER_SETTING.get(n.node().settings())).count();
    }

    public synchronized String startMasterOnlyNode() {
        return this.startMasterOnlyNode(Settings.EMPTY);
    }

    public synchronized String startMasterOnlyNode(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put(Node.NODE_MASTER_SETTING.getKey(), true).put(Node.NODE_DATA_SETTING.getKey(), false).build();
        return this.startNode(settings1);
    }

    public synchronized String startDataOnlyNode() {
        return this.startDataOnlyNode(Settings.EMPTY);
    }

    public synchronized String startDataOnlyNode(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put(Node.NODE_MASTER_SETTING.getKey(), false).put(Node.NODE_DATA_SETTING.getKey(), true).build();
        return this.startNode(settings1);
    }

    private synchronized void publishNode(NodeAndClient nodeAndClient) {
        assert (!nodeAndClient.node().isClosed());
        this.nodes.put(nodeAndClient.name, nodeAndClient);
        this.applyDisruptionSchemeToNode(nodeAndClient);
    }

    public void closeNonSharedNodes(boolean wipeData) throws IOException {
        this.reset(wipeData);
    }

    @Override
    public int numDataNodes() {
        return this.dataNodeAndClients().size();
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.dataAndMasterNodes().size();
    }

    public synchronized int numMasterNodes() {
        return this.filterNodes(this.nodes, NodeAndClient::isMasterEligible).size();
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        assert (this.activeDisruptionScheme == null) : "there is already and active disruption [" + this.activeDisruptionScheme + "]. call clearDisruptionScheme first";
        scheme.applyToCluster(this);
        this.activeDisruptionScheme = scheme;
    }

    public void clearDisruptionScheme() {
        this.clearDisruptionScheme(true);
    }

    public void clearDisruptionScheme(boolean ensureHealthyCluster) {
        if (this.activeDisruptionScheme != null) {
            TimeValue expectedHealingTime = this.activeDisruptionScheme.expectedTimeToHeal();
            this.logger.info("Clearing active scheme {}, expected healing time {}", (Object)this.activeDisruptionScheme, (Object)expectedHealingTime);
            if (ensureHealthyCluster) {
                this.activeDisruptionScheme.removeAndEnsureHealthy(this);
            } else {
                this.activeDisruptionScheme.removeFromCluster(this);
            }
        }
        this.activeDisruptionScheme = null;
    }

    private void applyDisruptionSchemeToNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
        }
    }

    private void removeDisruptionSchemeFromNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
        }
    }

    private synchronized Collection<NodeAndClient> dataNodeAndClients() {
        return this.filterNodes(this.nodes, new DataNodePredicate());
    }

    private synchronized Collection<NodeAndClient> dataAndMasterNodes() {
        return this.filterNodes(this.nodes, new DataOrMasterNodePredicate());
    }

    private synchronized Collection<NodeAndClient> filterNodes(Map<String, NodeAndClient> map, Predicate<NodeAndClient> predicate) {
        return map.values().stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    synchronized String routingKeyForShard(Index index, int shard, Random random) {
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        for (NodeAndClient n : this.nodes.values()) {
            String routing;
            int targetShard;
            MockNode node = n.node;
            IndicesService indicesService = this.getInstanceFromNode(IndicesService.class, node);
            ClusterService clusterService = this.getInstanceFromNode(ClusterService.class, node);
            IndexService indexService = indicesService.indexService(index);
            if (indexService == null) continue;
            Assert.assertThat((Object)indexService.getIndexSettings().getSettings().getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(shard)));
            OperationRouting operationRouting = clusterService.operationRouting();
            do {
                routing = RandomStrings.randomAsciiOfLength((Random)random, (int)10);
            } while (shard != (targetShard = operationRouting.indexShards(clusterService.state(), index.getName(), null, routing).shardId().getId()));
            return routing;
        }
        Assert.fail((String)("Could not find a node that holds " + index));
        return null;
    }

    @Override
    public synchronized Iterable<Client> getClients() {
        this.ensureOpen();
        return () -> {
            this.ensureOpen();
            final Iterator iterator = this.nodes.values().iterator();
            return new Iterator<Client>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Client next() {
                    return ((NodeAndClient)iterator.next()).client(InternalTestCluster.this.random);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("");
                }
            };
        };
    }

    public static Predicate<Settings> nameFilter(String ... nodeName) {
        return new NodeNamePredicate(new HashSet<String>(Arrays.asList(nodeName)));
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesFieldDataCache fdCache = this.getInstanceFromNode(IndicesService.class, nodeAndClient.node).getIndicesFieldDataCache();
                fdCache.getCache().refresh();
                String name = nodeAndClient.name;
                CircuitBreakerService breakerService = this.getInstanceFromNode(CircuitBreakerService.class, nodeAndClient.node);
                CircuitBreaker fdBreaker = breakerService.getBreaker("fielddata");
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + name), (Object)fdBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                try {
                    ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        CircuitBreaker reqBreaker = breakerService.getBreaker("request");
                        Assert.assertThat((String)("Request breaker not reset to 0 on node: " + name), (Object)reqBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                    }));
                }
                catch (Exception e) {
                    Assert.fail((String)("Exception during check for request breaker reset to 0: " + e));
                }
                NodeService nodeService = this.getInstanceFromNode(NodeService.class, nodeAndClient.node);
                CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Segments});
                NodeStats stats = nodeService.stats(flags, false, false, false, false, false, false, false, false, false, false, false);
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public void assertAfterTest() throws IOException {
        super.assertAfterTest();
        this.assertRequestsFinished();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            NodeEnvironment env = nodeAndClient.node().getNodeEnvironment();
            Set shardIds = env.lockedShards();
            for (ShardId id : shardIds) {
                try {
                    env.shardLock(id, TimeUnit.SECONDS.toMillis(5L)).close();
                }
                catch (ShardLockObtainFailedException ex) {
                    Assert.fail((String)("Shard " + id + " is still locked after 5 sec waiting"));
                }
            }
        }
    }

    private void assertRequestsFinished() {
        if (this.size() > 0) {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                CircuitBreaker inFlightRequestsBreaker = this.getInstance(CircuitBreakerService.class, nodeAndClient.name).getBreaker("in_flight_requests");
                try {
                    ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        long bytesUsed = inFlightRequestsBreaker.getUsed();
                        Assert.assertThat((String)("All incoming requests on node [" + nodeAndClient.name + "] should have finished. Expected 0 but got " + bytesUsed), (Object)bytesUsed, (Matcher)Matchers.equalTo((Object)0L));
                    }));
                }
                catch (Exception e) {
                    this.logger.error("Could not assert finished requests within timeout", (Throwable)e);
                    Assert.fail((String)("Could not assert finished requests within timeout on node [" + nodeAndClient.name + "]"));
                }
            }
        }
    }

    public static class RestartCallback {
        public Settings onNodeStopped(String nodeName) throws Exception {
            return Settings.EMPTY;
        }

        public void doAfterNodes(int n, Client client) throws Exception {
        }

        public boolean clearData(String nodeName) {
            return false;
        }

        public boolean validateClusterForming() {
            return true;
        }
    }

    private static final class NodeNamePredicate
    implements Predicate<Settings> {
        private final HashSet<String> nodeNames;

        NodeNamePredicate(HashSet<String> nodeNames) {
            this.nodeNames = nodeNames;
        }

        @Override
        public boolean test(Settings settings) {
            return this.nodeNames.contains(settings.get("node.name"));
        }
    }

    private static final class EntryNodePredicate
    implements Predicate<Map.Entry<String, NodeAndClient>> {
        private final Predicate<NodeAndClient> delegateNodePredicate;

        EntryNodePredicate(Predicate<NodeAndClient> delegateNodePredicate) {
            this.delegateNodePredicate = delegateNodePredicate;
        }

        @Override
        public boolean test(Map.Entry<String, NodeAndClient> entry) {
            return this.delegateNodePredicate.test(entry.getValue());
        }
    }

    private static final class NoDataNoMasterNodePredicate
    implements Predicate<NodeAndClient> {
        private NoDataNoMasterNodePredicate() {
        }

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return !DiscoveryNode.isMasterNode((Settings)nodeAndClient.node.settings()) && !DiscoveryNode.isDataNode((Settings)nodeAndClient.node.settings());
        }
    }

    private static final class MasterNodePredicate
    implements Predicate<NodeAndClient> {
        private final String masterNodeName;

        MasterNodePredicate(String masterNodeName) {
            this.masterNodeName = masterNodeName;
        }

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return this.masterNodeName.equals(nodeAndClient.name);
        }
    }

    private static final class DataOrMasterNodePredicate
    implements Predicate<NodeAndClient> {
        private DataOrMasterNodePredicate() {
        }

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return DiscoveryNode.isDataNode((Settings)nodeAndClient.node.settings()) || DiscoveryNode.isMasterNode((Settings)nodeAndClient.node.settings());
        }
    }

    private static final class DataNodePredicate
    implements Predicate<NodeAndClient> {
        private DataNodePredicate() {
        }

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return DiscoveryNode.isDataNode((Settings)nodeAndClient.node.settings());
        }
    }

    static class TransportClientFactory {
        private final boolean sniff;
        private final Settings settings;
        private final Path baseDir;
        private final Collection<Class<? extends Plugin>> plugins;

        TransportClientFactory(boolean sniff, Settings settings, Path baseDir, Collection<Class<? extends Plugin>> plugins) {
            this.sniff = sniff;
            this.settings = settings != null ? settings : Settings.EMPTY;
            this.baseDir = baseDir;
            this.plugins = plugins;
        }

        public Client client(Node node, String clusterName) {
            TransportAddress addr = ((TransportService)node.injector().getInstance(TransportService.class)).boundAddress().publishAddress();
            Settings nodeSettings = node.settings();
            Settings.Builder builder = Settings.builder().put("client.transport.nodes_sampler_interval", "1s").put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), this.baseDir}).put("node.name", InternalTestCluster.TRANSPORT_CLIENT_PREFIX + node.settings().get("node.name")).put(ClusterName.CLUSTER_NAME_SETTING.getKey(), clusterName).put("client.transport.sniff", this.sniff).put("logger.prefix", nodeSettings.get("logger.prefix", "")).put("logger.level", nodeSettings.get("logger.level", "INFO")).put(this.settings);
            if (NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings)) {
                builder.put("transport.type", (String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings));
            }
            MockTransportClient client = new MockTransportClient(builder.build(), this.plugins);
            client.addTransportAddress(addr);
            return client;
        }
    }

    private final class NodeAndClient
    implements Closeable {
        private MockNode node;
        private Client nodeClient;
        private Client transportClient;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final String name;
        private final int nodeAndClientId;

        NodeAndClient(String name, MockNode node, int nodeAndClientId) {
            this.node = node;
            this.name = name;
            this.nodeAndClientId = nodeAndClientId;
            InternalTestCluster.this.markNodeDataDirsAsNotEligableForWipe(node);
        }

        Node node() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.node;
        }

        public int nodeAndClientId() {
            return this.nodeAndClientId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMasterEligible() {
            return (Boolean)Node.NODE_MASTER_SETTING.get(this.node.settings());
        }

        Client client(Random random) {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            double nextDouble = random.nextDouble();
            if (nextDouble < InternalTestCluster.this.transportClientRatio) {
                if (InternalTestCluster.this.logger.isTraceEnabled()) {
                    InternalTestCluster.this.logger.trace("Using transport client for node [{}] sniff: [{}]", (Object)this.node.settings().get("node.name"), (Object)false);
                }
                return this.getOrBuildTransportClient();
            }
            return this.getOrBuildNodeClient();
        }

        Client nodeClient() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.getOrBuildNodeClient();
        }

        Client transportClient() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.getOrBuildTransportClient();
        }

        private Client getOrBuildNodeClient() {
            if (this.nodeClient == null) {
                this.nodeClient = this.node.client();
            }
            return (Client)InternalTestCluster.this.clientWrapper.apply(this.nodeClient);
        }

        private Client getOrBuildTransportClient() {
            if (this.transportClient == null) {
                this.transportClient = new TransportClientFactory(false, InternalTestCluster.this.nodeConfigurationSource.transportClientSettings(), InternalTestCluster.this.baseDir, InternalTestCluster.this.nodeConfigurationSource.transportClientPlugins()).client(this.node, InternalTestCluster.this.clusterName);
            }
            return (Client)InternalTestCluster.this.clientWrapper.apply(this.transportClient);
        }

        void resetClient() throws IOException {
            if (!this.closed.get()) {
                Releasables.close((Releasable[])new Releasable[]{this.nodeClient, this.transportClient});
                this.nodeClient = null;
                this.transportClient = null;
            }
        }

        void startNode() {
            try {
                this.node.start();
            }
            catch (NodeValidationException e) {
                throw new RuntimeException(e);
            }
        }

        void closeNode() throws IOException {
            InternalTestCluster.this.markNodeDataDirsAsPendingForWipe(this.node);
            this.node.close();
        }

        void restart(RestartCallback callback, boolean clearDataIfNeeded, int minMasterNodes) throws Exception {
            if (!this.node.isClosed()) {
                this.closeNode();
            }
            this.recreateNodeOnRestart(callback, clearDataIfNeeded, minMasterNodes);
            this.startNode();
        }

        void recreateNodeOnRestart(RestartCallback callback, boolean clearDataIfNeeded, int minMasterNodes) throws Exception {
            assert (callback != null);
            Settings callbackSettings = callback.onNodeStopped(this.name);
            Settings.Builder newSettings = Settings.builder();
            if (callbackSettings != null) {
                newSettings.put(callbackSettings);
            }
            if (minMasterNodes >= 0) {
                assert (!ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.exists(newSettings.build())) : "min master nodes is auto managed";
                newSettings.put(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey(), minMasterNodes).build();
            }
            if (clearDataIfNeeded) {
                this.clearDataIfNeeded(callback);
            }
            this.createNewNode(newSettings.build());
            this.resetClient();
        }

        private void clearDataIfNeeded(RestartCallback callback) throws IOException {
            NodeEnvironment nodeEnv;
            if (callback.clearData(this.name) && (nodeEnv = this.node.getNodeEnvironment()).hasNodeFile()) {
                Object[] locations = nodeEnv.nodeDataPaths();
                InternalTestCluster.this.logger.debug("removing node data paths: [{}]", (Object)Arrays.toString(locations));
                IOUtils.rm((Path[])locations);
            }
        }

        private void createNewNode(Settings newSettings) {
            long newIdSeed = (Long)NodeEnvironment.NODE_ID_SEED_SETTING.get(this.node.settings()) + 1L;
            Settings finalSettings = Settings.builder().put(this.node.settings()).put(newSettings).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), newIdSeed).build();
            if (!ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.exists(finalSettings)) {
                throw new IllegalStateException(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey() + " is not configured after restart of [" + this.name + "]");
            }
            Collection<Class<? extends Plugin>> plugins = this.node.getClasspathPlugins();
            this.node = new MockNode(finalSettings, plugins);
            InternalTestCluster.this.markNodeDataDirsAsNotEligableForWipe(this.node);
        }

        @Override
        public void close() throws IOException {
            try {
                this.resetClient();
            }
            finally {
                this.closed.set(true);
                this.closeNode();
            }
        }
    }
}

