/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterServiceUtils {
    public static ClusterService createClusterService(ThreadPool threadPool) {
        DiscoveryNode discoveryNode = new DiscoveryNode("node", (TransportAddress)LocalTransportAddress.buildUnique(), Collections.emptyMap(), EnumSet.allOf(DiscoveryNode.Role.class), Version.CURRENT);
        return ClusterServiceUtils.createClusterService(threadPool, discoveryNode);
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode) {
        return ClusterServiceUtils.createClusterService(Settings.EMPTY, threadPool, localNode);
    }

    public static ClusterService createClusterService(Settings settings, ThreadPool threadPool, DiscoveryNode localNode) {
        ClusterService clusterService = new ClusterService(Settings.builder().put("cluster.name", "ClusterServiceTests").put(settings).build(), new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool, () -> localNode);
        clusterService.setNodeConnectionsService(new NodeConnectionsService(Settings.EMPTY, null, null){

            public void connectToNodes(DiscoveryNodes discoveryNodes) {
            }

            public void disconnectFromNodesExcept(DiscoveryNodes nodesToKeep) {
            }
        });
        clusterService.setClusterStatePublisher((event, ackListener) -> {});
        clusterService.setDiscoverySettings(new DiscoverySettings(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS)));
        clusterService.start();
        DiscoveryNodes.Builder nodes = DiscoveryNodes.builder((DiscoveryNodes)clusterService.state().nodes());
        nodes.masterNodeId(clusterService.localNode().getId());
        ClusterServiceUtils.setState(clusterService, ClusterState.builder((ClusterState)clusterService.state()).nodes(nodes));
        return clusterService;
    }

    public static ClusterService createClusterService(ClusterState initialState, ThreadPool threadPool) {
        ClusterService clusterService = ClusterServiceUtils.createClusterService(threadPool);
        ClusterServiceUtils.setState(clusterService, initialState);
        return clusterService;
    }

    public static void setState(ClusterService clusterService, ClusterState.Builder clusterStateBuilder) {
        ClusterServiceUtils.setState(clusterService, clusterStateBuilder.build());
    }

    public static void setState(ClusterService clusterService, final ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        clusterService.submitStateUpdateTask("test setting state", (ClusterStateTaskConfig)new LocalClusterUpdateTask(){

            public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) throws Exception {
                return 2.newState((ClusterState)ClusterState.builder((ClusterState)clusterState).version(currentState.version() + 1L).build());
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                latch.countDown();
            }

            public void onFailure(String source, Exception e) {
                TestCase.fail((String)("unexpected exception" + e));
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException("unexpected interruption", (Throwable)e, new Object[0]);
        }
    }
}

