/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class BaseAggregationTestCase<AB extends AbstractAggregationBuilder<AB>>
extends ESTestCase {
    protected static final String STRING_FIELD_NAME = "mapped_string";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    protected static final String IP_FIELD_NAME = "mapped_ip";
    private String[] currentTypes;
    private NamedWriteableRegistry namedWriteableRegistry;
    private NamedXContentRegistry xContentRegistry;

    protected String[] getCurrentTypes() {
        return this.currentTypes;
    }

    protected abstract AB createTestAggregatorBuilder();

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    public void setUp() throws Exception {
        super.setUp();
        Settings settings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(new Object[]{Environment.PATH_HOME_SETTING.getKey(), BaseAggregationTestCase.createTempDir()}).build();
        IndicesModule indicesModule = new IndicesModule(Collections.emptyList());
        PluginsService pluginsService = new PluginsService(settings, null, null, this.getPlugins());
        SearchModule searchModule = new SearchModule(settings, false, pluginsService.filterPlugins(SearchPlugin.class));
        ArrayList entries = new ArrayList();
        entries.addAll(indicesModule.getNamedWriteables());
        entries.addAll(searchModule.getNamedWriteables());
        this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
        this.xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
        this.currentTypes = new String[BaseAggregationTestCase.randomIntBetween(0, 5)];
        for (int i = 0; i < this.currentTypes.length; ++i) {
            String type;
            this.currentTypes[i] = type = BaseAggregationTestCase.randomAlphaOfLengthBetween(1, 10);
        }
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.xContentRegistry;
    }

    public void testFromXContent() throws IOException {
        AB testAgg = this.createTestAggregatorBuilder();
        AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder().addAggregator(testAgg);
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)BaseAggregationTestCase.randomFrom(XContentType.values()));
        if (BaseAggregationTestCase.randomBoolean()) {
            builder.prettyPrint();
        }
        factoriesBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
        XContentBuilder shuffled = this.shuffleXContent(builder, new String[0]);
        XContentParser parser = this.createParser(shuffled);
        AggregationBuilder newAgg = this.parse(parser);
        BaseAggregationTestCase.assertNotSame((Object)newAgg, testAgg);
        BaseAggregationTestCase.assertEquals(testAgg, (Object)newAgg);
        BaseAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)newAgg.hashCode());
    }

    protected AggregationBuilder parse(XContentParser parser) throws IOException {
        QueryParseContext parseContext = new QueryParseContext(parser);
        BaseAggregationTestCase.assertSame((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((QueryParseContext)parseContext);
        BaseAggregationTestCase.assertThat((Object)parsed.getAggregatorFactories(), (Matcher)Matchers.hasSize((int)1));
        BaseAggregationTestCase.assertThat((Object)parsed.getPipelineAggregatorFactories(), (Matcher)Matchers.hasSize((int)0));
        AggregationBuilder newAgg = (AggregationBuilder)parsed.getAggregatorFactories().get(0);
        BaseAggregationTestCase.assertNull((Object)parser.nextToken());
        BaseAggregationTestCase.assertNotNull((Object)newAgg);
        return newAgg;
    }

    public void testSerialization() throws IOException {
        AB testAgg = this.createTestAggregatorBuilder();
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.writeNamedWriteable(testAgg);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry);){
                AggregationBuilder deserialized = (AggregationBuilder)in.readNamedWriteable(AggregationBuilder.class);
                BaseAggregationTestCase.assertEquals(testAgg, (Object)deserialized);
                BaseAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)deserialized.hashCode());
                BaseAggregationTestCase.assertNotSame(testAgg, (Object)deserialized);
            }
        }
    }

    public void testEqualsAndHashcode() throws IOException {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestAggregatorBuilder(), this::copyAggregation);
    }

    /*
     * Exception decompiling
     */
    private AB copyAggregation(AB agg) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String randomNumericField() {
        int randomInt = BaseAggregationTestCase.randomInt(3);
        switch (randomInt) {
            case 0: {
                return DATE_FIELD_NAME;
            }
            case 1: {
                return DOUBLE_FIELD_NAME;
            }
        }
        return INT_FIELD_NAME;
    }

    protected void randomFieldOrScript(ValuesSourceAggregationBuilder<?, ?> factory, String field) {
        int choice = BaseAggregationTestCase.randomInt(2);
        switch (choice) {
            case 0: {
                factory.field(field);
                break;
            }
            case 1: {
                factory.field(field);
                factory.script(BaseAggregationTestCase.mockScript("_value + 1"));
                break;
            }
            case 2: {
                factory.script(BaseAggregationTestCase.mockScript("doc[" + field + "] + 1"));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknow random operation [" + choice + "]"));
            }
        }
    }
}

